# tftpd detect
# template from external_svc_ident.nasl
if (description)
{
 script_id(80100);
 script_version("1.0");
 script_tag(name:"risk_factor", value:"None");

 desc = "
Synopsis :

The remote host has TFTP server running.

Description :

The remote host has TFTP server running. TFTP stands 
for Trivial File Transfer Protocol.

Solution : 

Disable TFTP server if not used.

Risk factor : 

None";

 script_description( desc);
 script_copyright("(C) 2009 Vlatko Kosturjak");
 script_name( "TFTP detection");
 script_category(ACT_GATHER_INFO);
 script_family( "Service detection");
 script_summary( "Detects TFTP server");

 exit(0);
}

include('misc_func.inc');
include('global_settings.inc');

foundtftp=0;

# taken from tftpd_dir_trav.nasl, adapted a bit
function tftp_grab(port, file, mode)
{
 local_var      req, rep, sport, ip, u, filter, data, i;

 req = '\x00\x01'+file+'\0'+mode+'\0';
 sport = rand() % 64512 + 1024;

 ip = forge_ip_packet(ip_hl : 5, ip_v: 4,  ip_tos:0, 
        ip_len:20, ip_off:0, ip_ttl:64, ip_p:IPPROTO_UDP,
        ip_src: this_host());
                     
 u = forge_udp_packet(ip:ip, uh_sport: sport, uh_dport:port, uh_ulen: 8 + strlen(req), data:req);

 filter = 'udp and dst port ' + sport + ' and src host ' + get_host_ip() + ' and udp[8:1]=0x00';

 data = NULL;
 for (i = 0; i < 2; i ++)       # Try twice
 {
  rep = send_packet(u, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
  if(rep)
  {
   if (debug_level > 2) dump(ddata: rep, dtitle: 'TFTP (IP)');
   data = get_udp_element(udp: rep, element:"data");
   if (debug_level > 1) dump(ddata: data, dtitle: 'TFTP (UDP)');
   if (data[0] == '\0')
   {
	if (data[1] == '\x03' || data[1] =='\x05') {
		foundtftp=1;
	}
   }
   else
     return NULL;
  }
 }
 return NULL;
}

port=69;
rndfile="nonexistant-"+rand_str();

# test valid modes according to RFC-783 
tftp_grab (port:port, file:rndfile, mode:"netascii");
tftp_grab (port:port, file:rndfile, mode:"octet");
tftp_grab (port:port, file:rndfile, mode:"mail");

if (foundtftp==1) {
	register_service(port: port, ipproto: "udp", proto: "tftp");
	security_note(port:port, proto:"udp");
}

