##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_solarwinds_tftp_server_detect.nasl 4612 2009-09-16 11:47:05Z sep $
#
# SolarWinds TFTP Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900930);
  script_version ("$Revision: 1.0$");
  script_tag(name:"risk_factor", value:"None");
  script_name("SolarWinds TFTP Server Version Detection");
  desc = "
  Overview: This script detects installed version of SolarWinds TFTP Server
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB of SolarWinds TFTP Server Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

stftpKey = "SOFTWARE\";
foreach item(registry_enum_keys(key:stftpKey))
{
  if("SolarWinds" >< item)
  {
    stftpPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                                item:"ProgramFilesDir");
    if(stftpPath != NULL)
    {
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:stftpPath);
      file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",  string:stftpPath +
                                         "\SolarWinds\TFTPServer\TFTPServer.exe");
      stftpVer = GetVer(share:share, file:file);
      if(isnull(stftpVer))
      {
        file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:stftpPath +
                                        "\SolarWinds\Free Tools\TFTP-Server.exe");
        stftpVer = GetVer(share:share, file:file);
      }
      if(stftpVer){
        set_kb_item(name:"SolarWinds/TFTP/Ver", value:stftpVer);
        security_note(data:"SolarWinds TFTP Server version " + stftpVer +
                           " was detected on the host");
      }
    }
  }
}
