###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opera_detection_win_900036.nasl 136 2008-08-21 19:54:55Z aug $
#
# Opera Version Detection for Linux
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# Modified to detect Beta Versions
#  - Sharath S <sharaths@secpod.com> On 2009-09-02
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900037);
  script_version("$Revision: 1.4 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Opera Version Detection for Linux");
  desc = "
  Overview : This script finds the Opera Web browser installed version on
  windows through the Opera.exe file and saves the version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set file version of Opera in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}


grep = find_bin(prog_name:"grep", sock:sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("Opera [0-9]\\+\\.[0-9]\\+");
garg[5] = string("Internal\\ build\\ [0-9]\\+");
garg[6] = string("Build\\ number:.*");

operaName = find_file(file_name:"opera", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);

foreach binaryName(operaName)
{
  binaryName = chomp(binaryName);
  if(islocalhost())
  {
    garg[4] = binaryName;
    arg1 = garg;
  }
  else
  {
    arg1 = garg[0] + " " + garg[1] + " " + garg[2] + " " + raw_string(0x22) +
          garg[3] + raw_string(0x22) + " " + binaryName;
    arg2 = garg[0] + " " + garg[1] + " " + garg[2] + " " + raw_string(0x22) +
          garg[5] + raw_string(0x22) + " " + binaryName;
    arg3 = garg[0] + " " + garg[1] + " " + garg[2] + " " + raw_string(0x22) +
          garg[6] + raw_string(0x22) + " " + binaryName;
  }

  operaVer = get_bin_version(full_prog_name:grep, version_argv:arg1,
                             ver_pattern:"Opera ([0-9]+\.[0-9]+)", sock:sock);

  if(!isnull(operaVer[1]))
  {
    set_kb_item(name:"Opera/Linux/Version", value:operaVer[1]);
    security_note(data:"Opera browser version " + operaVer[1] + " running at "+
                       "location " + binaryName +  " was detected on the host");

    operaBuildVer = get_bin_version(full_prog_name:grep, version_argv:arg2,
                    ver_pattern:"Internal [B|b]uild ([0-9]+)", sock:sock);

    if(!operaBuildVer[1])
    {
      operaBuildVer = get_bin_version(full_prog_name:grep, version_argv:arg3,
                                      ver_pattern:"Build number:.*", sock:sock);
      operaBuildVer = operaBuildVer[1] - raw_string(0x00);
      operaBuildVer = eregmatch(pattern:"Build number:([0-9]+)",
                                string:operaBuildVer);
    }

    if(!isnull(operaBuildVer[1]))
    {
      buildVer = operaVer[1] + "." + operaBuildVer[1];
      set_kb_item(name:"Opera/Build/Linux/Ver", value:buildVer);
      ssh_close_connection();
    }
  }
}
