#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Karol Wiesek - iDEFENSE 
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15394);
 script_bugtraq_id(11216, 11281);
 script_cve_id("CVE-2004-0815");
 script_version ("$Revision: 7540 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Samba Remote Arbitrary File Access";

 script_name(name);
 
 desc = "
The remote Samba server, according to its version number, is vulnerable 
to a remote file access vulnerability.  


This vulnerability allows an attacker to access arbitrary files which exist
outside of the shares's defined path.

An attacker needs a valid account to exploit this flaw.

Solution : Upgrade to Samba 2.2.11 or 3.0.7
Risk factor : High";


 script_description(desc);
 
 summary = "checks samba version";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
  
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 
 family = "Remote file access";
 script_family(family);
 script_dependencie("smb_nativelanman.nasl");
 script_require_keys("SMB/NativeLanManager");
 exit(0);
}

#
# The script code starts here
#

lanman = get_kb_item("SMB/NativeLanManager");
if("Samba" >< lanman)
{
 if(ereg(pattern:"Samba 2\.2\.([0-9]|10)[^0-9]*$",string:lanman))
   security_hole(139);
	 
 if(ereg(pattern:"Samba 3\.0\.[0-5]$", string:lanman))
   security_hole(139);
}
