###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpmyadmin_cve_2006_6942.nasl 8287 2010-07-05 10:40:56Z mime $
#
# phpMyAdmin Multiple Input Validation Vulnerabilities
#
# Authors:
# Michael Meyer
#
# phpMyAdmin Multiple Input Validation Vulnerabilities
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if (description)
{
 script_id(100068);
 script_bugtraq_id(21137);
 script_cve_id("CVE-2006-6942");
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");

 script_name("phpMyAdmin Multiple Input Validation Vulnerabilities");
 desc = "

 Overview:
  phpMyAdmin is prone to multiple input-validation vulnerabilities,
  including an HTML-injection vulnerability, cross-site
  scripting vulnerabilities, and information-disclosure
  vulnerabilities.

  An attacker could exploit these vulnerabilities to view sensitive
  information or to have arbitrary script code execute in the context
  of the affected site, which may allow the attacker to steal
  cookie-based authentication credentials or change the way the site
  is rendered to the user. Data gained could aid in further attacks.

 Solution:
  Vendor updates are available. Please see http://www.phpmyadmin.net for more
  Information.

 See also:
  http://www.securityfocus.com/bid/21137

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpMyAdmin is vulnerable to Multiple Input Validation Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("secpod_phpmyadmin_detect_900129.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


 include("http_func.inc");
 include("version_func.inc");
  
 port = get_http_port(default:80);

 if(!get_port_state(port))exit(0);
 if(!can_host_php(port:port))exit(0);

 version = eregmatch(pattern:"(.*) under (/.*)", string:get_kb_item("www/" + port + "/phpMyAdmin"));

 if(isnull(version[1]))exit(0); 

   if (version_is_less(version:version[1], test_version:"2.9.1.1") ) { 
        security_warning(port:port);
	exit(0);
   }

exit(0);

