#
# Script Written By Ferdy Riphagen 
# Script distributed under the GNU GPLv2 License. 
#

if (description) {
 script_id(9000001);
 script_version("$Revision: 1.0 $");
 script_tag(name:"risk_factor", value:"None");
 name = "OSSIM Server Detection";
 script_name(name);
 desc = "
Synopsis :

A OSSIM server is listening on the remote system. 

Description :

The remote system is running an OSSIM server. OSSIM (Open Source
Security Information Management) is a centralized security management 
information system. 

See also :

http://www.ossim.net

Solution :

If possible, filter incoming connections to the service so that it is
used by trusted sources only.

Risk factor :

None";
 script_description(desc);
 summary = "Checks for a OSSIM server on the default port tcp/40001";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2007 Ferdy Riphagen");

 script_dependencies("find_service1.nasl");
 script_require_ports("Services/unknown", 40001);
 exit(0);
}

include("misc_func.inc");

port = get_unknown_svc(40001);
if (!port) port = 40001;
if (known_service(port:port)) exit(0);
if (!get_port_state(port)) exit(0);
soc = open_sock_tcp(port);
if (soc) { 
	rand = rand() % 10;
	data = 'connect id="' + rand + '" type="sensor"\n'; 
	send(socket:soc, data:data);
	recv = recv(socket:soc, length:64);

	if (recv == 'ok id="' + rand + '"\n') {
		security_note(port:port);
		register_service(port:port, ipproto:"tcp", proto:"ossim_server");
	}
}
exit(0);
