###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# mod_perl version Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100129);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("mod_perl version Detection");  

 desc = "

 Overview:
  Get the Version of mod_perl and store it in KB.

 Risk factor : None";

 script_description(desc);
 script_summary("Store version of mod_perl in KB");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(get_kb_item("Services/www/" + port + "/embedded"))exit(0);

if(!banner = get_http_banner(port))exit(0);
if(!egrep(pattern:"Server: .*Apache", string:banner))exit(0);

if(!matches = eregmatch(string:banner, pattern:"mod_perl/([0-9.]+)"))exit(0);

if(!isnull(matches[1])) {
    
  set_kb_item(name: string("www/", port, "/mod_perl"), value: string(matches[1]));

}

exit(0);
