###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for fuse vulnerability USN-892-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840378);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "892-1");
  script_cve_id("CVE-2009-3297");
  script_name("Ubuntu Update for fuse vulnerability USN-892-1");
  desc = "

  Vulnerability Insight:

  Ronald Volgers discovered that FUSE did not correctly check mount
  locations.  A local attacker, with access to use FUSE, could unmount
  arbitrary locations, leading to a denial of service.

  Affected Software/OS:
  fuse vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001040.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of fuse vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"fuse-utils", ver:"2.7.4-1.1ubuntu4.0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse-dev", ver:"2.7.4-1.1ubuntu4.0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse2", ver:"2.7.4-1.1ubuntu4.0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libfuse-dev", ver:"2.4.2-0ubuntu3.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse2", ver:"2.4.2-0ubuntu3.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fuse-utils", ver:"2.4.2-0ubuntu3.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fuse-source", ver:"2.4.2-0ubuntu3.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"fuse-utils", ver:"2.7.3-4ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse-dev", ver:"2.7.3-4ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse2", ver:"2.7.3-4ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fuse-source", ver:"2.7.3-4ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"fuse-utils", ver:"2.7.2-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse-dev", ver:"2.7.2-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse2", ver:"2.7.2-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fuse-source", ver:"2.7.2-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"fuse-utils", ver:"2.7.4-1.1ubuntu4.3", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse-dev", ver:"2.7.4-1.1ubuntu4.3", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libfuse2", ver:"2.7.4-1.1ubuntu4.3", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}