###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mysql-dfsg-5.0 regression USN-588-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840240);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "588-2");
  script_cve_id("CVE-2007-2692", "CVE-2006-7232", "CVE-2007-6303", "CVE-2008-0226", "CVE-2008-0227");
  script_name( "Ubuntu Update for mysql-dfsg-5.0 regression USN-588-2");
  desc = "

  Vulnerability Insight:

  USN-588-1 fixed vulnerabilities in MySQL. In fixing CVE-2007-2692 for
  Ubuntu 6.06, additional improvements were made to make privilege checks
  more restictive. As a result, an upstream bug was exposed which could
  cause operations on tables or views in a different database to fail. This
  update fixes the problem.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  Masaaki Hirose discovered that MySQL could be made to dereference
  a NULL pointer. An authenticated user could cause a denial of service
  (application crash) via an EXPLAIN SELECT FROM on the INFORMATION_SCHEMA
  table. This issue only affects Ubuntu 6.06 and 6.10. (CVE-2006-7232)
  
  Alexander Nozdrin discovered that MySQL did not restore database access
  privileges when returning from SQL SECURITY INVOKER stored routines. An
  authenticated user could exploit this to gain privileges. This issue
  does not affect Ubuntu 7.10. (CVE-2007-2692)
  
  Martin Friebe discovered that MySQL did not properly update the DEFINER
  value of an altered view. An authenticated user could use CREATE SQL
  SECURITY DEFINER VIEW and ALTER VIEW statements to gain privileges.
  (CVE-2007-6303)
  
  Luigi Auriemma discovered that yaSSL as included in MySQL did not
  properly validate its input. A remote attacker could send crafted
  requests and cause a denial of service or possibly execute arbitrary
  code. This issue did not affect Ubuntu 6.06 in the default installation.
  (CVE-2008-0226, CVE-2008-0227)

  Affected Software/OS:
  mysql-dfsg-5.0 regression on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-April/000687.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mysql-dfsg-5.0 regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.22-0ubuntu6.06.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.22-0ubuntu6.06.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0_5.0.22-0ubuntu6.06.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0_5.0.22-0ubuntu6.06.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.22-0ubuntu6.06.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.22-0ubuntu6.06.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.22-0ubuntu6.06.9", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}