###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_twiki_csrf_vuln.nasl 2120 2009-05-06 17:16:17Z may $
#
# TWiki Cross-Site Request Forgery Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800400);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1339");
  script_name("TWiki Cross-Site Request Forgery Vulnerability");
  desc = "

  Overview: The host is running TWiki and is prone to Cross-Site Request
  Forgery Vulnerability.

  Vulnerability Insight:
  Remote authenticated user can create a specially crafted image tag that,
  when viewed by the target user, will update pages on the target system
  with the privileges of the target user via HTTP requests.

  Impact:
  Successful exploitation will let the attacker to gain administrative
  privileges on the target application and can cause CSRF attack.

  Impact Level: Application

  Affected Software/OS:
  TWiki version prior to 4.3.1

  Fix: Upgrade to version 4.3.1 or later,
  http://twiki.org/cgi-bin/view/Codev/DownloadTWiki

  References:
  http://secunia.com/advisories/34880
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=526258
  http://twiki.org/p/pub/Codev/SecurityAlert-CVE-2009-1339/TWiki-4.3.0-c-diff-cve-2009-1339.txt

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of TWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_twiki_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

twikiPort = get_http_port(default:80);
if(!twikiPort){
  exit(0);
}

twikiVer = get_kb_item("www/" + twikiPort + "/TWiki");
twikiVer = eregmatch(pattern:"^(.+) under (/.*)$", string:twikiVer);
if(twikiVer[1] != NULL)
{
  if(version_is_less(version:twikiVer[1], test_version:"4.3.1")){
    security_warning(twikiPort);
  }
}
