###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for krb5, gss 112908-36
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855785);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "SUNSolve", value: "112908-36");
  script_cve_id("CVE-2009-0847", "CVE-2009-0845", "CVE-2009-0844", "CVE-2009-0846");
  script_name("Solaris Update for krb5, gss 112908-36");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  krb5, gss
  For more information please visit the below reference link.

  Affected Software/OS:
  krb5, gss on solaris_5.9_sparc

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-112908-36-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of krb5, gss");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.9", arch:"sparc", patch:"112908-36", package:"SUNWcarx.u SUNWgsskx SUNWcstl SUNWcstlx SUNWgssk SUNWgss SUNWkrbux SUNWcsr SUNWkrbr SUNWcar.u SUNWkrbu SUNWcar.us SUNWcarx.us SUNWgssx SUNWhea") < 0)
{
  security_hole(0);
  exit(0);
}