###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gale_detect.nasl 826 2009-01-15 17:26:24Z jan $
#
# Gale Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800339);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Gale Version Detection");
  desc = "
  Overview : This script finds the installed version of Gale and saves the
  result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of Gale");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

galePort = 11512;
if(!get_udp_port_state(galePort)){
  exit(0);
}

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_file(file_name:"gale-config",file_path:"/", useregex:TRUE,
                  regexpar:"$", sock:sock);
foreach galeBin (paths)
{
  galeVer = get_bin_version(full_prog_name:chomp(galeBin), sock:sock,
                            version_argv:"--version",
                            ver_pattern:"[0-9.A-Za-z]+");
  if(galeVer[0] != NULL)
  {
    set_kb_item(name:"Gale/Linux/Ver", value:galeVer[0]);
    security_note(data:"Gale version " + galeVer[0] + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
