###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_foxit_reader_mult_vuln_mar09.nasl 889 2009-03-11 17:15:33Z mar $
#
# Foxit Reader Multiple Vulnerabilities Mar-09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800537);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0836", "CVE-2009-0837", "CVE-2009-0191");
  script_bugtraq_id(34035);
  script_name("Foxit Reader Multiple Vulnerabilities Mar-09");
  desc = "

  Overview: The host is installed with Foxit  Reader and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  - application does not require user confirmation before performing dangerous
    actions
  - stack based buffer overflow while processing a PDF file containing an
    action with overly long filename argument
  - error while processing JBIG2 symbol dictionary segment with zero new
    symbols

  Impact:
  Successful exploitation will let attacker execute arbitrary code via
  relative and absolute paths and to dereference uninstalled memory.

  Impact Level: Application

  Affected Software/OS:
  Foxit Reader 2.3 before Build 3902 and 3.0 before Build 1506.

  Fix: Upgrade to the latest version.
  http://www.foxitsoftware.com/downloads/

  References:
  http://en.securitylab.ru/nvd/369876.php
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2009-0191
  http://www.security-database.com/detail.php?alert=CVE-2009-0837

 CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Foxit Reader");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_foxit_reader_detect.nasl");
  script_require_keys("Foxit/Reader/Ver");
  exit(0);
}


include("version_func.inc");

foxVer = get_kb_item("Foxit/Reader/Ver");
if(!foxVer){
  exit(0);
}

if(version_is_less(version:foxVer, test_version:"2.3.2008.3902")||
  (version_in_range(version:foxVer, test_version:"3.0",
                                    test_version2:"3.0.2009.1505"))){
  security_hole(0);
}
