###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_flashlight_sql_inj_n_dir_trav_vuln.nasl 6076 2009-12-07 15:11:27Z dec $
#
# Flashlight Free Edition SQL Injection and Directory Traversal Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801075);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-4204","CVE-2009-4205");
  script_name("Flashlight Free Edition SQL Injection and Directory Traversal Vulnerability");
  desc = "
  Overview: The host is running Flashlight Free Edition and is prone to SQL
  Injection and Directory Traversal Vulnerability.

  Vulnerability Insight:
  Flaws are due to:
  - An error in 'read.php' which is not properly sanitizing user supplied input
    before being used in SQL queries via 'id' parameter.
  - An error in 'admin.php' which is not properly sanitizing user supplied input
    before being used via a .. (dot dot) in the action 'parameter' which causes
    directory traversal attacks in the application context.

  Impact:
  Successful exploitation could allow remote attackers to view, add, modify
  or delete information in the back end database or include arbitrary files
  from local and remote resources to compromise a vulnerable server.

  Impact Level: Network/System.

  Affected Software/OS:
  Flashlight Free version 1.0 on all running platform.

  Fix:
  No solution or patch is available as on 07th December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://scripts.ringsworld.com/communication-tools

  References:
  http://www.milw0rm.com/exploits/8856
  http://xforce.iss.net/xforce/xfdb/50906

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 6.7
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Flashlight");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_dependencies("gb_flashlight_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

fPort = get_http_port(default:80);
if(!fPort){
  exit(0);
}

fVer = get_kb_item("www/" + fPort + "/Flashlight/Free");
if(!fVer){
  exit(0);
}

fVer = eregmatch(pattern:"^(.+) under (/.*)$", string:fVer);
if(fVer[1] != NULL)
{
  if(version_is_equal(version:fVer[1], test_version:"1.0")){
    security_hole(fPort);
  }
}
