###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for php-Smarty FEDORA-2008-8945
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860545);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-8945");
  script_name( "Fedora Update for php-Smarty FEDORA-2008-8945");
  desc = "

  Vulnerability Insight:
  Although Smarty is known as a &quot;Template Engine&quot;, it would be more accurately
  described as a &quot;Template/Presentation Framework.&quot; That is, it provides the
  programmer and template designer with a wealth of tools to automate tasks
  commonly dealt with at the presentation layer of an application. I stress the
  word Framework because Smarty is not a simple tag-replacing template engine.
  Although it can be used for such a simple purpose, its focus is on quick and
  painless development and deployment of your application, while maintaining
  high-performance, scalability, security and future growth.


  Affected Software/OS:
  php-Smarty on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00522.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of php-Smarty");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"php-Smarty", rpm:"php-Smarty~2.6.20~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}