###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for zaptel FEDORA-2007-3094
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861317);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-3094");
  script_cve_id("CVE-2007-5690");
  script_name( "Fedora Update for zaptel FEDORA-2007-3094");
  desc = "

  Vulnerability Insight:
  Tools and libraries for using/configuring/monitoring Zapata telephony
  interfaces.


  Affected Software/OS:
  zaptel on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00594.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of zaptel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"zaptel", rpm:"zaptel~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-debuginfo", rpm:"zaptel-debuginfo~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel", rpm:"zaptel~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-utils", rpm:"zaptel-utils~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-devel", rpm:"zaptel-devel~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-lib", rpm:"zaptel-lib~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-lib", rpm:"zaptel-lib~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-utils", rpm:"zaptel-utils~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-devel", rpm:"zaptel-devel~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel-debuginfo", rpm:"zaptel-debuginfo~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"zaptel", rpm:"zaptel~1.4.6~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}