###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for emacs FEDORA-2007-2946
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861435);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.3");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-2946");
  script_cve_id("CVE-2007-5795");
  script_name( "Fedora Update for emacs FEDORA-2007-2946");
  desc = "

  Vulnerability Insight:
  Emacs is a powerful, customizable, self-documenting, modeless text
  editor. Emacs contains special code editing features, a scripting
  language (elisp), and the capability to read mail, news, and more
  without leaving the editor.
  
  This package provides an emacs binary with support for X windows.


  Affected Software/OS:
  emacs on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00514.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of emacs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"emacs", rpm:"emacs~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-debuginfo", rpm:"emacs-debuginfo~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-nox", rpm:"emacs-nox~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-el", rpm:"emacs-el~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-common", rpm:"emacs-common~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs", rpm:"emacs~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-el", rpm:"emacs-el~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs", rpm:"emacs~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-debuginfo", rpm:"emacs-debuginfo~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-common", rpm:"emacs-common~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-nox", rpm:"emacs-nox~22.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}