###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for glib2 FEDORA-2007-2944
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861164);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-2944");
  script_name( "Fedora Update for glib2 FEDORA-2007-2944");
  desc = "

  Vulnerability Insight:
  GLib is the low-level core library that forms the basis
  for projects such as GTK+ and GNOME. It provides data structure
  handling for C, portability wrappers, and interfaces for such runtime
  functionality as an event loop, threads, dynamic loading, and an
  object system.
  
  This package provides version 2 of GLib.


  Affected Software/OS:
  glib2 on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00172.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of glib2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2-debuginfo", rpm:"glib2-debuginfo~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2-static", rpm:"glib2-static~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2-debuginfo", rpm:"glib2-debuginfo~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"glib2-static", rpm:"glib2-static~2.14.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}