###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for nspr FEDORA-2007-279
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861085);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-279");
  script_cve_id("CVE-2007-0008", "CVE-2007-0009");
  script_name( "Fedora Update for nspr FEDORA-2007-279");
  desc = "

  Vulnerability Insight:
  NSPR provides platform independence for non-GUI operating system
  facilities. These facilities include threads, thread synchronization,
  normal file and network I/O, interval timing and calendar time, basic
  memory management (malloc and free) and shared library linking.


  Affected Software/OS:
  nspr on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-February/msg00143.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nspr");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"nspr", rpm:"nspr~4.6.5~0.6.0.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/nspr-devel", rpm:"x86_64/nspr-devel~4.6.5~0.6.0.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/nspr", rpm:"x86_64/nspr~4.6.5~0.6.0.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/nspr-debuginfo", rpm:"x86_64/debug/nspr-debuginfo~4.6.5~0.6.0.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/nspr", rpm:"i386/nspr~4.6.5~0.6.0.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/nspr-debuginfo", rpm:"i386/debug/nspr-debuginfo~4.6.5~0.6.0.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/nspr-devel", rpm:"i386/nspr-devel~4.6.5~0.6.0.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}