##############################################i#################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_reader_mult_vuln_jan10_lin.nasl 6758 2010-01-14 20:50:29Z jan $
#
# Adobe Reader Multiple Vulnerabilities -jan10 (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800428);
  script_version("$Revision: 8133 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3953", "CVE-2009-3954", "CVE-2009-3955", "CVE-2009-3956",
                "CVE-2009-3957", "CVE-2009-3958", "CVE-2009-3959", "CVE-2009-4324");
  script_bugtraq_id(37758, 37761, 37757, 37763, 37760, 37759, 37756);
  script_name("Adobe Reader Multiple Vulnerabilities -jan10 (Linux)");
  desc = "
  Overview: This host is installed with Adobe Reader and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  For more information refer,
  http://www.adobe.com/support/security/bulletins/apsb10-02.html

  Impact:
  Successful exploitation will let the attacker cause memory corruption or
  denial of service.

  Impact level: System/Application.

  Affected Software/OS:
  Adobe Reader and Acrobat 9.x before 9.3 on Linux.

  Fix: Apply the patch or upgrade Adobe Reader 9.3
  http://www.adobe.com/downloads/
  http://www.adobe.com/support/security/bulletins/apsb10-02.html

  *****
  NOTE: Please ignore this warning if the patch is already applied.
  *****

  References:
  http://www.adobe.com/support/security/bulletins/apsb10-02.html

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
   Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Adobe Reader");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_adobe_prdts_detect_lin.nasl");
  script_require_keys("Adobe/Reader/Linux/Version");
  exit(0);
}


include("version_func.inc");

readerVer = get_kb_item("Adobe/Reader/Linux/Version");
if(readerVer != NULL)
{
  # Grep for Adobe Reader version prior to 9.x
  if(version_in_range(version:readerVer, test_version:"9.0", test_version2:"9.2")){
    security_hole(0);
  }
}
