###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for seamonkey CESA-2008:0104 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880054);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "CESA", value: "2008:0104");
  script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0415", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593");
  script_name( "CentOS Update for seamonkey CESA-2008:0104 centos3 x86_64");
  desc = "

  Vulnerability Insight:
  SeaMonkey is an open source Web browser, advanced email and newsgroup
  client, IRC chat client, and HTML editor.
  
  Several flaws were found in the way SeaMonkey processed certain malformed
  web content. A webpage containing malicious content could cause SeaMonkey
  to crash, or potentially execute arbitrary code as the user running
  SeaMonkey. (CVE-2008-0412, CVE-2008-0413, CVE-2008-0415, CVE-2008-0419)
  
  Several flaws were found in the way SeaMonkey displayed malformed web
  content. A webpage containing specially-crafted content could trick a user
  into surrendering sensitive information. (CVE-2008-0591, CVE-2008-0593)
  
  A flaw was found in the way SeaMonkey stored password data. If a user
  saves login information for a malicious website, it could be possible
  to corrupt the password database, preventing the user from properly
  accessing saved password data. (CVE-2008-0417)
  
  A flaw was found in the way SeaMonkey handles certain chrome URLs. If a
  user has certain extensions installed, it could allow a malicious website
  to steal sensitive session data. Note: this flaw does not affect a default
  installation of SeaMonkey. (CVE-2008-0418)
  
  A flaw was found in the way SeaMonkey saves certain text files. If a
  website offers a file of type &quot;plain/text&quot;, rather than &quot;text/plain&quot;,
  SeaMonkey will not show future &quot;text/plain&quot; content to the user in the
  browser, forcing them to save those files locally to view the content.
  (CVE-2008-0592)
  
  Users of SeaMonkey are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  seamonkey on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-February/014662.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS3")
{

  if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.9.el3.centos3", rls:"CentOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
