# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8336 (apr)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64614);
 script_cve_id("CVE-2009-2412");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 11 FEDORA-2009-8336 (apr)");

 desc = "The remote host is missing an update to apr
announced via advisory FEDORA-2009-8336.

The mission of the Apache Portable Runtime (APR) is to provide a
free library of C data structures and routines, forming a system
portability layer to as many operating systems as possible,
including Unices, MS Win32, BeOS and OS/2.

Update Information:

CVE-2009-2412: allocator alignment fixes    Full details here:
http://www.apache.org/dist/apr/patches/
ChangeLog:

* Thu Aug  6 2009 Bojan Smojver  - 1.3.8-1
- bump up to 1.3.8
- CVE-2009-2412
- allocator alignment fixes
* Mon Jun  8 2009 Bojan Smojver  - 1.3.5-1
- bump up to 1.3.5
References:

[ 1 ] Bug #515698 - CVE-2009-2412 apr, apr-util: Integer overflows in memory pool (apr) and relocatable memory (apr-util) management
https://bugzilla.redhat.com/show_bug.cgi?id=515698

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update apr' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8336

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8336 (apr)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"apr", rpm:"apr~1.3.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-devel", rpm:"apr-devel~1.3.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-debuginfo", rpm:"apr-debuginfo~1.3.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
