# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6846 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64296);
 script_cve_id("CVE-2008-3528", "CVE-2008-3525", "CVE-2008-3831", "CVE-2008-2750", "CVE-2009-1385", "CVE-2009-1389");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2009-6846 (kernel)";
 script_name(name);

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-6846.

Update Information:

Update to linux kernel 2.6.27.25:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.25
ChangeLog:

* Tue Jun 16 2009 Chuck Ebbert  2.6.27.25-78.2.56
- r8169 network driver fixes from 2.6.29.5 and 2.6.30
* Tue Jun 16 2009 Chuck Ebbert  2.6.27.25-78.2.55
- Avoid lockup on OOM with /dev/zero
- Stop spewing useless warning on parport sysctl registration
* Sun Jun 14 2009 Chuck Ebbert   2.6.27.25-78.2.54
- Linux 2.6.27.25
- Dropped patches, merged in .25
ext4.git-1-8657e625a390d09a21970a810f271d74e99b4c8f.patch
ext4.git-2-b3239aab20df1446ddfb8d0520076d5fd0d4ecd2.patch
ext4.git-3-e9b9a50398f0cc909e5645716c74cc1aecd6699e.patch
ext4.git-4-ce54e9c7949d1158512accf23825641a92bd07f9.patch
ext4.git-5-e0ee7aa0b15299bc678758a754eec51ee537c53f.patch
linux-2.6-ext4-clear-unwritten-flag.patch
linux-2.6-ext4-fake-delalloc-bno.patch
linux-2.6-ext4-fix-i_cached_extent-race.patch
linux-2.6-ext4-prealloc-fixes.patch
- Added patch from 2.6.29.4:
kvm-make-efer-reads-safe-when-efer-does-not-exist.patch

References:

[ 1 ] Bug #502981 - CVE-2009-1385 kernel: e1000_clean_rx_irq() denial of service
https://bugzilla.redhat.com/show_bug.cgi?id=502981
[ 2 ] Bug #504726 - CVE-2009-1389 kernel: r8169: fix crash when large packets are received
https://bugzilla.redhat.com/show_bug.cgi?id=504726

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6846

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-6846 (kernel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump", rpm:"kernel-kdump~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-devel", rpm:"kernel-kdump-devel~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-debuginfo", rpm:"kernel-kdump-debuginfo~2.6.27.25~78.2.56.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
