# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 343-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53632);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 343-1 (skk, ddskk)";
 script_name(name);

 desc = "The remote host is missing an update to skk, ddskk
announced via advisory DSA 343-1.

skk (Simple Kana to Kanji conversion program), does not take
appropriate security precautions when creating temporary files.  This
bug could potentially be exploited to overwrite arbitrary files with
the privileges of the user running Emacs and skk.

ddskk is derived from the same code, and contains the same bug.

For the stable distribution (woody) this problem has been fixed in
skk version 10.62a-4woody1 and ddskk version 11.6.rel.0-2woody1.

For the unstable distribution (sid) this problem has been fixed in
ddskk version 12.1.cvs.20030622-1, and skk will be fixed soon.

We recommend that you update your skk and ddskk package-.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20343-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 343-1 (skk, ddskk)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"skk", ver:"10.62a-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"skkserv", ver:"10.62a-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ddskk", ver:"11.6.rel.0-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
