# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1470-1 (horde3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60213);
 script_cve_id("CVE-2007-6018");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1470-1 (horde3)";
 script_name(name);

 desc = "The remote host is missing an update to horde3
announced via advisory DSA 1470-1.

Ulf Harnhammer discovered that the HTML filter of the Horde web
application framework performed insufficient input sanitising, which
may lead to the deletion of emails if a user is tricked into viewing
a malformed email inside the Imp client.

This update also provides backported bugfixes to the cross-site
scripting filter and the user management API from the latest Horde
release 3.1.6.

For the stable distribution (etch), this problem has been fixed in
version 3.1.3-4etch2.

The old stable distribution (sarge) is not affected. An update to
Etch is recommended, though.

We recommend that you upgrade your horde3 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201470-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1470-1 (horde3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"horde3", ver:"3.1.3-4etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
