# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1177-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57381);
 script_cve_id("CVE-2006-4246");
 script_version ("$");
 script_tag(name:"cvss_base", value:"3.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1177-1 (usermin)";
 script_name(name);

 desc = "The remote host is missing an update to usermin
announced via advisory DSA 1177-1.

Hendrik Weimer discovered that it is possible for a normal user to
disable the login shell of the root account via usermin, a web-based
administration tool.

For the stable distribution (sarge) this problem has been fixed in
version 1.110-3.1.

In the upstream distribution this problem is fixed in version 1.220.

We recommend that you upgrade your usermin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201177-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1177-1 (usermin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"usermin-at", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-changepass", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-chfn", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-commands", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-cron", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-cshrc", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-fetchmail", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-forward", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-gnupg", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-htaccess", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-htpasswd", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-mailbox", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-man", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-mysql", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-plan", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-postgresql", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-proc", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-procmail", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-quota", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-schedule", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-shell", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-spamassassin", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-ssh", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-tunnel", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-updown", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin-usermount", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"usermin", ver:"1.110-3.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
