# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1112-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57109);
 script_cve_id("CVE-2006-3081", "CVE-2006-3469");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1112-1 (mysql-dfsg-4.1)";
 script_name(name);

 desc = "The remote host is missing an update to mysql-dfsg-4.1
announced via advisory DSA 1112-1.

Several local vulnerabilities have been discovered in the MySQL database
server, which may lead to denial of service. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2006-3081

Kanatoko discovered that the server can be crashed with feeding
NULL values to the str_to_date() function.

CVE-2006-3469

Jean-David Maillefer discovered that the server can be crashed with
specially crafted date_format() function calls.

For the stable distribution (sarge) these problems have been fixed in
version 4.1.11a-4sarge5.

For the unstable distribution (sid) does no longer contain MySQL 4.1
packages. MySQL 5.0 from sid is not affected.

We recommend that you upgrade your mysql-dfsg-4.1 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201112-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1112-1 (mysql-dfsg-4.1)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-common-4.1", ver:"4.1.11a-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient14", ver:"4.1.11a-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient14-dev", ver:"4.1.11a-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client-4.1", ver:"4.1.11a-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-4.1", ver:"4.1.11a-4sarge5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
