/* OpenVAS-Client
 * $Id$
 * Description: Support functions for treeview widgets.
 *
 * Authors:
 * Carsten Koch-Mauthe <c.koch-mauthe@dn-systems.de>
 *
 * Copyright:
 * Copyright (C) 2008 DN-Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * In addition, as a special exception, you have
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#ifdef USE_GTK

#include <gtk/gtk.h>

/**
 * @brief Callback for key presses.
 *
 * If cursor right is pressed expand actual row, cursor left collapse row
 */
gboolean
onKeypressed (GtkWidget *treeview, GdkEventKey *event, gpointer user_data)
{
  if((event->type == GDK_KEY_PRESS))
  {
    GtkTreePath *path;
    gtk_tree_view_get_cursor(GTK_TREE_VIEW(treeview), &path, NULL);
    if(path != NULL)
    {
      if(event->hardware_keycode == 102)
        gtk_tree_view_expand_row(GTK_TREE_VIEW(treeview), path, FALSE);
      else if(event->hardware_keycode == 100)
        gtk_tree_view_collapse_row(GTK_TREE_VIEW(treeview), path);

      gtk_tree_path_free(path);
    }
  }
  return FALSE;
}

#endif /* USE_GTK */
