/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file was originally generated by JSLC
 * and then hand edited for performance.
 */

#include <jni.h>
#include "SSEUtils.h"
#include "com_sun_scenario_effect_impl_sw_sse_SSEBoxShadowPeer.h"

JNIEXPORT void JNICALL
Java_com_sun_scenario_effect_impl_sw_sse_SSEBoxShadowPeer_filterHorizontalBlack
    (JNIEnv *env, jclass klass,
     jintArray dstPixels_arr, jint dstw, jint dsth, jint dstscan,
     jintArray srcPixels_arr, jint srcw, jint srch, jint srcscan,
     jfloat spread)
{
    jint *srcPixels = (jint *)env->GetPrimitiveArrayCritical(srcPixels_arr, 0);
    if (srcPixels == NULL) return;
    jint *dstPixels = (jint *)env->GetPrimitiveArrayCritical(dstPixels_arr, 0);
    if (dstPixels == NULL) {
        env->ReleasePrimitiveArrayCritical(srcPixels_arr, srcPixels, JNI_ABORT);
        return;
    }

    jint hsize = dstw - srcw + 1;
    // amax goes from hsize*255 to 255 as spread goes from 0 to 1
    jint amax = hsize * 255;
    amax += (jint) ((255 - amax) * spread);
    jint kscale = 0x7fffffff / amax;
    jint amin = (amax / 255);
    jint srcoff = 0;
    jint dstoff = 0;
    for (jint y = 0; y < dsth; y++) {
        jint suma = 0;
        for (jint x = 0; x < dstw; x++) {
            jint rgb;
            // Un-accumulate the data for col-hsize location into the sums.
            rgb = (x >= hsize) ? srcPixels[srcoff + x - hsize] : 0;
            suma -= (rgb >> 24) & 0xff;
            // Accumulate the data for this col location into the sums.
            rgb = (x < srcw) ? srcPixels[srcoff + x] : 0;
            suma += (rgb >> 24) & 0xff;
            // Clamp, scale and convert the sum into a color.
            dstPixels[dstoff + x] =
                ((suma < amin) ? 0
                 : ((suma >= amax) ? 0xff000000
                    : (((suma * kscale) >> 23) << 24)));
        }
        srcoff += srcscan;
        dstoff += dstscan;
    }

    env->ReleasePrimitiveArrayCritical(dstPixels_arr, dstPixels, 0);
    env->ReleasePrimitiveArrayCritical(srcPixels_arr, srcPixels, JNI_ABORT);
}

JNIEXPORT void JNICALL
Java_com_sun_scenario_effect_impl_sw_sse_SSEBoxShadowPeer_filterVerticalBlack
    (JNIEnv *env, jclass klass,
     jintArray dstPixels_arr, jint dstw, jint dsth, jint dstscan,
     jintArray srcPixels_arr, jint srcw, jint srch, jint srcscan,
     jfloat spread)
{
    jint *srcPixels = (jint *)env->GetPrimitiveArrayCritical(srcPixels_arr, 0);
    if (srcPixels == NULL) return;
    jint *dstPixels = (jint *)env->GetPrimitiveArrayCritical(dstPixels_arr, 0);
    if (dstPixels == NULL) {
        env->ReleasePrimitiveArrayCritical(srcPixels_arr, srcPixels, JNI_ABORT);
        return;
    }

    jint vsize = dsth - srch + 1;
    // amax goes from hsize*255 to 255 as spread goes from 0 to 1
    jint amax = vsize * 255;
    amax += (jint) ((255 - amax) * spread);
    jint kscale = 0x7fffffff / amax;
    jint amin = (amax / 255);
    jint voff = vsize * srcscan;
    for (jint x = 0; x < dstw; x++) {
        jint suma = 0;
        jint srcoff = x;
        jint dstoff = x;
        for (jint y = 0; y < dsth; y++) {
            jint rgb;
            // Un-accumulate the data for row-vsize location into the sums.
            rgb = (srcoff >= voff) ? srcPixels[srcoff - voff] : 0;
            suma -= (rgb >> 24) & 0xff;
            // Accumulate the data for this row location into the sums.
            rgb = (y < srch) ? srcPixels[srcoff] : 0;
            suma += (rgb >> 24) & 0xff;
            // Clamp, scale and convert the sum into a color.
            dstPixels[dstoff] =
                ((suma < amin) ? 0
                 : ((suma >= amax) ? 0xff000000
                    : (((suma * kscale) >> 23) << 24)));
            srcoff += srcscan;
            dstoff += dstscan;
        }
    }

    env->ReleasePrimitiveArrayCritical(dstPixels_arr, dstPixels, 0);
    env->ReleasePrimitiveArrayCritical(srcPixels_arr, srcPixels, JNI_ABORT);
}

JNIEXPORT void JNICALL
Java_com_sun_scenario_effect_impl_sw_sse_SSEBoxShadowPeer_filterVertical
    (JNIEnv *env, jclass klass,
     jintArray dstPixels_arr, jint dstw, jint dsth, jint dstscan,
     jintArray srcPixels_arr, jint srcw, jint srch, jint srcscan,
     jfloat spread, jfloatArray shadowColor_arr)
{
    jfloat shadowColor[4];
    env->GetFloatArrayRegion(shadowColor_arr, 0, 4, shadowColor);

    jint *srcPixels = (jint *)env->GetPrimitiveArrayCritical(srcPixels_arr, 0);
    if (srcPixels == NULL) return;
    jint *dstPixels = (jint *)env->GetPrimitiveArrayCritical(dstPixels_arr, 0);
    if (dstPixels == NULL) {
        env->ReleasePrimitiveArrayCritical(srcPixels_arr, srcPixels, JNI_ABORT);
        return;
    }

    jint vsize = dsth - srch + 1;
    // amax goes from hsize*255 to 255 as spread goes from 0 to 1
    jint amax = vsize * 255;
    amax += (jint) ((255 - amax) * spread);
    jint kscalea = 0x7fffffff / amax;
    jint kscaler = (jint) (kscalea * shadowColor[0]);
    jint kscaleg = (jint) (kscalea * shadowColor[1]);
    jint kscaleb = (jint) (kscalea * shadowColor[2]);
    kscalea = (jint) (kscalea * shadowColor[3]);
    jint amin = (amax / 255);
    jint voff = vsize * srcscan;
    jint shadowRGB =
        (((jint) (shadowColor[0] * 255)) << 16) |
        (((jint) (shadowColor[1] * 255)) <<  8) |
        (((jint) (shadowColor[2] * 255))      ) |
        (((jint) (shadowColor[3] * 255)) << 24);
    for (jint x = 0; x < dstw; x++) {
        jint suma = 0;
        jint srcoff = x;
        jint dstoff = x;
        for (jint y = 0; y < dsth; y++) {
            jint rgb;
            // Un-accumulate the data for row-vsize location into the sums.
            rgb = (srcoff >= voff) ? srcPixels[srcoff - voff] : 0;
            suma -= (rgb >> 24) & 0xff;
            // Accumulate the data for this row location into the sums.
            rgb = (y < srch) ? srcPixels[srcoff] : 0;
            suma += (rgb >> 24) & 0xff;
            // Clamp, scale and convert the sum into a color.
            dstPixels[dstoff] =
                ((suma < amin) ? 0
                 : ((suma >= amax) ? shadowRGB
                    : ((((suma * kscalea) >> 23) << 24) |
                       (((suma * kscaler) >> 23) << 16) |
                       (((suma * kscaleg) >> 23) <<  8) |
                       (((suma * kscaleb) >> 23)      ))));
            srcoff += srcscan;
            dstoff += dstscan;
        }
    }

    env->ReleasePrimitiveArrayCritical(dstPixels_arr, dstPixels, 0);
    env->ReleasePrimitiveArrayCritical(srcPixels_arr, srcPixels, JNI_ABORT);
}
