#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $4 $6/mof/OpenDRIM_RegisteredPowerManagementProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_RegisteredPowerManagementProfile provider module";
Name = "PowerManagement_OpenDRIM_RegisteredPowerManagementProfileModule";
Location = "cmpiPowerManagement_OpenDRIM_RegisteredPowerManagementProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_RegisteredPowerManagementProfile provider";
Name = "PowerManagement_OpenDRIM_RegisteredPowerManagementProfileProvider";
ProviderModuleName = "PowerManagement_OpenDRIM_RegisteredPowerManagementProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_RegisteredPowerManagementProfile provider capabilities";
ProviderModuleName = "PowerManagement_OpenDRIM_RegisteredPowerManagementProfileModule";
ProviderName = "PowerManagement_OpenDRIM_RegisteredPowerManagementProfileProvider";
ClassName = "OpenDRIM_RegisteredPowerManagementProfile";
ProviderType = {2};
Namespaces = {"$4"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstanceID", "RegisteredOrganization", "OtherRegisteredOrganization", "RegisteredName", "RegisteredVersion", "AdvertiseTypes", "AdvertiseTypeDescriptions"};
CapabilityID = "PowerManagement_OpenDRIM_RegisteredPowerManagementProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_RegisteredPowerManagementProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_RegisteredPowerManagementProfile]   
   provider: PowerManagement_OpenDRIM_RegisteredPowerManagementProfileProvider
   location: cmpiPowerManagement_OpenDRIM_RegisteredPowerManagementProfileProvider
   type: instance
   namespace: $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_RegisteredPowerManagementProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_RegisteredPowerManagementProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_RegisteredPowerManagementProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
