/***************************************************************************
                          jdxfilter.h  -  description
                             -------------------
    begin                : Thu Jul 6 2006
    copyright            : (C) 2002 by Thies H. Jochimsen
    email                : jochimse@cns.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef JDXFILTER_H
#define JDXFILTER_H

#include <odinpara/jdxfunction.h>

/**
  * @addtogroup jcampdx
  * @{
  */

/**
  *
  * Wrapper class for pulse shape functions.
  */
class JDXfilter : public JDXfunction,  public StaticHandler<JDXfilter> {

 public:
  JDXfilter(const STD_string& jdxlabel="unnamedJDXfilter") : JDXfunction(filterFunc,jdxlabel) {}

  JDXfilter(const JDXfilter& jf) : JDXfunction(jf) {}

  JDXfilter& operator = (const JDXfilter& jf) {JDXfunction::operator = (jf); return *this;}

  float calculate (float rel_kradius) const {
    if(allocated_function) return allocated_function->calculate_filter(rel_kradius);
    else return 0.0;
  }


  static void init_static();
  static void destroy_static();

};


/** @}
  */

#endif


