/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.lang;

public class Bytes {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] append(byte[] a, byte[] b) {
        byte[] z = new byte[a.length + b.length];
        System.arraycopy(a, 0, z, 0, a.length);
        System.arraycopy(b, 0, z, a.length, b.length);
        return z;
    }

    public static byte[] append(byte[] a, byte[] b, byte[] c) {
        byte[] z = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, z, 0, a.length);
        System.arraycopy(b, 0, z, a.length, b.length);
        System.arraycopy(c, 0, z, a.length + b.length, c.length);
        return z;
    }

    public static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        int i = 0;
        while (i < aLength) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] copy(byte[] b, int pos) {
        return Bytes.copy(b, pos, b.length - pos);
    }

    public static byte[] copy(byte[] b, int pos, int length) {
        byte[] z = new byte[length];
        System.arraycopy(b, pos, z, 0, length);
        return z;
    }

    public static void merge(byte[] src, byte[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    public static void merge(byte[] src, byte[] dest, int pos) {
        System.arraycopy(src, 0, dest, pos, src.length);
    }

    public static void merge(byte[] src, byte[] dest, int pos, int length) {
        System.arraycopy(src, 0, dest, pos, length);
    }

    public static void merge(byte[] src, byte[] dest, int srcpos, int destpos, int length) {
        System.arraycopy(src, srcpos, dest, destpos, length);
    }

    public static byte[] toBytes(int n) {
        return Bytes.toBytes(n, new byte[4]);
    }

    public static byte[] toBytes(int n, byte[] b) {
        b[3] = (byte)n;
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static byte[] toBytes(long n) {
        return Bytes.toBytes(n, new byte[8]);
    }

    public static byte[] toBytes(long n, byte[] b) {
        b[7] = (byte)n;
        b[6] = (byte)(n >>>= 8);
        b[5] = (byte)(n >>>= 8);
        b[4] = (byte)(n >>>= 8);
        b[3] = (byte)(n >>>= 8);
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static int toInt(byte[] b) {
        return (b[3] & 0xFF) + ((b[2] & 0xFF) << 8) + ((b[1] & 0xFF) << 16) + ((b[0] & 0xFF) << 24);
    }

    public static long toLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }

    public static String toString(byte[] b) {
        return Bytes.toString(b, 0, b.length);
    }

    public static String toString(byte[] b, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            byte k = b[i];
            buf[j++] = hexDigits[k >>> 4 & 0xF];
            buf[j++] = hexDigits[k & 0xF];
            ++i;
        }
        return new String(buf);
    }
}

