#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>

#   include <mpi.h>
#   define MP_BARRIER()      MPI_Barrier(MPI_COMM_WORLD)
#   define MP_FINALIZE()     MPI_Finalize()
#ifdef DCMF
#   define MP_INIT(arc,argv) \
    int desired = MPI_THREAD_MULTIPLE; \
    int provided; \
    printf("using MPI_Init_thread\n"); \
    MPI_Init_thread(&argc, &argv, desired, &provided); \
    if ( provided != MPI_THREAD_MULTIPLE ) printf("provided != MPI_THREAD_MULTIPLE\n");
#else
#   define MP_INIT(arc,argv) MPI_Init(&(argc),&(argv))
#endif
#   define MP_MYID(pid)      MPI_Comm_rank(MPI_COMM_WORLD, (pid))
#   define MP_PROCS(pproc)   MPI_Comm_size(MPI_COMM_WORLD, (pproc));

#include "armci.h"

#define MAXPROCS 128
#define SIZE_    1024
#define FAILURE_SIZE_    512

int me,nproc;
double *ptr_arr[MAXPROCS];
long size;
void do_work(int sz)
{
    int i;
    static int d=1;
    for(i=0;i<sz;i++){
       *((double *)(ptr_arr[me])+i)=i+1.12*d++;
    }
}
static double time_array[100],time_array1[100],t1;
int main(int argc, char* argv[])
{
    int rc,i,j=0,rid,ret;
    armci_ckpt_ds_t ckptds;
    ARMCI_Group grp;
    MP_INIT(argc, argv);
    MP_PROCS(&nproc);
    MP_MYID(&me);

    if(me==0){
       if(nproc > MAXPROCS) ARMCI_Error("nproc > MAXPROCS", nproc);
       else {
          printf("ARMCI test program (%d processes)\n",nproc); 
          fflush(stdout);
          sleep(1);
       }
       
    }
    armci_init_checkpoint2();
    ARMCI_Init();
    ARMCI_Group_get_world(&grp);
    size = SIZE_;
    rc=ARMCI_Malloc((void **)ptr_arr,size*8);
    printf("ARMCI test program (%d processes)\n",nproc); 
    fflush(stdout);
    for(size=1;size<=SIZE_;size*=2){
       t1 = MPI_Wtime();
       for(i=0;i<5;i++){
         for(rc=0;rc<15;rc++)do_work(size);
       }
       time_array[j++]=MPI_Wtime()-t1;
       MP_BARRIER();
       printf("%d:done for size %ld\n",me,size);fflush(stdout);
    }
    
    (void)ARMCI_Ckpt_create_ds(&ckptds,1);
    ckptds.ptr_arr[0]=ptr_arr[me];
    ckptds.sz[0]=SIZE_*8;
    rid=ARMCI_Ckpt_init(NULL,&grp,1,0,&ckptds);
    printf("%d: After ARMCI_Ckpt_init(): \n", me);

    j=0;
    for(size=128;size<=SIZE_;size*=2){

       int rc;
       int simulate_restart=1;
       t1 = MPI_Wtime();

       ret=ARMCI_Ckpt(rid);
       if(ret==ARMCI_CKPT)
         printf("%d: Performed CHECKPOINT @ size=%ld\n",me,size);
       else if(ret==ARMCI_RESTART) {
         simulate_restart = 0;
         printf("%d: Performed RESTART @ size=%ld\n", me,size);
       }
       
       for(i=0;i<5;i++){
         for(rc=0;rc<15;rc++)
            if(i==3 && rc==10) {
            }
            do_work(size);
       }

       time_array1[j++]=MPI_Wtime()-t1;
       sleep(1);

       if(simulate_restart && size == FAILURE_SIZE_) {
          printf("%d: Simulating FAILURE @ size = %d\n", me, size);
          ARMCI_Restart_simulate(rid,1);
       }
       
       printf("%d: DONE for size=%ld regular=%f withckpt=%f\n\n",
              me, size, time_array[j-1], time_array1[j-1]); fflush(stdout);
       
    }

    ARMCI_Ckpt_finalize(rid);
    
    printf("Before Finalize()\n");
    MP_BARRIER();
    ARMCI_Finalize();
    MP_FINALIZE();
    return(0);
}
