#!/usr/bin/perl
# Copyright (C) 2008-2011, The Perl Foundation.

use strict;
use warnings;
use 5.008;

binmode STDOUT, ':utf8';

my ($prefix, $thirdPartyJars) = @ARGV;

my $cpsep = $^O eq 'MSWin32' ? ';' : ':';
my $jardir = ".";
my $libdir = ".";

if ($prefix ne '.') {
    $jardir = "${prefix}/languages/nqp/runtime";
    $libdir = "${prefix}/languages/nqp/lib";
	my @jars = grep { s/^.*\/// } split($cpsep, $thirdPartyJars);
	$thirdPartyJars = join($cpsep, grep { s/^/${jardir}\// } @jars);
}

$thirdPartyJars .= "${cpsep}${jardir}/nqp-runtime.jar${cpsep}${libdir}/nqp.jar";

s/\\/\\\\/g for ($prefix, $thirdPartyJars, $libdir);

print <<"END";
# This file automatically generated by $0

runtime.prefix=${prefix}
runtime.bootclasspath=-Xbootclasspath/a:.${cpsep}${thirdPartyJars}
runtime.classpath=${libdir}
runtime.jars=${thirdPartyJars}
END
