<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/docker/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/docker/metadata.yaml"
sidebar_label: "Docker"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Containers and VMs"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Docker


<img src="https://netdata.cloud/img/docker.svg" width="150"/>


Plugin: go.d.plugin
Module: docker

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Docker containers state, health status and more.


It connects to the Docker instance via a TCP or UNIX socket and executes the following commands:

- [System info](https://docs.docker.com/engine/api/v1.43/#tag/System/operation/SystemInfo).
- [List images](https://docs.docker.com/engine/api/v1.43/#tag/Image/operation/ImageList).
- [List containers](https://docs.docker.com/engine/api/v1.43/#tag/Container/operation/ContainerList).


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

Requires netdata user to be in the docker group.

### Default Behavior

#### Auto-Detection

It discovers instances running on localhost by attempting to connect to a known Docker UNIX socket: `/var/run/docker.sock`.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

Enabling `collect_container_size` may result in high CPU usage depending on the version of Docker Engine.



## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Docker instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| docker.containers_state | running, paused, stopped | containers |
| docker.containers_health_status | healthy, unhealthy, not_running_unhealthy, starting, no_healthcheck | containers |
| docker.images | active, dangling | images |
| docker.images_size | size | bytes |

### Per container

Metrics related to containers. Each container provides its own set of the following metrics.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| container_name | The container's name |
| image | The image name the container uses |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| docker.container_state | running, paused, exited, created, restarting, removing, dead | state |
| docker.container_health_status | healthy, unhealthy, not_running_unhealthy, starting, no_healthcheck | status |
| docker.container_writeable_layer_size | writeable_layer | size |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ docker_container_unhealthy ](https://github.com/netdata/netdata/blob/master/src/health/health.d/docker.conf) | docker.container_health_status | ${label:container_name} docker container health status is unhealthy |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/docker.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/docker.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | Docker daemon's listening address. When using a TCP socket, the format is: tcp://[ip]:[port] | unix:///var/run/docker.sock | yes |
| timeout | Request timeout in seconds. | 2 | no |
| collect_container_size | Whether to collect container writable layer size. | no | no |

</details>

#### Examples

##### Basic

An example configuration.

```yaml
jobs:
  - name: local
    address: 'unix:///var/run/docker.sock'

```
##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'unix:///var/run/docker.sock'

  - name: remote
    address: 'tcp://203.0.113.10:2375'

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `docker` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m docker
  ```

### Getting Logs

If you're encountering problems with the `docker` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep docker
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep docker /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep docker
```


