!
!  find stars
!
!  Copyright © 2013-4, 2016-8 F.Hroch (hroch@physics.muni.cz)
!
!  This file is part of Munipack.
!
!  Munipack is free software: you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation, either version 3 of the License, or
!  (at your option) any later version.
!
!  Munipack is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.


program find

  use fitsio
  use iso_fortran_env

  implicit none

  logical, parameter :: debug = .false.

  character(len=4*FLEN_FILENAME) :: line,key,val
  character(len=FLEN_FILENAME) :: filename, output
  character(len=FLEN_KEYWORD), dimension(2) :: fkeys
  real :: lothresh = 3.0
  real :: threshold = 7.0
  real :: fwhm = 3.0
  real :: readns_init = -1
  real :: satur_init = -1
  real :: shrplo = 0.2, shrphi = 1.0
  real :: rndlo = -1.0, rndhi = 1.0
  integer :: maxsky = -1
  logical :: verbose = .false., plog = .false.
  logical :: ex, exitus = .true.
  integer :: eq

  fkeys(1) = FITS_KEY_SATURATE
  fkeys(2) = FITS_KEY_READNS

  do
     read(*,'(a)',end=20) line

     eq = index(line,'=')
     if( eq == 0 ) stop 'Malformed input record.'
     key = line(:eq-1)
     val = line(eq+1:)

     if( key == 'VERBOSE' ) then

        read(val,*) verbose
        write(*,*) 'Filename, sky value [cts], No. of stars:'

     else if( key == 'PIPELOG' ) then

        read(val,*) plog

     else if( key == 'FWHM' ) then

        read(val,*) fwhm

     else if( key == 'READNOISE' ) then

        read(val,*) readns_init

     else if( key == 'SATURATE' ) then

        read(val,*) satur_init

     else if( key == 'THRESHOLD' ) then

        read(val,*) threshold

     else if( key == 'LOWER_THRESHOLD' ) then

        read(val,*) lothresh

     else if( key == 'ROUND_LOWER' ) then

        read(val,*) rndlo

     else if( key == 'ROUND_HIGHER' ) then

        read(val,*) rndhi

     else if( key == 'SHARP_LOWER' ) then

        read(val,*) shrplo

     else if( key == 'SHARP_HIGHER' ) then

        read(val,*) shrphi

     else if( key == 'FITS_KEY_SATURATE' ) then

           read(val,*) fkeys(1)

     else if( key == 'FITS_KEY_READNOISE' ) then

           read(val,*) fkeys(2)

     else if( key == 'FILE' ) then

        read(val,*) filename, output

        if( verbose ) &
             write(error_unit,'(a)',advance="no") trim(filename)//": "

        call the_finder(ex)
        exitus = exitus .and. ex

     end if

  end do

20 continue

  if( exitus ) then
     stop 0
  else
     stop 'An error during star search occurred.'
  end if

contains

  subroutine the_finder(exitus)

    use mdaofind
    use fitsfind

    logical, intent(out) :: exitus

    real, dimension(:,:), allocatable :: data
    real :: lobad, hibad, hmin, saturation,readns,skymod, skyerr, skysig, &
         satur
    integer :: nstar,status

    status = 0
    call fits_find_read(filename,fkeys,data,readns,satur,status)

    if( status /= 0 ) goto 666

    if( satur_init > 0.0 ) then
       saturation = satur_init
    else
       saturation = satur
    end if

    if( saturation > 0.0 ) then
       hibad = saturation
    else
       hibad = huge(data)
    end if

    if( readns_init > 0.0 ) then
       readns = readns_init
    end if

    if( maxsky < 0 ) maxsky = size(data) / 3

    ! Detected stars are temporary stored in a scratch file under unit 3.
    ! The scratch file is written by daofind and to be read by fits_find_save().
    open(3,status='scratch',form='unformatted')

    call daofind(data,maxsky,debug,plog,hibad,fwhm,lothresh,threshold, &
         shrplo,shrphi,rndlo,rndhi,readns,1.0,nstar, lobad, hmin, &
         skymod, skyerr, skysig)

    rewind(3)

    call fits_find_save(filename,output,fkeys,readns_init,satur_init,nstar, &
         fwhm,threshold,saturation, shrplo,shrphi,rndlo,rndhi,readns, &
         lothresh, lobad, hibad, hmin, skymod, skyerr, skysig, maxsky,status)

    if( verbose ) write(error_unit,*) skymod, nstar
    close(3)

666 continue

    exitus = status == 0

    if( allocated(data) ) deallocate(data)

  end subroutine the_finder

end program find
