# Check for system lib3ds:
# ===================================================
SET(CMAKE_MRPT_HAS_LIB3DS 1)	# Always present: system or built-in
SET(CMAKE_MRPT_HAS_LIB3DS_SYSTEM 0)

IF(UNIX)
	FIND_FILE(LIB3DS_CONFIG_FILE lib3ds-config)
	IF(LIB3DS_CONFIG_FILE)
		MARK_AS_ADVANCED(LIB3DS_CONFIG_FILE)

		SET(CMAKE_MRPT_HAS_LIB3DS_SYSTEM 1)

		# Get the config params:
		EXECUTE_PROCESS(COMMAND ${LIB3DS_CONFIG_FILE} --libs
			RESULT_VARIABLE CMAKE_LIB3DS_CONFIG_RES
			OUTPUT_VARIABLE CMAKE_LIB3DS_LIBS
			OUTPUT_STRIP_TRAILING_WHITESPACE
			)
		IF(${CMAKE_LIB3DS_CONFIG_RES})
			MESSAGE("Error invoking lib3ds config file:\n ${LIB3DS_CONFIG_FILE} --libs")
		ENDIF(${CMAKE_LIB3DS_CONFIG_RES})

		# ${CMAKE_LIB3DS_LIBS}
		APPEND_MRPT_LIBS(3ds)

		EXECUTE_PROCESS(COMMAND ${LIB3DS_CONFIG_FILE} --cflags
			RESULT_VARIABLE CMAKE_LIB3DS_CONFIG_RES
			OUTPUT_VARIABLE CMAKE_LIB3DS_CFLAGS
			OUTPUT_STRIP_TRAILING_WHITESPACE
			)
		IF(${CMAKE_LIB3DS_CONFIG_RES})
			MESSAGE("Error invoking lib3ds config file:\n ${LIB3DS_CONFIG_FILE} --cflags")
		ENDIF(${CMAKE_LIB3DS_CONFIG_RES})

		ADD_DEFINITIONS(${CMAKE_LIB3DS_CFLAGS})

	ENDIF(LIB3DS_CONFIG_FILE)
ELSE(UNIX)
	# In windows we always have the embedded version
ENDIF(UNIX)

