/* moonshot-provisioning-common.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-provisioning-common.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define WEB_PROVISIONING_TYPE_PARSER (web_provisioning_parser_get_type ())
#define WEB_PROVISIONING_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParser))
#define WEB_PROVISIONING_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))
#define WEB_PROVISIONING_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))

typedef struct _WebProvisioningParser WebProvisioningParser;
typedef struct _WebProvisioningParserClass WebProvisioningParserClass;
typedef struct _WebProvisioningParserPrivate WebProvisioningParserPrivate;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _WebProvisioningParser {
	GObject parent_instance;
	WebProvisioningParserPrivate * priv;
};

struct _WebProvisioningParserClass {
	GObjectClass parent_class;
};

struct _WebProvisioningParserPrivate {
	GMarkupParseContext* ctx;
	gchar* text;
	gchar* path;
	gchar* ta_ca_cert;
	gchar* ta_server_cert;
	gchar* ta_subject;
	gchar* ta_subject_alt;
	IdCard* card;
	IdCard** _cards;
	gint _cards_length1;
	gint __cards_size_;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer web_provisioning_parser_parent_class = NULL;
static MoonshotLogger* web_provisioning_parser_logger;
static MoonshotLogger* web_provisioning_parser_logger = NULL;

gboolean web_provisioning_check_stack (GSList* stack, gchar** reference, int reference_length1);
gboolean web_provisioning_always_confirm_handler (GSList* stack);
gboolean web_provisioning_pattern_handler (GSList* stack);
gboolean web_provisioning_server_cert_handler (GSList* stack);
gboolean web_provisioning_subject_alt_handler (GSList* stack);
gboolean web_provisioning_subject_handler (GSList* stack);
gboolean web_provisioning_ca_cert_handler (GSList* stack);
gboolean web_provisioning_realm_handler (GSList* stack);
gboolean web_provisioning_password_handler (GSList* stack);
gboolean web_provisioning_user_handler (GSList* stack);
gboolean web_provisioning_display_name_handler (GSList* stack);
GType web_provisioning_parser_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
#define WEB_PROVISIONING_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserPrivate))
enum  {
	WEB_PROVISIONING_PARSER_DUMMY_PROPERTY
};
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* moonshot_logger_new (const gchar* name);
MoonshotLogger* moonshot_logger_construct (GType object_type, const gchar* name);
static void web_provisioning_parser_start_element_func (WebProvisioningParser* self, GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, int attribute_names_length1, gchar** attribute_values, int attribute_values_length1, GError** error);
static void _web_provisioning_parser_start_element_func_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void web_provisioning_parser_end_element_func (WebProvisioningParser* self, GMarkupParseContext* context, const gchar* element_name, GError** error);
static void _web_provisioning_parser_end_element_func_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void web_provisioning_parser_text_element_func (WebProvisioningParser* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _web_provisioning_parser_text_element_func_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
static void _vala_array_add1 (IdCard*** array, int* length, int* size, IdCard* value);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_add_rule (IdCard* self, Rule* rule);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* trust_anchor_new (const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
TrustAnchor* trust_anchor_construct (GType object_type, const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
void id_card_set_trust_anchor_from_store (IdCard* self, TrustAnchor* ta);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_password (IdCard* self, const gchar* value);
void id_card_set_issuer (IdCard* self, const gchar* value);
GeeArrayList* id_card_get_services (IdCard* self);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
static Rule* _vala_array_dup2 (Rule* self, int length);
static void _vala_Rule_array_free (Rule* array, gint array_length);
static Rule* _vala_array_dup3 (Rule* self, int length);
WebProvisioningParser* web_provisioning_parser_new (const gchar* path);
WebProvisioningParser* web_provisioning_parser_construct (GType object_type, const gchar* path);
void web_provisioning_parser_parse (WebProvisioningParser* self);
IdCard** web_provisioning_parser_get_cards (WebProvisioningParser* self, int* result_length1);
static void web_provisioning_parser_set_cards (WebProvisioningParser* self, IdCard** value, int value_length1);
static IdCard** _vala_array_dup4 (IdCard** self, int length);
static void web_provisioning_parser_finalize (GObject* obj);
static void _vala_web_provisioning_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_web_provisioning_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GMarkupParser WEB_PROVISIONING_PARSER_parser = {_web_provisioning_parser_start_element_func_gmarkup_parser_start_element_func, _web_provisioning_parser_end_element_func_gmarkup_parser_end_element_func, _web_provisioning_parser_text_element_func_gmarkup_parser_text_func, NULL, NULL};

gboolean web_provisioning_check_stack (GSList* stack, gchar** reference, int reference_length1) {
	gboolean result = FALSE;
	GSList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = stack;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_slist_length (_tmp0_);
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = reference;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2__length1 = reference_length1;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (_tmp1_ < ((guint) _tmp2__length1)) {
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		result = FALSE;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		return result;
#line 209 "moonshot-provisioning-common.c"
	}
	{
		gint i = 0;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		i = 0;
#line 215 "moonshot-provisioning-common.c"
		{
			gboolean _tmp3_ = FALSE;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp3_ = TRUE;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			while (TRUE) {
#line 222 "moonshot-provisioning-common.c"
				gint _tmp5_ = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				GSList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gconstpointer _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				const gchar* _tmp12_ = NULL;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				if (!_tmp3_) {
#line 235 "moonshot-provisioning-common.c"
					gint _tmp4_ = 0;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp4_ = i;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					i = _tmp4_ + 1;
#line 241 "moonshot-provisioning-common.c"
				}
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp3_ = FALSE;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp5_ = i;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp6_ = reference;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp6__length1 = reference_length1;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				if (!(_tmp5_ < _tmp6__length1)) {
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					break;
#line 255 "moonshot-provisioning-common.c"
				}
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp7_ = stack;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp8_ = i;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp9_ = g_slist_nth_data (_tmp7_, (guint) _tmp8_);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp10_ = reference;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp10__length1 = reference_length1;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp11_ = i;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				if (g_strcmp0 ((const gchar*) _tmp9_, _tmp12_) != 0) {
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					result = FALSE;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					return result;
#line 277 "moonshot-provisioning-common.c"
				}
			}
		}
	}
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = TRUE;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 286 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_always_confirm_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** always_confirm_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint always_confirm_path_length1 = 0;
	gint _always_confirm_path_size_ = 0;
	GSList* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("always-confirm");
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("rule");
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("selection-rules");
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_strdup ("identity");
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = g_strdup ("identities");
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[0] = _tmp0_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[1] = _tmp1_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[2] = _tmp2_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[3] = _tmp3_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[4] = _tmp4_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	always_confirm_path = _tmp5_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	always_confirm_path_length1 = 5;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_always_confirm_path_size_ = always_confirm_path_length1;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp6_ = stack;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp7_ = web_provisioning_check_stack (_tmp6_, always_confirm_path, always_confirm_path_length1);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp7_;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	always_confirm_path = (_vala_array_free (always_confirm_path, always_confirm_path_length1, (GDestroyNotify) g_free), NULL);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 341 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_pattern_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** pattern_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint pattern_path_length1 = 0;
	gint _pattern_path_size_ = 0;
	GSList* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("pattern");
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("rule");
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("selection-rules");
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_strdup ("identity");
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = g_strdup ("identities");
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[0] = _tmp0_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[1] = _tmp1_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[2] = _tmp2_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[3] = _tmp3_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_[4] = _tmp4_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	pattern_path = _tmp5_;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	pattern_path_length1 = 5;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_pattern_path_size_ = pattern_path_length1;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp6_ = stack;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp7_ = web_provisioning_check_stack (_tmp6_, pattern_path, pattern_path_length1);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp7_;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	pattern_path = (_vala_array_free (pattern_path, pattern_path_length1, (GDestroyNotify) g_free), NULL);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 396 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_server_cert_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** server_cert_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint server_cert_path_length1 = 0;
	gint _server_cert_path_size_ = 0;
	GSList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("server-cert");
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("trust-anchor");
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identity");
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_strdup ("identities");
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = g_new0 (gchar*, 4 + 1);
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[0] = _tmp0_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[1] = _tmp1_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[2] = _tmp2_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[3] = _tmp3_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	server_cert_path = _tmp4_;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	server_cert_path_length1 = 4;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_server_cert_path_size_ = server_cert_path_length1;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = stack;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp6_ = web_provisioning_check_stack (_tmp5_, server_cert_path, server_cert_path_length1);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp6_;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	server_cert_path = (_vala_array_free (server_cert_path, server_cert_path_length1, (GDestroyNotify) g_free), NULL);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 446 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_subject_alt_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** subject_alt_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint subject_alt_path_length1 = 0;
	gint _subject_alt_path_size_ = 0;
	GSList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("subject-alt");
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("trust-anchor");
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identity");
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_strdup ("identities");
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = g_new0 (gchar*, 4 + 1);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[0] = _tmp0_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[1] = _tmp1_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[2] = _tmp2_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[3] = _tmp3_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	subject_alt_path = _tmp4_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	subject_alt_path_length1 = 4;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_subject_alt_path_size_ = subject_alt_path_length1;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = stack;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp6_ = web_provisioning_check_stack (_tmp5_, subject_alt_path, subject_alt_path_length1);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp6_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	subject_alt_path = (_vala_array_free (subject_alt_path, subject_alt_path_length1, (GDestroyNotify) g_free), NULL);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 496 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_subject_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** subject_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint subject_path_length1 = 0;
	gint _subject_path_size_ = 0;
	GSList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("subject");
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("trust-anchor");
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identity");
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_strdup ("identities");
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = g_new0 (gchar*, 4 + 1);
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[0] = _tmp0_;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[1] = _tmp1_;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[2] = _tmp2_;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[3] = _tmp3_;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	subject_path = _tmp4_;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	subject_path_length1 = 4;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_subject_path_size_ = subject_path_length1;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = stack;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp6_ = web_provisioning_check_stack (_tmp5_, subject_path, subject_path_length1);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp6_;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	subject_path = (_vala_array_free (subject_path, subject_path_length1, (GDestroyNotify) g_free), NULL);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 546 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_ca_cert_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** ca_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint ca_path_length1 = 0;
	gint _ca_path_size_ = 0;
	GSList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("ca-cert");
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("trust-anchor");
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identity");
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_strdup ("identities");
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = g_new0 (gchar*, 4 + 1);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[0] = _tmp0_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[1] = _tmp1_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[2] = _tmp2_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_[3] = _tmp3_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	ca_path = _tmp4_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	ca_path_length1 = 4;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_ca_path_size_ = ca_path_length1;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = stack;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp6_ = web_provisioning_check_stack (_tmp5_, ca_path, ca_path_length1);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp6_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	ca_path = (_vala_array_free (ca_path, ca_path_length1, (GDestroyNotify) g_free), NULL);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 596 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_realm_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** realm_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint realm_path_length1 = 0;
	gint _realm_path_size_ = 0;
	GSList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("realm");
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("identity");
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identities");
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[0] = _tmp0_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[1] = _tmp1_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[2] = _tmp2_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	realm_path = _tmp3_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	realm_path_length1 = 3;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_realm_path_size_ = realm_path_length1;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = stack;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = web_provisioning_check_stack (_tmp4_, realm_path, realm_path_length1);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp5_;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	realm_path = (_vala_array_free (realm_path, realm_path_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 641 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_password_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** password_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint password_path_length1 = 0;
	gint _password_path_size_ = 0;
	GSList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("password");
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("identity");
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identities");
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[0] = _tmp0_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[1] = _tmp1_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[2] = _tmp2_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	password_path = _tmp3_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	password_path_length1 = 3;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_password_path_size_ = password_path_length1;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = stack;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = web_provisioning_check_stack (_tmp4_, password_path, password_path_length1);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp5_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	password_path = (_vala_array_free (password_path, password_path_length1, (GDestroyNotify) g_free), NULL);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 686 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_user_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** user_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint user_path_length1 = 0;
	gint _user_path_size_ = 0;
	GSList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("user");
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("identity");
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identities");
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[0] = _tmp0_;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[1] = _tmp1_;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[2] = _tmp2_;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	user_path = _tmp3_;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	user_path_length1 = 3;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_user_path_size_ = user_path_length1;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = stack;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = web_provisioning_check_stack (_tmp4_, user_path, user_path_length1);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp5_;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	user_path = (_vala_array_free (user_path, user_path_length1, (GDestroyNotify) g_free), NULL);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 731 "moonshot-provisioning-common.c"
}


gboolean web_provisioning_display_name_handler (GSList* stack) {
	gboolean result = FALSE;
	gchar** display_name_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint display_name_path_length1 = 0;
	gint _display_name_path_size_ = 0;
	GSList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_strdup ("display-name");
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("identity");
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = g_strdup ("identities");
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[0] = _tmp0_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[1] = _tmp1_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_[2] = _tmp2_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	display_name_path = _tmp3_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	display_name_path_length1 = 3;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_display_name_path_size_ = display_name_path_length1;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = stack;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = web_provisioning_check_stack (_tmp4_, display_name_path, display_name_path_length1);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp5_;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	display_name_path = (_vala_array_free (display_name_path, display_name_path_length1, (GDestroyNotify) g_free), NULL);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 776 "moonshot-provisioning-common.c"
}


static void _web_provisioning_parser_start_element_func_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	web_provisioning_parser_start_element_func ((WebProvisioningParser*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
#line 783 "moonshot-provisioning-common.c"
}


static void _web_provisioning_parser_end_element_func_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	web_provisioning_parser_end_element_func ((WebProvisioningParser*) self, context, element_name, error);
#line 790 "moonshot-provisioning-common.c"
}


static void _web_provisioning_parser_text_element_func_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	web_provisioning_parser_text_element_func ((WebProvisioningParser*) self, context, text, text_len, error);
#line 797 "moonshot-provisioning-common.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return self ? g_object_ref (self) : NULL;
#line 804 "moonshot-provisioning-common.c"
}


static void _vala_array_add1 (IdCard*** array, int* length, int* size, IdCard* value) {
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if ((*length) == (*size)) {
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		*array = g_renew (IdCard*, *array, (*size) + 1);
#line 815 "moonshot-provisioning-common.c"
	}
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	(*array)[(*length)++] = value;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	(*array)[*length] = NULL;
#line 821 "moonshot-provisioning-common.c"
}


static void web_provisioning_parser_start_element_func (WebProvisioningParser* self, GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, int attribute_names_length1, gchar** attribute_values, int attribute_values_length1, GError** error) {
	const gchar* _tmp0_ = NULL;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (context != NULL);
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (element_name != NULL);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = element_name;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (g_strcmp0 (_tmp0_, "identity") == 0) {
#line 837 "moonshot-provisioning-common.c"
		IdCard* _tmp1_ = NULL;
		IdCard** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		IdCard* _tmp3_ = NULL;
		IdCard* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp1_ = id_card_new ();
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_object_unref0 (self->priv->card);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		self->priv->card = _tmp1_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp2_ = self->priv->_cards;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp2__length1 = self->priv->_cards_length1;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp3_ = self->priv->card;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_vala_array_add1 (&self->priv->_cards, &self->priv->_cards_length1, &self->priv->__cards_size_, _tmp4_);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp5_ = g_strdup ("");
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_free0 (self->priv->ta_ca_cert);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		self->priv->ta_ca_cert = _tmp5_;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp6_ = g_strdup ("");
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_free0 (self->priv->ta_server_cert);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		self->priv->ta_server_cert = _tmp6_;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp7_ = g_strdup ("");
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_free0 (self->priv->ta_subject);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		self->priv->ta_subject = _tmp7_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp8_ = g_strdup ("");
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_free0 (self->priv->ta_subject_alt);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		self->priv->ta_subject_alt = _tmp8_;
#line 887 "moonshot-provisioning-common.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp9_ = element_name;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		if (g_strcmp0 (_tmp9_, "rule") == 0) {
#line 894 "moonshot-provisioning-common.c"
			IdCard* _tmp10_ = NULL;
			Rule _tmp11_ = {0};
			Rule _tmp12_ = {0};
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp10_ = self->priv->card;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			memset (&_tmp11_, 0, sizeof (Rule));
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp12_ = _tmp11_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			id_card_add_rule (_tmp10_, &_tmp12_);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			rule_destroy (&_tmp12_);
#line 908 "moonshot-provisioning-common.c"
		}
	}
}


static void web_provisioning_parser_end_element_func (WebProvisioningParser* self, GMarkupParseContext* context, const gchar* element_name, GError** error) {
	const gchar* _tmp0_ = NULL;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (context != NULL);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (element_name != NULL);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = element_name;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (g_strcmp0 (_tmp0_, "identity") == 0) {
#line 926 "moonshot-provisioning-common.c"
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp2_ = self->priv->ta_ca_cert;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		if (g_strcmp0 (_tmp2_, "") != 0) {
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp1_ = TRUE;
#line 935 "moonshot-provisioning-common.c"
		} else {
			const gchar* _tmp3_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp3_ = self->priv->ta_server_cert;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
#line 942 "moonshot-provisioning-common.c"
		}
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		if (_tmp1_) {
#line 946 "moonshot-provisioning-common.c"
			TrustAnchor* ta = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			TrustAnchor* _tmp8_ = NULL;
			IdCard* _tmp9_ = NULL;
			TrustAnchor* _tmp10_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp4_ = self->priv->ta_ca_cert;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp5_ = self->priv->ta_server_cert;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp6_ = self->priv->ta_subject;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp7_ = self->priv->ta_subject_alt;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp8_ = trust_anchor_new (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			ta = _tmp8_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp9_ = self->priv->card;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp10_ = ta;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			id_card_set_trust_anchor_from_store (_tmp9_, _tmp10_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_g_object_unref0 (ta);
#line 975 "moonshot-provisioning-common.c"
		}
	}
}


static Rule* _vala_array_dup2 (Rule* self, int length) {
	Rule* result;
	int i;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = g_new0 (Rule, length);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	for (i = 0; i < length; i++) {
#line 988 "moonshot-provisioning-common.c"
		Rule _tmp0_ = {0};
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		rule_copy (&self[i], &_tmp0_);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		result[i] = _tmp0_;
#line 994 "moonshot-provisioning-common.c"
	}
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 998 "moonshot-provisioning-common.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (array != NULL) {
#line 1005 "moonshot-provisioning-common.c"
		int i;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			rule_destroy (&array[i]);
#line 1011 "moonshot-provisioning-common.c"
		}
	}
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_free (array);
#line 1016 "moonshot-provisioning-common.c"
}


static Rule* _vala_array_dup3 (Rule* self, int length) {
	Rule* result;
	int i;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = g_new0 (Rule, length);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	for (i = 0; i < length; i++) {
#line 1027 "moonshot-provisioning-common.c"
		Rule _tmp0_ = {0};
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		rule_copy (&self[i], &_tmp0_);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		result[i] = _tmp0_;
#line 1033 "moonshot-provisioning-common.c"
	}
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 1037 "moonshot-provisioning-common.c"
}


static void web_provisioning_parser_text_element_func (WebProvisioningParser* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	GSList* stack = NULL;
	GMarkupParseContext* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	GSList* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (context != NULL);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (text != NULL);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = context;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_markup_parse_context_get_element_stack (_tmp0_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	stack = _tmp1_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = text_len;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (_tmp2_ < ((gsize) 1)) {
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		return;
#line 1067 "moonshot-provisioning-common.c"
	}
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = stack;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = g_slist_nth_data (_tmp4_, (guint) 0);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (g_strcmp0 ((const gchar*) _tmp5_, "display-name") == 0) {
#line 1075 "moonshot-provisioning-common.c"
		GSList* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp6_ = stack;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp7_ = web_provisioning_display_name_handler (_tmp6_);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp3_ = _tmp7_;
#line 1084 "moonshot-provisioning-common.c"
	} else {
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp3_ = FALSE;
#line 1088 "moonshot-provisioning-common.c"
	}
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (_tmp3_) {
#line 1092 "moonshot-provisioning-common.c"
		IdCard* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp8_ = self->priv->card;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp9_ = text;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		id_card_set_display_name (_tmp8_, _tmp9_);
#line 1101 "moonshot-provisioning-common.c"
	} else {
		gboolean _tmp10_ = FALSE;
		GSList* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp11_ = stack;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp12_ = g_slist_nth_data (_tmp11_, (guint) 0);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		if (g_strcmp0 ((const gchar*) _tmp12_, "user") == 0) {
#line 1112 "moonshot-provisioning-common.c"
			GSList* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp13_ = stack;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp14_ = web_provisioning_user_handler (_tmp13_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp10_ = _tmp14_;
#line 1121 "moonshot-provisioning-common.c"
		} else {
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp10_ = FALSE;
#line 1125 "moonshot-provisioning-common.c"
		}
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		if (_tmp10_) {
#line 1129 "moonshot-provisioning-common.c"
			IdCard* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp15_ = self->priv->card;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp16_ = text;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			id_card_set_username (_tmp15_, _tmp16_);
#line 1138 "moonshot-provisioning-common.c"
		} else {
			gboolean _tmp17_ = FALSE;
			GSList* _tmp18_ = NULL;
			gconstpointer _tmp19_ = NULL;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp18_ = stack;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp19_ = g_slist_nth_data (_tmp18_, (guint) 0);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			if (g_strcmp0 ((const gchar*) _tmp19_, "password") == 0) {
#line 1149 "moonshot-provisioning-common.c"
				GSList* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp20_ = stack;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp21_ = web_provisioning_password_handler (_tmp20_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp17_ = _tmp21_;
#line 1158 "moonshot-provisioning-common.c"
			} else {
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp17_ = FALSE;
#line 1162 "moonshot-provisioning-common.c"
			}
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			if (_tmp17_) {
#line 1166 "moonshot-provisioning-common.c"
				IdCard* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp22_ = self->priv->card;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp23_ = text;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				id_card_set_password (_tmp22_, _tmp23_);
#line 1175 "moonshot-provisioning-common.c"
			} else {
				gboolean _tmp24_ = FALSE;
				GSList* _tmp25_ = NULL;
				gconstpointer _tmp26_ = NULL;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp25_ = stack;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_tmp26_ = g_slist_nth_data (_tmp25_, (guint) 0);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				if (g_strcmp0 ((const gchar*) _tmp26_, "realm") == 0) {
#line 1186 "moonshot-provisioning-common.c"
					GSList* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp27_ = stack;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp28_ = web_provisioning_realm_handler (_tmp27_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp24_ = _tmp28_;
#line 1195 "moonshot-provisioning-common.c"
				} else {
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp24_ = FALSE;
#line 1199 "moonshot-provisioning-common.c"
				}
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				if (_tmp24_) {
#line 1203 "moonshot-provisioning-common.c"
					IdCard* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp29_ = self->priv->card;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp30_ = text;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					id_card_set_issuer (_tmp29_, _tmp30_);
#line 1212 "moonshot-provisioning-common.c"
				} else {
					GSList* _tmp31_ = NULL;
					gconstpointer _tmp32_ = NULL;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp31_ = stack;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					_tmp32_ = g_slist_nth_data (_tmp31_, (guint) 0);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
					if (g_strcmp0 ((const gchar*) _tmp32_, "service") == 0) {
#line 1222 "moonshot-provisioning-common.c"
						IdCard* _tmp33_ = NULL;
						GeeArrayList* _tmp34_ = NULL;
						GeeArrayList* _tmp35_ = NULL;
						const gchar* _tmp36_ = NULL;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						_tmp33_ = self->priv->card;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						_tmp34_ = id_card_get_services (_tmp33_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						_tmp35_ = _tmp34_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						_tmp36_ = text;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
#line 1237 "moonshot-provisioning-common.c"
					} else {
						gboolean _tmp37_ = FALSE;
						GSList* _tmp38_ = NULL;
						gconstpointer _tmp39_ = NULL;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						_tmp38_ = stack;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						_tmp39_ = g_slist_nth_data (_tmp38_, (guint) 0);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						if (g_strcmp0 ((const gchar*) _tmp39_, "pattern") == 0) {
#line 1248 "moonshot-provisioning-common.c"
							GSList* _tmp40_ = NULL;
							gboolean _tmp41_ = FALSE;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp40_ = stack;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp41_ = web_provisioning_pattern_handler (_tmp40_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp37_ = _tmp41_;
#line 1257 "moonshot-provisioning-common.c"
						} else {
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp37_ = FALSE;
#line 1261 "moonshot-provisioning-common.c"
						}
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
						if (_tmp37_) {
#line 1265 "moonshot-provisioning-common.c"
							Rule* temp = NULL;
							IdCard* _tmp42_ = NULL;
							Rule* _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							Rule* _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							Rule* _tmp45_ = NULL;
							gint _tmp45__length1 = 0;
							gint temp_length1 = 0;
							gint _temp_size_ = 0;
							IdCard* _tmp46_ = NULL;
							Rule* _tmp47_ = NULL;
							gint _tmp47__length1 = 0;
							Rule* _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							Rule* _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							const gchar* _tmp50_ = NULL;
							gchar* _tmp51_ = NULL;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp42_ = self->priv->card;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp43_ = id_card_get_rules (_tmp42_, &_tmp43__length1);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp44_ = _tmp43_;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp44__length1 = _tmp43__length1;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup2 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp45__length1 = _tmp44__length1;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							temp = _tmp45_;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							temp_length1 = _tmp45__length1;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_temp_size_ = temp_length1;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp46_ = self->priv->card;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp47_ = id_card_get_rules (_tmp46_, &_tmp47__length1);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp48_ = _tmp47_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp48__length1 = _tmp47__length1;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp49_ = temp;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp49__length1 = temp_length1;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp50_ = text;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp51_ = g_strdup (_tmp50_);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_g_free0 (_tmp48_[_tmp49__length1 - 1].pattern);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp48_[_tmp49__length1 - 1].pattern = _tmp51_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							temp = (_vala_Rule_array_free (temp, temp_length1), NULL);
#line 1325 "moonshot-provisioning-common.c"
						} else {
							gboolean _tmp52_ = FALSE;
							GSList* _tmp53_ = NULL;
							gconstpointer _tmp54_ = NULL;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp53_ = stack;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							_tmp54_ = g_slist_nth_data (_tmp53_, (guint) 0);
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							if (g_strcmp0 ((const gchar*) _tmp54_, "always-confirm") == 0) {
#line 1336 "moonshot-provisioning-common.c"
								GSList* _tmp55_ = NULL;
								gboolean _tmp56_ = FALSE;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								_tmp55_ = stack;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								_tmp56_ = web_provisioning_always_confirm_handler (_tmp55_);
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								_tmp52_ = _tmp56_;
#line 1345 "moonshot-provisioning-common.c"
							} else {
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								_tmp52_ = FALSE;
#line 1349 "moonshot-provisioning-common.c"
							}
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
							if (_tmp52_) {
#line 1353 "moonshot-provisioning-common.c"
								gboolean _tmp57_ = FALSE;
								const gchar* _tmp58_ = NULL;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								_tmp58_ = text;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								if (g_strcmp0 (_tmp58_, "true") == 0) {
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp57_ = TRUE;
#line 1362 "moonshot-provisioning-common.c"
								} else {
									const gchar* _tmp59_ = NULL;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp59_ = text;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp57_ = g_strcmp0 (_tmp59_, "false") == 0;
#line 1369 "moonshot-provisioning-common.c"
								}
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								if (_tmp57_) {
#line 1373 "moonshot-provisioning-common.c"
									Rule* temp = NULL;
									IdCard* _tmp60_ = NULL;
									Rule* _tmp61_ = NULL;
									gint _tmp61__length1 = 0;
									Rule* _tmp62_ = NULL;
									gint _tmp62__length1 = 0;
									Rule* _tmp63_ = NULL;
									gint _tmp63__length1 = 0;
									gint temp_length1 = 0;
									gint _temp_size_ = 0;
									IdCard* _tmp64_ = NULL;
									Rule* _tmp65_ = NULL;
									gint _tmp65__length1 = 0;
									Rule* _tmp66_ = NULL;
									gint _tmp66__length1 = 0;
									Rule* _tmp67_ = NULL;
									gint _tmp67__length1 = 0;
									const gchar* _tmp68_ = NULL;
									gchar* _tmp69_ = NULL;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp60_ = self->priv->card;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp61_ = id_card_get_rules (_tmp60_, &_tmp61__length1);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp62_ = _tmp61_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp62__length1 = _tmp61__length1;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp63_ = (_tmp62_ != NULL) ? _vala_array_dup3 (_tmp62_, _tmp62__length1) : ((gpointer) _tmp62_);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp63__length1 = _tmp62__length1;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									temp = _tmp63_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									temp_length1 = _tmp63__length1;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_temp_size_ = temp_length1;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp64_ = self->priv->card;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp65_ = id_card_get_rules (_tmp64_, &_tmp65__length1);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp66_ = _tmp65_;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp66__length1 = _tmp65__length1;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp67_ = temp;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp67__length1 = temp_length1;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp68_ = text;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp69_ = g_strdup (_tmp68_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_g_free0 (_tmp66_[_tmp67__length1 - 1].always_confirm);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp66_[_tmp67__length1 - 1].always_confirm = _tmp69_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									temp = (_vala_Rule_array_free (temp, temp_length1), NULL);
#line 1433 "moonshot-provisioning-common.c"
								}
							} else {
								gboolean _tmp70_ = FALSE;
								GSList* _tmp71_ = NULL;
								gconstpointer _tmp72_ = NULL;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								_tmp71_ = stack;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								_tmp72_ = g_slist_nth_data (_tmp71_, (guint) 0);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								if (g_strcmp0 ((const gchar*) _tmp72_, "ca-cert") == 0) {
#line 1445 "moonshot-provisioning-common.c"
									GSList* _tmp73_ = NULL;
									gboolean _tmp74_ = FALSE;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp73_ = stack;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp74_ = web_provisioning_ca_cert_handler (_tmp73_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp70_ = _tmp74_;
#line 1454 "moonshot-provisioning-common.c"
								} else {
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp70_ = FALSE;
#line 1458 "moonshot-provisioning-common.c"
								}
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
								if (_tmp70_) {
#line 1462 "moonshot-provisioning-common.c"
									const gchar* _tmp75_ = NULL;
									const gchar* _tmp76_ = NULL;
									gchar* _tmp77_ = NULL;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp76_ = text;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp75_ = _tmp76_;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									if (_tmp75_ == NULL) {
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp75_ = "";
#line 1474 "moonshot-provisioning-common.c"
									}
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp77_ = g_strdup (_tmp75_);
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_g_free0 (self->priv->ta_ca_cert);
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									self->priv->ta_ca_cert = _tmp77_;
#line 1482 "moonshot-provisioning-common.c"
								} else {
									gboolean _tmp78_ = FALSE;
									GSList* _tmp79_ = NULL;
									gconstpointer _tmp80_ = NULL;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp79_ = stack;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									_tmp80_ = g_slist_nth_data (_tmp79_, (guint) 0);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									if (g_strcmp0 ((const gchar*) _tmp80_, "server-cert") == 0) {
#line 1493 "moonshot-provisioning-common.c"
										GSList* _tmp81_ = NULL;
										gboolean _tmp82_ = FALSE;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp81_ = stack;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp82_ = web_provisioning_server_cert_handler (_tmp81_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp78_ = _tmp82_;
#line 1502 "moonshot-provisioning-common.c"
									} else {
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp78_ = FALSE;
#line 1506 "moonshot-provisioning-common.c"
									}
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
									if (_tmp78_) {
#line 1510 "moonshot-provisioning-common.c"
										const gchar* _tmp83_ = NULL;
										const gchar* _tmp84_ = NULL;
										gchar* _tmp85_ = NULL;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp84_ = text;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp83_ = _tmp84_;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										if (_tmp83_ == NULL) {
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp83_ = "";
#line 1522 "moonshot-provisioning-common.c"
										}
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp85_ = g_strdup (_tmp83_);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_g_free0 (self->priv->ta_server_cert);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										self->priv->ta_server_cert = _tmp85_;
#line 1530 "moonshot-provisioning-common.c"
									} else {
										gboolean _tmp86_ = FALSE;
										GSList* _tmp87_ = NULL;
										gconstpointer _tmp88_ = NULL;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp87_ = stack;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										_tmp88_ = g_slist_nth_data (_tmp87_, (guint) 0);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										if (g_strcmp0 ((const gchar*) _tmp88_, "subject") == 0) {
#line 1541 "moonshot-provisioning-common.c"
											GSList* _tmp89_ = NULL;
											gboolean _tmp90_ = FALSE;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp89_ = stack;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp90_ = web_provisioning_subject_handler (_tmp89_);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp86_ = _tmp90_;
#line 1550 "moonshot-provisioning-common.c"
										} else {
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp86_ = FALSE;
#line 1554 "moonshot-provisioning-common.c"
										}
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
										if (_tmp86_) {
#line 1558 "moonshot-provisioning-common.c"
											const gchar* _tmp91_ = NULL;
											gchar* _tmp92_ = NULL;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp91_ = text;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp92_ = g_strdup (_tmp91_);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_g_free0 (self->priv->ta_subject);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											self->priv->ta_subject = _tmp92_;
#line 1569 "moonshot-provisioning-common.c"
										} else {
											gboolean _tmp93_ = FALSE;
											GSList* _tmp94_ = NULL;
											gconstpointer _tmp95_ = NULL;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp94_ = stack;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											_tmp95_ = g_slist_nth_data (_tmp94_, (guint) 0);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											if (g_strcmp0 ((const gchar*) _tmp95_, "subject-alt") == 0) {
#line 1580 "moonshot-provisioning-common.c"
												GSList* _tmp96_ = NULL;
												gboolean _tmp97_ = FALSE;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												_tmp96_ = stack;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												_tmp97_ = web_provisioning_subject_alt_handler (_tmp96_);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												_tmp93_ = _tmp97_;
#line 1589 "moonshot-provisioning-common.c"
											} else {
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												_tmp93_ = FALSE;
#line 1593 "moonshot-provisioning-common.c"
											}
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
											if (_tmp93_) {
#line 1597 "moonshot-provisioning-common.c"
												const gchar* _tmp98_ = NULL;
												gchar* _tmp99_ = NULL;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												_tmp98_ = text;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												_tmp99_ = g_strdup (_tmp98_);
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												_g_free0 (self->priv->ta_subject_alt);
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
												self->priv->ta_subject_alt = _tmp99_;
#line 1608 "moonshot-provisioning-common.c"
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


WebProvisioningParser* web_provisioning_parser_construct (GType object_type, const gchar* path) {
	WebProvisioningParser * self = NULL;
	GMarkupParseContext* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self = (WebProvisioningParser*) g_object_new (object_type, NULL);
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_markup_parse_context_new (&WEB_PROVISIONING_PARSER_parser, 0, self, NULL);
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_markup_parse_context_free0 (self->priv->ctx);
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->ctx = _tmp0_;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = g_strdup ("");
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->text);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->text = _tmp1_;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = path;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->path);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->path = _tmp3_;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = path;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp5_ = g_file_new_for_path (_tmp4_);
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	file = _tmp5_;
#line 1663 "moonshot-provisioning-common.c"
	{
		GFileInputStream* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFileInputStream* _tmp8_ = NULL;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp9_ = NULL;
		gchar* line = NULL;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp7_ = file;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error_);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp6_ = _tmp8_;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1679 "moonshot-provisioning-common.c"
			goto __catch0_g_error;
		}
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp6_);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		dis = _tmp9_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		while (TRUE) {
#line 1688 "moonshot-provisioning-common.c"
			gchar* _tmp10_ = NULL;
			GDataInputStream* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp11_ = dis;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp12_ = g_data_input_stream_read_line (_tmp11_, NULL, NULL, &_inner_error_);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp10_ = _tmp12_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_g_free0 (line);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_g_object_unref0 (dis);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_g_object_unref0 (_tmp6_);
#line 1713 "moonshot-provisioning-common.c"
				goto __catch0_g_error;
			}
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp13_ = _tmp10_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp10_ = NULL;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_g_free0 (line);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			line = _tmp13_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp14_ = line;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			if (!(_tmp14_ != NULL)) {
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				_g_free0 (_tmp10_);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
				break;
#line 1732 "moonshot-provisioning-common.c"
			}
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp15_ = self->priv->text;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp16_ = line;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_g_free0 (self->priv->text);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			self->priv->text = _tmp17_;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp18_ = self->priv->text;
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_g_free0 (self->priv->text);
#line 268 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			self->priv->text = _tmp19_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
			_g_free0 (_tmp10_);
#line 1754 "moonshot-provisioning-common.c"
		}
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_free0 (line);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_object_unref0 (dis);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_object_unref0 (_tmp6_);
#line 1762 "moonshot-provisioning-common.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		e = _inner_error_;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_inner_error_ = NULL;
#line 273 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		g_error ("moonshot-provisioning-common.vala:273: Could not retreive file size");
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_error_free0 (e);
#line 1776 "moonshot-provisioning-common.c"
	}
	__finally0:
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_object_unref0 (file);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		g_clear_error (&_inner_error_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		return NULL;
#line 1789 "moonshot-provisioning-common.c"
	}
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_object_unref0 (file);
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return self;
#line 1795 "moonshot-provisioning-common.c"
}


WebProvisioningParser* web_provisioning_parser_new (const gchar* path) {
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return web_provisioning_parser_construct (WEB_PROVISIONING_TYPE_PARSER, path);
#line 1802 "moonshot-provisioning-common.c"
}


void web_provisioning_parser_parse (WebProvisioningParser* self) {
	GError * _inner_error_ = NULL;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (self != NULL);
#line 1810 "moonshot-provisioning-common.c"
	{
		GMarkupParseContext* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp0_ = self->priv->ctx;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp1_ = self->priv->text;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp2_ = self->priv->text;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp3_ = strlen (_tmp2_);
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp4_ = _tmp3_;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		g_markup_parse_context_parse (_tmp0_, _tmp1_, (gssize) _tmp4_, &_inner_error_);
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1831 "moonshot-provisioning-common.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		e = _inner_error_;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_inner_error_ = NULL;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp5_ = self->priv->path;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		g_error ("moonshot-provisioning-common.vala:284: Could not parse %s, invalid con" \
"tent", _tmp5_);
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_g_error_free0 (e);
#line 1850 "moonshot-provisioning-common.c"
	}
	__finally1:
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		g_clear_error (&_inner_error_);
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		return;
#line 1861 "moonshot-provisioning-common.c"
	}
}


IdCard** web_provisioning_parser_get_cards (WebProvisioningParser* self, int* result_length1) {
	IdCard** result;
	IdCard** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	IdCard** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = self->priv->_cards;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0__length1 = self->priv->_cards_length1;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = _tmp0_;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1__length1 = _tmp0__length1;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (result_length1) {
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		*result_length1 = _tmp1__length1;
#line 1886 "moonshot-provisioning-common.c"
	}
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = _tmp1_;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 1892 "moonshot-provisioning-common.c"
}


static IdCard** _vala_array_dup4 (IdCard** self, int length) {
	IdCard** result;
	int i;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	result = g_new0 (IdCard*, length + 1);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	for (i = 0; i < length; i++) {
#line 1903 "moonshot-provisioning-common.c"
		IdCard* _tmp0_ = NULL;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		result[i] = _tmp0_;
#line 1909 "moonshot-provisioning-common.c"
	}
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	return result;
#line 1913 "moonshot-provisioning-common.c"
}


static void web_provisioning_parser_set_cards (WebProvisioningParser* self, IdCard** value, int value_length1) {
	IdCard** _tmp0_ = NULL;
	IdCard** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	IdCard** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	IdCard** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_return_if_fail (self != NULL);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1_ = value;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp1__length1 = value_length1;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup4 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp2__length1 = _tmp1__length1;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = _tmp2_;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0__length1 = _tmp2__length1;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	__tmp0__size_ = _tmp0__length1;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	if (_tmp0_ == NULL) {
#line 1945 "moonshot-provisioning-common.c"
		IdCard** _tmp3_ = NULL;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp3_ = g_new0 (IdCard*, 0 + 1);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_object_unref), NULL);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp0_ = _tmp3_;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		_tmp0__length1 = 0;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		__tmp0__size_ = _tmp0__length1;
#line 1957 "moonshot-provisioning-common.c"
	}
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4_ = _tmp0_;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp4__length1 = _tmp0__length1;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = NULL;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0__length1 = 0;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->_cards = (_vala_array_free (self->priv->_cards, self->priv->_cards_length1, (GDestroyNotify) g_object_unref), NULL);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->_cards = _tmp4_;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->_cards_length1 = _tmp4__length1;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->__cards_size_ = self->priv->_cards_length1;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_object_unref), NULL);
#line 1977 "moonshot-provisioning-common.c"
}


static void web_provisioning_parser_class_init (WebProvisioningParserClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	web_provisioning_parser_parent_class = g_type_class_peek_parent (klass);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	g_type_class_add_private (klass, sizeof (WebProvisioningParserPrivate));
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_web_provisioning_parser_get_property;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_web_provisioning_parser_set_property;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	G_OBJECT_CLASS (klass)->finalize = web_provisioning_parser_finalize;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = moonshot_logger_new ("WebProvisioning");
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	web_provisioning_parser_logger = _tmp0_;
#line 1997 "moonshot-provisioning-common.c"
}


static void web_provisioning_parser_instance_init (WebProvisioningParser * self) {
	IdCard** _tmp0_ = NULL;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv = WEB_PROVISIONING_PARSER_GET_PRIVATE (self);
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_tmp0_ = g_new0 (IdCard*, 0 + 1);
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->_cards = _tmp0_;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->_cards_length1 = 0;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->__cards_size_ = self->priv->_cards_length1;
#line 2013 "moonshot-provisioning-common.c"
}


static void web_provisioning_parser_finalize (GObject* obj) {
	WebProvisioningParser * self;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParser);
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_markup_parse_context_free0 (self->priv->ctx);
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->text);
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->path);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->ta_ca_cert);
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->ta_server_cert);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->ta_subject);
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_free0 (self->priv->ta_subject_alt);
#line 240 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	_g_object_unref0 (self->priv->card);
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	self->priv->_cards = (_vala_array_free (self->priv->_cards, self->priv->_cards_length1, (GDestroyNotify) g_object_unref), NULL);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	G_OBJECT_CLASS (web_provisioning_parser_parent_class)->finalize (obj);
#line 2041 "moonshot-provisioning-common.c"
}


GType web_provisioning_parser_get_type (void) {
	static volatile gsize web_provisioning_parser_type_id__volatile = 0;
	if (g_once_init_enter (&web_provisioning_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WebProvisioningParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) web_provisioning_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WebProvisioningParser), 0, (GInstanceInitFunc) web_provisioning_parser_instance_init, NULL };
		GType web_provisioning_parser_type_id;
		web_provisioning_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "WebProvisioningParser", &g_define_type_info, 0);
		g_once_init_leave (&web_provisioning_parser_type_id__volatile, web_provisioning_parser_type_id);
	}
	return web_provisioning_parser_type_id__volatile;
}


static void _vala_web_provisioning_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	WebProvisioningParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParser);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	switch (property_id) {
#line 2062 "moonshot-provisioning-common.c"
		default:
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		break;
#line 2068 "moonshot-provisioning-common.c"
	}
}


static void _vala_web_provisioning_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	WebProvisioningParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParser);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
	switch (property_id) {
#line 2078 "moonshot-provisioning-common.c"
		default:
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-provisioning-common.vala"
		break;
#line 2084 "moonshot-provisioning-common.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



