/* moonshot-identity-dialog.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-identity-dialog.vala, do not modify */

/*
 * Copyright (c) 2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <atk/atk.h>
#include <gio/gio.h>


#define TYPE_IDENTITY_DIALOG (identity_dialog_get_type ())
#define IDENTITY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_DIALOG, IdentityDialog))
#define IDENTITY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_DIALOG, IdentityDialogClass))
#define IS_IDENTITY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_DIALOG))
#define IS_IDENTITY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_DIALOG))
#define IDENTITY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_DIALOG, IdentityDialogClass))

typedef struct _IdentityDialog IdentityDialog;
typedef struct _IdentityDialogClass IdentityDialogClass;
typedef struct _IdentityDialogPrivate IdentityDialogPrivate;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TRUST_ANCHOR_TYPE_TRUST_ANCHOR_TYPE (trust_anchor_trust_anchor_type_get_type ())
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IdentityDialog {
	GtkDialog parent_instance;
	IdentityDialogPrivate * priv;
	gboolean complete;
	gboolean clear_trust_anchor;
};

struct _IdentityDialogClass {
	GtkDialogClass parent_class;
};

struct _IdentityDialogPrivate {
	GtkEntry* displayname_entry;
	GtkLabel* displayname_label;
	GtkEntry* realm_entry;
	GtkLabel* realm_label;
	GtkEntry* username_entry;
	GtkLabel* username_label;
	GtkEntry* password_entry;
	GtkLabel* password_label;
	GtkCheckButton* remember_checkbutton;
	GtkLabel* message_label;
	IdCard* card;
	GeeArrayList* services;
	GtkLabel* selected_item;
};

struct _Block4Data {
	int _ref_count_;
	IdentityDialog* self;
	gint ncolumns;
	gchar* ta_label_prefix;
	gchar* none;
	GtkLabel* ta_label;
	GtkAttachOptions fill_and_expand;
	GtkTable* ta_table;
	IdCard* id;
};

typedef enum  {
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_EMPTY,
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_CA_CERT,
	TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT
} TrustAnchorTrustAnchorType;

struct _Block5Data {
	int _ref_count_;
	IdentityDialog* self;
	GtkButton* remove_button;
	GtkTable* services_table;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkLabel* label;
};


extern gchar* export_directory;
gchar* export_directory = NULL;
static gpointer identity_dialog_parent_class = NULL;
static GdkColor identity_dialog_white;
static GdkColor identity_dialog_white = {0};
static GdkColor identity_dialog_selected_color;
static GdkColor identity_dialog_selected_color = {0};
static MoonshotLogger* identity_dialog_logger;
static MoonshotLogger* identity_dialog_logger = NULL;

#define CANCEL GTK_STOCK_CANCEL
GType identity_dialog_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
#define IDENTITY_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IDENTITY_DIALOG, IdentityDialogPrivate))
enum  {
	IDENTITY_DIALOG_DUMMY_PROPERTY,
	IDENTITY_DIALOG_DISPLAY_NAME,
	IDENTITY_DIALOG_ISSUER,
	IDENTITY_DIALOG_USERNAME,
	IDENTITY_DIALOG_PASSWORD,
	IDENTITY_DIALOG_STORE_PASSWORD
};
void make_color (guint16 red, guint16 green, guint16 blue, GdkColor* result);
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
#define IDENTITY_DIALOG_displayname_labeltext _ ("Display Name")
#define IDENTITY_DIALOG_realm_labeltext _ ("Realm")
#define IDENTITY_DIALOG_username_labeltext _ ("Username")
#define IDENTITY_DIALOG_password_labeltext _ ("Password")
void identity_dialog_clear_password (IdentityDialog* self);
void clear_password_entry (GtkEntry* entry);
GeeArrayList* identity_dialog_get_services (IdentityDialog* self);
GType identity_manager_view_get_type (void) G_GNUC_CONST;
IdentityDialog* identity_dialog_new (IdentityManagerView* parent);
IdentityDialog* identity_dialog_construct (GType object_type, IdentityManagerView* parent);
IdentityDialog* identity_dialog_new_with_idcard (IdCard* a_card, const gchar* title, IdentityManagerView* parent);
IdentityDialog* identity_dialog_construct_with_idcard (GType object_type, IdCard* a_card, const gchar* title, IdentityManagerView* parent);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
const gchar* id_card_get_display_name (IdCard* self);
const gchar* id_card_get_issuer (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
gboolean id_card_get_store_password (IdCard* self);
const gchar* id_card_get_password (IdCard* self);
void set_atk_relation (GtkWidget* widget, GtkWidget* target_widget, AtkRelationType relationship);
static void identity_dialog_add_as_vbox (GtkBox* content_area, GtkLabel* label, GtkEntry* entry);
static void identity_dialog_on_response (IdentityDialog* self, GtkDialog* source, gint response_id);
static void _identity_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GeeArrayList* id_card_get_services (IdCard* self);
static GtkWidget* identity_dialog_make_trust_anchor_box (IdentityDialog* self, IdCard* id);
static GtkVBox* identity_dialog_make_services_vbox (IdentityDialog* self);
gboolean id_card_is_no_identity (IdCard* self);
static void __lambda12_ (IdentityDialog* self);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
static void ___lambda12__gtk_object_destroy (GtkObject* _sender, gpointer self);
void set_bg_color (GtkWidget* w);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
gboolean trust_anchor_is_empty (TrustAnchor* self);
static void __lambda8_ (Block4Data* _data4_, GtkButton* w);
gboolean warning_dialog_confirm (GtkWindow* parent, const gchar* message, const gchar* dialog_name);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
const gchar* trust_anchor_get_datetime_added (TrustAnchor* self);
GType trust_anchor_trust_anchor_type_get_type (void) G_GNUC_CONST;
TrustAnchorTrustAnchorType trust_anchor_get_anchor_type (TrustAnchor* self);
GtkWidget* make_ta_fingerprint_widget (const gchar* server_cert, const gchar* label_text);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
static void ___lambda9_ (Block4Data* _data4_, GtkButton* w);
static void identity_dialog_export_certificate (IdentityDialog* self, IdCard* id);
static void ____lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
gchar* trust_anchor_get_expiration_date (TrustAnchor* self, gchar** err_out);
static gchar* identity_dialog_update_preamble (const gchar* preamble);
static gchar* identity_dialog_update_message (const gchar* old_message, const gchar* new_item);
static void identity_dialog_check_field (const gchar* field, GtkLabel* label, const gchar* fieldname, gchar** preamble, gchar** message);
static gboolean identity_dialog_check_fields (IdentityDialog* self);
gboolean identity_dialog_get_store_password (IdentityDialog* self);
const gchar* identity_dialog_get_password (IdentityDialog* self);
const gchar* identity_dialog_get_display_name (IdentityDialog* self);
const gchar* identity_dialog_get_username (IdentityDialog* self);
const gchar* identity_dialog_get_issuer (IdentityDialog* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ____lambda10_ (Block6Data* _data6_);
const gchar* gtk_state_type_to_string (GtkStateType self);
static gboolean _____lambda10__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __lambda11_ (Block5Data* _data5_, GtkButton* remove_button);
static void ___lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
static void identity_dialog_finalize (GObject* obj);
static void _vala_identity_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
     * Don't leave passwords in memory longer than necessary.
     * This may not actually erase the password data bytes, but it seems to be the best we can do.
     */
void identity_dialog_clear_password (IdentityDialog* self) {
	GtkEntry* _tmp0_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = self->priv->password_entry;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	clear_password_entry (_tmp0_);
#line 281 "moonshot-identity-dialog.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 288 "moonshot-identity-dialog.c"
}


GeeArrayList* identity_dialog_get_services (IdentityDialog* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = self->priv->services;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = _tmp1_;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 306 "moonshot-identity-dialog.c"
}


IdentityDialog* identity_dialog_construct (GType object_type, IdentityManagerView* parent) {
	IdentityDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	IdentityManagerView* _tmp1_ = NULL;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = _ ("Add ID Card");
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = parent;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self = (IdentityDialog*) identity_dialog_construct_with_idcard (object_type, NULL, _tmp0_, _tmp1_);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return self;
#line 324 "moonshot-identity-dialog.c"
}


IdentityDialog* identity_dialog_new (IdentityManagerView* parent) {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return identity_dialog_construct (TYPE_IDENTITY_DIALOG, parent);
#line 331 "moonshot-identity-dialog.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 343 "moonshot-identity-dialog.c"
}


static void _identity_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_on_response ((IdentityDialog*) self, _sender, response_id);
#line 350 "moonshot-identity-dialog.c"
}


static void __lambda12_ (IdentityDialog* self) {
	MoonshotLogger* _tmp0_ = NULL;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = identity_dialog_logger;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	moonshot_logger_trace (_tmp0_, "Destroying IdentityDialog; clearing its password.", NULL);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_clear_password (self);
#line 362 "moonshot-identity-dialog.c"
}


static void ___lambda12__gtk_object_destroy (GtkObject* _sender, gpointer self) {
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	__lambda12_ ((IdentityDialog*) self);
#line 369 "moonshot-identity-dialog.c"
}


IdentityDialog* identity_dialog_construct_with_idcard (GType object_type, IdCard* a_card, const gchar* title, IdentityManagerView* parent) {
	IdentityDialog * self = NULL;
	gboolean is_new_card = FALSE;
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	IdentityManagerView* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkBox* content_area = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkEntry* _tmp16_ = NULL;
	GtkEntry* _tmp17_ = NULL;
	IdCard* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkEntry* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkEntry* _tmp27_ = NULL;
	GtkEntry* _tmp28_ = NULL;
	IdCard* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GtkEntry* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkEntry* _tmp38_ = NULL;
	GtkEntry* _tmp39_ = NULL;
	IdCard* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GtkEntry* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	GtkLabel* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GtkCheckButton* _tmp50_ = NULL;
	GtkCheckButton* _tmp51_ = NULL;
	IdCard* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	GtkEntry* _tmp55_ = NULL;
	GtkEntry* _tmp56_ = NULL;
	GtkEntry* _tmp57_ = NULL;
	GtkEntry* _tmp58_ = NULL;
	GtkEntry* _tmp59_ = NULL;
	IdCard* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkLabel* _tmp64_ = NULL;
	GtkLabel* _tmp65_ = NULL;
	GtkEntry* _tmp66_ = NULL;
	GtkLabel* _tmp67_ = NULL;
	GtkEntry* _tmp68_ = NULL;
	GtkLabel* _tmp69_ = NULL;
	GtkEntry* _tmp70_ = NULL;
	GtkLabel* _tmp71_ = NULL;
	GtkEntry* _tmp72_ = NULL;
	GtkBox* _tmp73_ = NULL;
	GtkLabel* _tmp74_ = NULL;
	GtkBox* _tmp75_ = NULL;
	GtkLabel* _tmp76_ = NULL;
	GtkEntry* _tmp77_ = NULL;
	GtkBox* _tmp78_ = NULL;
	GtkLabel* _tmp79_ = NULL;
	GtkEntry* _tmp80_ = NULL;
	GtkBox* _tmp81_ = NULL;
	GtkLabel* _tmp82_ = NULL;
	GtkEntry* _tmp83_ = NULL;
	GtkBox* _tmp84_ = NULL;
	GtkLabel* _tmp85_ = NULL;
	GtkEntry* _tmp86_ = NULL;
	GtkHBox* remember_hbox = NULL;
	GtkHBox* _tmp87_ = NULL;
	GtkHBox* _tmp88_ = NULL;
	GtkHBox* _tmp89_ = NULL;
	GtkHBox* _tmp90_ = NULL;
	GtkHBox* _tmp91_ = NULL;
	GtkCheckButton* _tmp92_ = NULL;
	GtkBox* _tmp93_ = NULL;
	GtkHBox* _tmp94_ = NULL;
	GtkBox* _tmp95_ = NULL;
	GeeArrayList* _tmp96_ = NULL;
	GeeArrayList* _tmp97_ = NULL;
	IdCard* _tmp98_ = NULL;
	GeeArrayList* _tmp99_ = NULL;
	GeeArrayList* _tmp100_ = NULL;
	gboolean _tmp101_ = FALSE;
	IdCard* _tmp113_ = NULL;
	gboolean _tmp114_ = FALSE;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self = (IdentityDialog*) g_object_new (object_type, NULL);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	is_new_card = FALSE;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = a_card;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp0_ == NULL) {
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		is_new_card = TRUE;
#line 495 "moonshot-identity-dialog.c"
	}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = a_card;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = _tmp3_;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp1_ == NULL) {
#line 505 "moonshot-identity-dialog.c"
		IdCard* _tmp4_ = NULL;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp4_ = id_card_new ();
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_tmp1_);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp1_ = _tmp4_;
#line 513 "moonshot-identity-dialog.c"
	}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp5_ = _tmp1_;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = NULL;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->card);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->card = _tmp5_;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp6_ = title;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp6_);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = parent;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp7_);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = _ ("OK");
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_dialog_add_buttons ((GtkDialog*) self, CANCEL, GTK_RESPONSE_CANCEL, _tmp8_, GTK_RESPONSE_OK, NULL);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = gtk_dialog_get_content_area ((GtkDialog*) self);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_BOX, GtkBox));
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	content_area = _tmp10_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = string_to_string (IDENTITY_DIALOG_displayname_labeltext);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp12_ = g_strconcat (_tmp11_, ":", NULL);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp13_ = _tmp12_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp13_);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp14_);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->displayname_label);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->displayname_label = _tmp14_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp13_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp15_ = self->priv->displayname_label;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp15_, (gfloat) 0, (gfloat) 0.5);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp16_ = (GtkEntry*) gtk_entry_new ();
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp16_);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->displayname_entry);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->displayname_entry = _tmp16_;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp17_ = self->priv->displayname_entry;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp18_ = self->priv->card;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp19_ = id_card_get_display_name (_tmp18_);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp20_ = _tmp19_;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_text (_tmp17_, _tmp20_);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp21_ = self->priv->displayname_entry;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_width_chars (_tmp21_, 40);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp22_ = string_to_string (IDENTITY_DIALOG_realm_labeltext);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp23_ = g_strconcat (_tmp22_, ":", NULL);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp24_ = _tmp23_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp25_ = (GtkLabel*) gtk_label_new (_tmp24_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp25_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->realm_label);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->realm_label = _tmp25_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp24_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp26_ = self->priv->realm_label;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp26_, (gfloat) 0, (gfloat) 0.5);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp27_ = (GtkEntry*) gtk_entry_new ();
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp27_);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->realm_entry);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->realm_entry = _tmp27_;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp28_ = self->priv->realm_entry;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp29_ = self->priv->card;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp30_ = id_card_get_issuer (_tmp29_);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp31_ = _tmp30_;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_text (_tmp28_, _tmp31_);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp32_ = self->priv->realm_entry;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_width_chars (_tmp32_, 60);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp33_ = string_to_string (IDENTITY_DIALOG_username_labeltext);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp34_ = g_strconcat (_tmp33_, ":", NULL);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp35_ = _tmp34_;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp36_ = (GtkLabel*) gtk_label_new (_tmp35_);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp36_);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->username_label);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->username_label = _tmp36_;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp35_);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp37_ = self->priv->username_label;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp37_, (gfloat) 0, (gfloat) 0.5);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp38_ = (GtkEntry*) gtk_entry_new ();
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp38_);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->username_entry = _tmp38_;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp39_ = self->priv->username_entry;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp40_ = self->priv->card;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp41_ = id_card_get_username (_tmp40_);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp42_ = _tmp41_;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_text (_tmp39_, _tmp42_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp43_ = self->priv->username_entry;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_width_chars (_tmp43_, 40);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp44_ = string_to_string (IDENTITY_DIALOG_password_labeltext);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp45_ = g_strconcat (_tmp44_, ":", NULL);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp46_ = _tmp45_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp47_ = (GtkLabel*) gtk_label_new (_tmp46_);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp47_);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->password_label);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->password_label = _tmp47_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp46_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp48_ = self->priv->password_label;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp48_, (gfloat) 0, (gfloat) 0.5);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp49_ = _ ("Remember password");
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp50_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp49_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp50_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->remember_checkbutton);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->remember_checkbutton = _tmp50_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp51_ = self->priv->remember_checkbutton;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp52_ = self->priv->card;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp53_ = id_card_get_store_password (_tmp52_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp54_ = _tmp53_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp51_, _tmp54_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp55_ = (GtkEntry*) gtk_entry_new ();
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp55_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->password_entry = _tmp55_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp56_ = self->priv->password_entry;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_invisible_char (_tmp56_, (gunichar) '*');
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp57_ = self->priv->password_entry;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_visibility (_tmp57_, FALSE);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp58_ = self->priv->password_entry;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_width_chars (_tmp58_, 40);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp59_ = self->priv->password_entry;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp60_ = self->priv->card;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp61_ = id_card_get_password (_tmp60_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp62_ = _tmp61_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_entry_set_text (_tmp59_, _tmp62_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp63_ = (GtkLabel*) gtk_label_new ("");
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp63_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->message_label);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->message_label = _tmp63_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp64_ = self->priv->message_label;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp64_, FALSE);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp65_ = self->priv->displayname_label;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp66_ = self->priv->displayname_entry;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	set_atk_relation ((GtkWidget*) _tmp65_, (GtkWidget*) _tmp66_, ATK_RELATION_LABEL_FOR);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp67_ = self->priv->realm_label;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp68_ = self->priv->realm_entry;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	set_atk_relation ((GtkWidget*) _tmp67_, (GtkWidget*) _tmp68_, ATK_RELATION_LABEL_FOR);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp69_ = self->priv->username_label;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp70_ = self->priv->username_entry;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	set_atk_relation ((GtkWidget*) _tmp69_, (GtkWidget*) _tmp70_, ATK_RELATION_LABEL_FOR);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp71_ = self->priv->password_label;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp72_ = self->priv->password_entry;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	set_atk_relation ((GtkWidget*) _tmp71_, (GtkWidget*) _tmp72_, ATK_RELATION_LABEL_FOR);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp73_ = content_area;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp74_ = self->priv->message_label;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start (_tmp73_, (GtkWidget*) _tmp74_, FALSE, FALSE, (guint) 6);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp75_ = content_area;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp76_ = self->priv->displayname_label;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp77_ = self->priv->displayname_entry;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_add_as_vbox (_tmp75_, _tmp76_, _tmp77_);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp78_ = content_area;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp79_ = self->priv->username_label;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp80_ = self->priv->username_entry;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_add_as_vbox (_tmp78_, _tmp79_, _tmp80_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp81_ = content_area;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp82_ = self->priv->realm_label;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp83_ = self->priv->realm_entry;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_add_as_vbox (_tmp81_, _tmp82_, _tmp83_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp84_ = content_area;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp85_ = self->priv->password_label;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp86_ = self->priv->password_entry;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_add_as_vbox (_tmp84_, _tmp85_, _tmp86_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp87_ = (GtkHBox*) gtk_hbox_new (FALSE, 40);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp87_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	remember_hbox = _tmp87_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp88_ = remember_hbox;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp89_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp89_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp90_ = _tmp89_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp88_, (GtkWidget*) _tmp90_, FALSE, FALSE, (guint) 0);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (_tmp90_);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp91_ = remember_hbox;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp92_ = self->priv->remember_checkbutton;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp91_, (GtkWidget*) _tmp92_, FALSE, FALSE, (guint) 0);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp93_ = content_area;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp94_ = remember_hbox;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start (_tmp93_, (GtkWidget*) _tmp94_, FALSE, FALSE, (guint) 2);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _identity_dialog_on_response_gtk_dialog_response, self, 0);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp95_ = content_area;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp95_, (guint) 6);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp96_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->services);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->services = _tmp96_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp97_ = self->priv->services;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp98_ = self->priv->card;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp99_ = id_card_get_services (_tmp98_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp100_ = _tmp99_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gee_array_list_add_all (_tmp97_, (GeeCollection*) _tmp100_);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp101_ = is_new_card;
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (!_tmp101_) {
#line 869 "moonshot-identity-dialog.c"
		GtkWidget* trust_anchor_box = NULL;
		IdCard* _tmp102_ = NULL;
		GtkWidget* _tmp103_ = NULL;
		GtkBox* _tmp104_ = NULL;
		GtkWidget* _tmp105_ = NULL;
		GtkVBox* services_vbox = NULL;
		GtkVBox* _tmp106_ = NULL;
		GtkBox* _tmp107_ = NULL;
		GtkVBox* _tmp108_ = NULL;
		GtkAlignment* services_vbox_bottom_spacer = NULL;
		GtkAlignment* _tmp109_ = NULL;
		GtkAlignment* _tmp110_ = NULL;
		GtkBox* _tmp111_ = NULL;
		GtkAlignment* _tmp112_ = NULL;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp102_ = self->priv->card;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp103_ = identity_dialog_make_trust_anchor_box (self, _tmp102_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		trust_anchor_box = _tmp103_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp104_ = content_area;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp105_ = trust_anchor_box;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_box_pack_start (_tmp104_, _tmp105_, FALSE, FALSE, (guint) 15);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp106_ = identity_dialog_make_services_vbox (self);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		services_vbox = _tmp106_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp107_ = content_area;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp108_ = services_vbox;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_box_pack_start (_tmp107_, (GtkWidget*) _tmp108_, TRUE, TRUE, (guint) 0);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp109_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, (gfloat) 0, (gfloat) 0, (gfloat) 0);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_object_ref_sink (_tmp109_);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		services_vbox_bottom_spacer = _tmp109_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp110_ = services_vbox_bottom_spacer;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_size_request ((GtkWidget*) _tmp110_, 0, 12);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp111_ = content_area;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp112_ = services_vbox_bottom_spacer;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_box_pack_start (_tmp111_, (GtkWidget*) _tmp112_, FALSE, FALSE, (guint) 0);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (services_vbox_bottom_spacer);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (services_vbox);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (trust_anchor_box);
#line 928 "moonshot-identity-dialog.c"
	}
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp113_ = self->priv->card;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp114_ = id_card_is_no_identity (_tmp113_);
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp114_) {
#line 936 "moonshot-identity-dialog.c"
		GtkEntry* _tmp115_ = NULL;
		GtkEntry* _tmp116_ = NULL;
		GtkEntry* _tmp117_ = NULL;
		GtkEntry* _tmp118_ = NULL;
		GtkCheckButton* _tmp119_ = NULL;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp115_ = self->priv->displayname_entry;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp115_, FALSE);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp116_ = self->priv->realm_entry;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp116_, FALSE);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp117_ = self->priv->username_entry;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp117_, FALSE);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp118_ = self->priv->password_entry;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp118_, FALSE);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp119_ = self->priv->remember_checkbutton;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp119_, FALSE);
#line 962 "moonshot-identity-dialog.c"
	}
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_signal_connect_object ((GtkObject*) self, "destroy", (GCallback) ___lambda12__gtk_object_destroy, self, 0);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 6);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	set_bg_color ((GtkWidget*) self);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (remember_hbox);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (content_area);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (_tmp1_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return self;
#line 982 "moonshot-identity-dialog.c"
}


IdentityDialog* identity_dialog_new_with_idcard (IdCard* a_card, const gchar* title, IdentityManagerView* parent) {
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return identity_dialog_construct_with_idcard (TYPE_IDENTITY_DIALOG, a_card, title, parent);
#line 989 "moonshot-identity-dialog.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return _data4_;
#line 998 "moonshot-identity-dialog.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 1007 "moonshot-identity-dialog.c"
		IdentityDialog* self;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		self = _data4_->self;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_data4_->ta_table);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_data4_->ta_label);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_data4_->none);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_data4_->ta_label_prefix);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_data4_->id);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (self);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_slice_free (Block4Data, _data4_);
#line 1025 "moonshot-identity-dialog.c"
	}
}


static void __lambda8_ (Block4Data* _data4_, GtkButton* w) {
	IdentityDialog* self;
	gboolean _result_ = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self = _data4_->self;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (w != NULL);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = _ ("You are about to clear the trust anchor fingerprint for '%s'.");
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = g_strconcat ("<span font-weight='heavy'>", _tmp0_, NULL);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = _tmp1_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = g_strconcat (_tmp2_, "</span>", NULL);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = _tmp3_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp5_ = _data4_->id;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp6_ = id_card_get_display_name (_tmp5_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = _tmp6_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = g_markup_printf_escaped (_tmp4_, _tmp7_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = _tmp8_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = _ ("\n\nAre you sure you want to do this?");
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp12_ = _tmp11_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp13_ = warning_dialog_confirm ((GtkWindow*) self, _tmp12_, "clear_trust_anchor");
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = _tmp13_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp12_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp9_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp4_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp2_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_result_ = _tmp14_;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp15_ = _result_;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp15_) {
#line 1097 "moonshot-identity-dialog.c"
		GList* children = NULL;
		GtkTable* _tmp16_ = NULL;
		GList* _tmp17_ = NULL;
		GList* _tmp18_ = NULL;
		GtkTable* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		GtkLabel* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GtkTable* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		GtkAttachOptions _tmp30_ = 0;
		GtkAttachOptions _tmp31_ = 0;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		self->clear_trust_anchor = TRUE;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp16_ = _data4_->ta_table;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp17_ = gtk_container_get_children ((GtkContainer*) _tmp16_);
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		children = _tmp17_;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp18_ = children;
#line 1123 "moonshot-identity-dialog.c"
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			child_collection = _tmp18_;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1131 "moonshot-identity-dialog.c"
				GtkWidget* child = NULL;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
				child = (GtkWidget*) child_it->data;
#line 1135 "moonshot-identity-dialog.c"
				{
					GtkTable* _tmp19_ = NULL;
					GtkWidget* _tmp20_ = NULL;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
					_tmp19_ = _data4_->ta_table;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
					_tmp20_ = child;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
					gtk_container_remove ((GtkContainer*) _tmp19_, _tmp20_);
#line 1145 "moonshot-identity-dialog.c"
				}
			}
		}
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp21_ = _data4_->ta_table;
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp22_ = _data4_->ncolumns;
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_table_resize (_tmp21_, (guint) 1, (guint) _tmp22_);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp23_ = _data4_->ta_label;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp24_ = _data4_->ta_label_prefix;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp25_ = _data4_->none;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp27_ = _tmp26_;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_label_set_text (_tmp23_, _tmp27_);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_tmp27_);
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp28_ = _data4_->ta_table;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp29_ = _data4_->ta_label;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp30_ = _data4_->fill_and_expand;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp31_ = _data4_->fill_and_expand;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_table_attach (_tmp28_, (GtkWidget*) _tmp29_, (guint) 0, (guint) 1, (guint) 0, (guint) 1, _tmp30_, _tmp31_, (guint) 0, (guint) 0);
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_list_free0 (children);
#line 1181 "moonshot-identity-dialog.c"
	}
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	__lambda8_ (self, _sender);
#line 1189 "moonshot-identity-dialog.c"
}


static void ___lambda9_ (Block4Data* _data4_, GtkButton* w) {
	IdentityDialog* self;
	IdCard* _tmp0_ = NULL;
#line 296 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self = _data4_->self;
#line 296 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (w != NULL);
#line 296 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = _data4_->id;
#line 296 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_export_certificate (self, _tmp0_);
#line 1204 "moonshot-identity-dialog.c"
}


static void ____lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 296 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	___lambda9_ (self, _sender);
#line 1211 "moonshot-identity-dialog.c"
}


static GtkWidget* identity_dialog_make_trust_anchor_box (IdentityDialog* self, IdCard* id) {
	GtkWidget* result = NULL;
	Block4Data* _data4_;
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	gint nrows = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkHBox* trust_anchor_box = NULL;
	GtkHBox* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	IdCard* _tmp8_ = NULL;
	TrustAnchor* _tmp9_ = NULL;
	TrustAnchor* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	IdCard* _tmp20_ = NULL;
	TrustAnchor* _tmp21_ = NULL;
	TrustAnchor* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GtkAttachOptions fill = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	GtkTable* _tmp28_ = NULL;
	gint row = 0;
	GtkButton* ta_clear_button = NULL;
	const gchar* _tmp29_ = NULL;
	GtkButton* _tmp30_ = NULL;
	GtkButton* _tmp31_ = NULL;
	GtkTable* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	GtkAttachOptions _tmp36_ = 0;
	GtkAttachOptions _tmp37_ = 0;
	GtkTable* _tmp38_ = NULL;
	GtkButton* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	GtkAttachOptions _tmp42_ = 0;
	GtkAttachOptions _tmp43_ = 0;
	gint _tmp44_ = 0;
	GtkLabel* added_label = NULL;
	IdCard* _tmp45_ = NULL;
	TrustAnchor* _tmp46_ = NULL;
	TrustAnchor* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	GtkLabel* _tmp54_ = NULL;
	GtkLabel* _tmp55_ = NULL;
	GtkTable* _tmp56_ = NULL;
	GtkLabel* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	GtkAttachOptions _tmp60_ = 0;
	GtkAttachOptions _tmp61_ = 0;
	gint _tmp62_ = 0;
	IdCard* _tmp63_ = NULL;
	TrustAnchor* _tmp64_ = NULL;
	TrustAnchor* _tmp65_ = NULL;
	TrustAnchorTrustAnchorType _tmp66_ = 0;
	GtkHBox* _tmp172_ = NULL;
	GtkTable* _tmp173_ = NULL;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->_ref_count_ = 1;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->self = g_object_ref (self);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = id;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (_data4_->id);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->id = _tmp1_;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	nrows = 7;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->ncolumns = 2;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = _ ("Trust anchor: ");
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->ta_label_prefix = _tmp3_;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = _ ("None");
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->none = _tmp5_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp6_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp6_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	trust_anchor_box = _tmp6_;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = _data4_->id;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = id_card_get_trust_anchor (_tmp8_);
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = _tmp9_;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = trust_anchor_is_empty (_tmp10_);
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp11_) {
#line 1339 "moonshot-identity-dialog.c"
		const gchar* _tmp12_ = NULL;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp12_ = _data4_->none;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp7_ = _tmp12_;
#line 1345 "moonshot-identity-dialog.c"
	} else {
		const gchar* _tmp13_ = NULL;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp13_ = _ ("Enterprise provisioned");
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp7_ = _tmp13_;
#line 1352 "moonshot-identity-dialog.c"
	}
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = _data4_->ta_label_prefix;
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp15_ = g_strconcat (_tmp14_, _tmp7_, NULL);
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp16_ = _tmp15_;
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp17_);
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp18_ = _tmp17_;
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp16_);
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->ta_label = _tmp18_;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp19_ = _data4_->ta_label;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp19_, (gfloat) 0, 0.5f);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp20_ = _data4_->id;
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp21_ = id_card_get_trust_anchor (_tmp20_);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp22_ = _tmp21_;
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp23_ = trust_anchor_is_empty (_tmp22_);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp23_) {
#line 1384 "moonshot-identity-dialog.c"
		GtkHBox* _tmp24_ = NULL;
		GtkLabel* _tmp25_ = NULL;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp24_ = trust_anchor_box;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp25_ = _data4_->ta_label;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_box_pack_start ((GtkBox*) _tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		result = (GtkWidget*) trust_anchor_box;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		block4_data_unref (_data4_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_data4_ = NULL;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		return result;
#line 1401 "moonshot-identity-dialog.c"
	}
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->fill_and_expand = GTK_EXPAND | GTK_FILL;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	fill = GTK_FILL;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp26_ = nrows;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp27_ = _data4_->ncolumns;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp28_ = (GtkTable*) gtk_table_new ((guint) _tmp26_, (guint) _tmp27_, FALSE);
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp28_);
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_->ta_table = _tmp28_;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	row = 0;
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp29_ = _ ("Clear Trust Anchor");
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp30_ = (GtkButton*) gtk_button_new_with_label (_tmp29_);
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp30_);
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	ta_clear_button = _tmp30_;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp31_ = ta_clear_button;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_signal_connect_data (_tmp31_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp32_ = _data4_->ta_table;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp33_ = _data4_->ta_label;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp34_ = row;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp35_ = row;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp36_ = _data4_->fill_and_expand;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp37_ = _data4_->fill_and_expand;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_table_attach (_tmp32_, (GtkWidget*) _tmp33_, (guint) 0, (guint) 1, (guint) _tmp34_, (guint) (_tmp35_ + 1), _tmp36_, _tmp37_, (guint) 0, (guint) 0);
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp38_ = _data4_->ta_table;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp39_ = ta_clear_button;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp40_ = row;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp41_ = row;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp42_ = fill;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp43_ = fill;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_table_attach (_tmp38_, (GtkWidget*) _tmp39_, (guint) 1, (guint) 2, (guint) _tmp40_, (guint) (_tmp41_ + 1), _tmp42_, _tmp43_, (guint) 0, (guint) 0);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp44_ = row;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	row = _tmp44_ + 1;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp45_ = _data4_->id;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp46_ = id_card_get_trust_anchor (_tmp45_);
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp47_ = _tmp46_;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp48_ = trust_anchor_get_datetime_added (_tmp47_);
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp49_ = _tmp48_;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp50_ = g_strconcat ("Added: ", _tmp49_, NULL);
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp51_ = _tmp50_;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp52_ = _ (_tmp51_);
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp53_ = (GtkLabel*) gtk_label_new (_tmp52_);
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp53_);
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp54_ = _tmp53_;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp51_);
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	added_label = _tmp54_;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp55_ = added_label;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp55_, (gfloat) 0, 0.5f);
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp56_ = _data4_->ta_table;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp57_ = added_label;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp58_ = row;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp59_ = row;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp60_ = _data4_->fill_and_expand;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp61_ = _data4_->fill_and_expand;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_table_attach (_tmp56_, (GtkWidget*) _tmp57_, (guint) 0, (guint) 1, (guint) _tmp58_, (guint) (_tmp59_ + 1), _tmp60_, _tmp61_, (guint) 20, (guint) 5);
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp62_ = row;
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	row = _tmp62_ + 1;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp63_ = _data4_->id;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp64_ = id_card_get_trust_anchor (_tmp63_);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp65_ = _tmp64_;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp66_ = trust_anchor_get_anchor_type (_tmp65_);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp66_ == TRUST_ANCHOR_TRUST_ANCHOR_TYPE_SERVER_CERT) {
#line 1521 "moonshot-identity-dialog.c"
		GtkWidget* fingerprint = NULL;
		IdCard* _tmp67_ = NULL;
		TrustAnchor* _tmp68_ = NULL;
		TrustAnchor* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		GtkWidget* _tmp72_ = NULL;
		GtkTable* _tmp73_ = NULL;
		GtkWidget* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		GtkAttachOptions _tmp77_ = 0;
		GtkAttachOptions _tmp78_ = 0;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp67_ = _data4_->id;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp68_ = id_card_get_trust_anchor (_tmp67_);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp69_ = _tmp68_;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp70_ = trust_anchor_get_server_cert (_tmp69_);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp71_ = _tmp70_;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp72_ = make_ta_fingerprint_widget (_tmp71_, NULL);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		fingerprint = _tmp72_;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp73_ = _data4_->ta_table;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp74_ = fingerprint;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp75_ = row;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp76_ = row;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp77_ = _data4_->fill_and_expand;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp78_ = _data4_->fill_and_expand;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_table_attach (_tmp73_, _tmp74_, (guint) 0, (guint) 2, (guint) _tmp75_, (guint) (_tmp76_ + 2), _tmp77_, _tmp78_, (guint) 5, (guint) 5);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (fingerprint);
#line 1565 "moonshot-identity-dialog.c"
	} else {
		GtkLabel* ca_cert_label = NULL;
		const gchar* _tmp79_ = NULL;
		GtkLabel* _tmp80_ = NULL;
		GtkLabel* _tmp81_ = NULL;
		GtkButton* export_button = NULL;
		const gchar* _tmp82_ = NULL;
		GtkButton* _tmp83_ = NULL;
		GtkButton* _tmp84_ = NULL;
		GtkTable* _tmp85_ = NULL;
		GtkLabel* _tmp86_ = NULL;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		GtkAttachOptions _tmp89_ = 0;
		GtkAttachOptions _tmp90_ = 0;
		GtkTable* _tmp91_ = NULL;
		GtkButton* _tmp92_ = NULL;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		GtkAttachOptions _tmp95_ = 0;
		GtkAttachOptions _tmp96_ = 0;
		gint _tmp97_ = 0;
		IdCard* _tmp98_ = NULL;
		TrustAnchor* _tmp99_ = NULL;
		TrustAnchor* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		const gchar* _tmp102_ = NULL;
		IdCard* _tmp121_ = NULL;
		TrustAnchor* _tmp122_ = NULL;
		TrustAnchor* _tmp123_ = NULL;
		const gchar* _tmp124_ = NULL;
		const gchar* _tmp125_ = NULL;
		GtkLabel* expiration_label = NULL;
		const gchar* _tmp144_ = NULL;
		IdCard* _tmp145_ = NULL;
		TrustAnchor* _tmp146_ = NULL;
		TrustAnchor* _tmp147_ = NULL;
		gchar* _tmp148_ = NULL;
		gchar* _tmp149_ = NULL;
		gchar* _tmp150_ = NULL;
		gchar* _tmp151_ = NULL;
		GtkLabel* _tmp152_ = NULL;
		GtkLabel* _tmp153_ = NULL;
		GtkLabel* _tmp154_ = NULL;
		GtkTable* _tmp155_ = NULL;
		GtkLabel* _tmp156_ = NULL;
		gint _tmp157_ = 0;
		gint _tmp158_ = 0;
		GtkAttachOptions _tmp159_ = 0;
		GtkAttachOptions _tmp160_ = 0;
		gint _tmp161_ = 0;
		GtkLabel* constraint_label = NULL;
		const gchar* _tmp162_ = NULL;
		GtkLabel* _tmp163_ = NULL;
		GtkLabel* _tmp164_ = NULL;
		GtkTable* _tmp165_ = NULL;
		GtkLabel* _tmp166_ = NULL;
		gint _tmp167_ = 0;
		gint _tmp168_ = 0;
		GtkAttachOptions _tmp169_ = 0;
		GtkAttachOptions _tmp170_ = 0;
		gint _tmp171_ = 0;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp79_ = _ ("CA Certificate:");
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp80_ = (GtkLabel*) gtk_label_new (_tmp79_);
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_object_ref_sink (_tmp80_);
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		ca_cert_label = _tmp80_;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp81_ = ca_cert_label;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_misc_set_alignment ((GtkMisc*) _tmp81_, (gfloat) 0, 0.5f);
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp82_ = _ ("Export Certificate");
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp83_ = (GtkButton*) gtk_button_new_with_label (_tmp82_);
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_object_ref_sink (_tmp83_);
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		export_button = _tmp83_;
#line 296 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp84_ = export_button;
#line 296 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_signal_connect_data (_tmp84_, "clicked", (GCallback) ____lambda9__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp85_ = _data4_->ta_table;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp86_ = ca_cert_label;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp87_ = row;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp88_ = row;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp89_ = _data4_->fill_and_expand;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp90_ = _data4_->fill_and_expand;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_table_attach (_tmp85_, (GtkWidget*) _tmp86_, (guint) 0, (guint) 1, (guint) _tmp87_, (guint) (_tmp88_ + 1), _tmp89_, _tmp90_, (guint) 20, (guint) 0);
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp91_ = _data4_->ta_table;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp92_ = export_button;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp93_ = row;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp94_ = row;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp95_ = fill;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp96_ = fill;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_table_attach (_tmp91_, (GtkWidget*) _tmp92_, (guint) 1, (guint) 2, (guint) _tmp93_, (guint) (_tmp94_ + 1), _tmp95_, _tmp96_, (guint) 0, (guint) 0);
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp97_ = row;
#line 300 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		row = _tmp97_ + 1;
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp98_ = _data4_->id;
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp99_ = id_card_get_trust_anchor (_tmp98_);
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp100_ = _tmp99_;
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp101_ = trust_anchor_get_subject (_tmp100_);
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp102_ = _tmp101_;
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		if (g_strcmp0 (_tmp102_, "") != 0) {
#line 1696 "moonshot-identity-dialog.c"
			GtkLabel* subject_label = NULL;
			const gchar* _tmp103_ = NULL;
			IdCard* _tmp104_ = NULL;
			TrustAnchor* _tmp105_ = NULL;
			TrustAnchor* _tmp106_ = NULL;
			const gchar* _tmp107_ = NULL;
			const gchar* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_ = NULL;
			GtkLabel* _tmp111_ = NULL;
			GtkLabel* _tmp112_ = NULL;
			GtkLabel* _tmp113_ = NULL;
			GtkTable* _tmp114_ = NULL;
			GtkLabel* _tmp115_ = NULL;
			gint _tmp116_ = 0;
			gint _tmp117_ = 0;
			GtkAttachOptions _tmp118_ = 0;
			GtkAttachOptions _tmp119_ = 0;
			gint _tmp120_ = 0;
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp103_ = _ ("Subject: ");
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp104_ = _data4_->id;
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp105_ = id_card_get_trust_anchor (_tmp104_);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp106_ = _tmp105_;
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp107_ = trust_anchor_get_subject (_tmp106_);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp108_ = _tmp107_;
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp109_ = g_strconcat (_tmp103_, _tmp108_, NULL);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp110_ = _tmp109_;
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp111_ = (GtkLabel*) gtk_label_new (_tmp110_);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_object_ref_sink (_tmp111_);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp112_ = _tmp111_;
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (_tmp110_);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			subject_label = _tmp112_;
#line 304 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp113_ = subject_label;
#line 304 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_misc_set_alignment ((GtkMisc*) _tmp113_, (gfloat) 0, 0.5f);
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp114_ = _data4_->ta_table;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp115_ = subject_label;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp116_ = row;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp117_ = row;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp118_ = _data4_->fill_and_expand;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp119_ = _data4_->fill_and_expand;
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_table_attach (_tmp114_, (GtkWidget*) _tmp115_, (guint) 0, (guint) 1, (guint) _tmp116_, (guint) (_tmp117_ + 1), _tmp118_, _tmp119_, (guint) 40, (guint) 5);
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp120_ = row;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			row = _tmp120_ + 1;
#line 302 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (subject_label);
#line 1766 "moonshot-identity-dialog.c"
		}
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp121_ = _data4_->id;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp122_ = id_card_get_trust_anchor (_tmp121_);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp123_ = _tmp122_;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp124_ = trust_anchor_get_subject_alt (_tmp123_);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp125_ = _tmp124_;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		if (g_strcmp0 (_tmp125_, "") != 0) {
#line 1780 "moonshot-identity-dialog.c"
			GtkLabel* subject_alt_label = NULL;
			const gchar* _tmp126_ = NULL;
			IdCard* _tmp127_ = NULL;
			TrustAnchor* _tmp128_ = NULL;
			TrustAnchor* _tmp129_ = NULL;
			const gchar* _tmp130_ = NULL;
			const gchar* _tmp131_ = NULL;
			gchar* _tmp132_ = NULL;
			gchar* _tmp133_ = NULL;
			GtkLabel* _tmp134_ = NULL;
			GtkLabel* _tmp135_ = NULL;
			GtkLabel* _tmp136_ = NULL;
			GtkTable* _tmp137_ = NULL;
			GtkLabel* _tmp138_ = NULL;
			gint _tmp139_ = 0;
			gint _tmp140_ = 0;
			GtkAttachOptions _tmp141_ = 0;
			GtkAttachOptions _tmp142_ = 0;
			gint _tmp143_ = 0;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp126_ = _ ("Subject-Alt: ");
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp127_ = _data4_->id;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp128_ = id_card_get_trust_anchor (_tmp127_);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp129_ = _tmp128_;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp130_ = trust_anchor_get_subject_alt (_tmp129_);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp131_ = _tmp130_;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp132_ = g_strconcat (_tmp126_, _tmp131_, NULL);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp133_ = _tmp132_;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp134_ = (GtkLabel*) gtk_label_new (_tmp133_);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_object_ref_sink (_tmp134_);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp135_ = _tmp134_;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (_tmp133_);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			subject_alt_label = _tmp135_;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp136_ = subject_alt_label;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_misc_set_alignment ((GtkMisc*) _tmp136_, (gfloat) 0, 0.5f);
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp137_ = _data4_->ta_table;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp138_ = subject_alt_label;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp139_ = row;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp140_ = row;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp141_ = _data4_->fill_and_expand;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp142_ = _data4_->fill_and_expand;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_table_attach (_tmp137_, (GtkWidget*) _tmp138_, (guint) 0, (guint) 1, (guint) _tmp139_, (guint) (_tmp140_ + 1), _tmp141_, _tmp142_, (guint) 40, (guint) 5);
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp143_ = row;
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			row = _tmp143_ + 1;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (subject_alt_label);
#line 1850 "moonshot-identity-dialog.c"
		}
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp144_ = _ ("Expiration date: ");
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp145_ = _data4_->id;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp146_ = id_card_get_trust_anchor (_tmp145_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp147_ = _tmp146_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp148_ = trust_anchor_get_expiration_date (_tmp147_, NULL);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp149_ = _tmp148_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp150_ = g_strconcat (_tmp144_, _tmp149_, NULL);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp151_ = _tmp150_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp152_ = (GtkLabel*) gtk_label_new (_tmp151_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_object_ref_sink (_tmp152_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp153_ = _tmp152_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_tmp151_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_tmp149_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		expiration_label = _tmp153_;
#line 317 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp154_ = expiration_label;
#line 317 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_misc_set_alignment ((GtkMisc*) _tmp154_, (gfloat) 0, 0.5f);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp155_ = _data4_->ta_table;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp156_ = expiration_label;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp157_ = row;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp158_ = row;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp159_ = _data4_->fill_and_expand;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp160_ = _data4_->fill_and_expand;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_table_attach (_tmp155_, (GtkWidget*) _tmp156_, (guint) 0, (guint) 1, (guint) _tmp157_, (guint) (_tmp158_ + 1), _tmp159_, _tmp160_, (guint) 40, (guint) 5);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp161_ = row;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		row = _tmp161_ + 1;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp162_ = _ ("Constraint: ");
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp163_ = (GtkLabel*) gtk_label_new (_tmp162_);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_object_ref_sink (_tmp163_);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		constraint_label = _tmp163_;
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp164_ = constraint_label;
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_misc_set_alignment ((GtkMisc*) _tmp164_, (gfloat) 0, 0.5f);
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp165_ = _data4_->ta_table;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp166_ = constraint_label;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp167_ = row;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp168_ = row;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp169_ = _data4_->fill_and_expand;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp170_ = _data4_->fill_and_expand;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_table_attach (_tmp165_, (GtkWidget*) _tmp166_, (guint) 0, (guint) 1, (guint) _tmp167_, (guint) (_tmp168_ + 1), _tmp169_, _tmp170_, (guint) 20, (guint) 0);
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp171_ = row;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		row = _tmp171_ + 1;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (constraint_label);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (expiration_label);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (export_button);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (ca_cert_label);
#line 1940 "moonshot-identity-dialog.c"
	}
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp172_ = trust_anchor_box;
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp173_ = _data4_->ta_table;
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp172_, (GtkWidget*) _tmp173_, FALSE, FALSE, (guint) 0);
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = (GtkWidget*) trust_anchor_box;
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (added_label);
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (ta_clear_button);
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	block4_data_unref (_data4_);
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data4_ = NULL;
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 1960 "moonshot-identity-dialog.c"
}


static void identity_dialog_add_as_vbox (GtkBox* content_area, GtkLabel* label, GtkEntry* entry) {
	GtkVBox* vbox = NULL;
	GtkVBox* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkHBox* hbox = NULL;
	GtkHBox* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (content_area != NULL);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (label != NULL);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (entry != NULL);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 2);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	vbox = _tmp0_;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = label;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _tmp1_, FALSE, FALSE, (guint) 0);
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = entry;
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp3_);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	hbox = _tmp3_;
#line 341 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
#line 342 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = content_area;
#line 342 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start (_tmp4_, (GtkWidget*) hbox, FALSE, FALSE, (guint) 6);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (hbox);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (vbox);
#line 2008 "moonshot-identity-dialog.c"
}


static gchar* identity_dialog_update_preamble (const gchar* preamble) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 345 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (preamble != NULL, NULL);
#line 347 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = preamble;
#line 347 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (g_strcmp0 (_tmp0_, "") == 0) {
#line 2023 "moonshot-identity-dialog.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp1_ = _ ("Missing required field: ");
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		result = _tmp2_;
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		return result;
#line 2034 "moonshot-identity-dialog.c"
	}
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = _ ("Missing required fields: ");
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = _tmp4_;
#line 349 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 2044 "moonshot-identity-dialog.c"
}


static gchar* identity_dialog_update_message (const gchar* old_message, const gchar* new_item) {
	gchar* result = NULL;
	gchar* message = NULL;
	const gchar* _tmp0_ = NULL;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (old_message != NULL, NULL);
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (new_item != NULL, NULL);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = old_message;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (g_strcmp0 (_tmp0_, "") == 0) {
#line 2060 "moonshot-identity-dialog.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp1_ = new_item;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (message);
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		message = _tmp2_;
#line 2071 "moonshot-identity-dialog.c"
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp3_ = old_message;
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp4_ = g_strconcat (_tmp3_, ", ", NULL);
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp5_ = _tmp4_;
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp6_ = new_item;
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (message);
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		message = _tmp7_;
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_tmp5_);
#line 2094 "moonshot-identity-dialog.c"
	}
#line 359 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = message;
#line 359 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 2100 "moonshot-identity-dialog.c"
}


static void identity_dialog_check_field (const gchar* field, GtkLabel* label, const gchar* fieldname, gchar** preamble, gchar** message) {
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 362 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (field != NULL);
#line 362 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (label != NULL);
#line 362 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (fieldname != NULL);
#line 362 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (*preamble != NULL);
#line 362 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (*message != NULL);
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = field;
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 2130 "moonshot-identity-dialog.c"
		GtkLabel* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp1_ = label;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp2_ = fieldname;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp3_ = string_to_string (_tmp2_);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp4_ = g_strconcat (_tmp3_, ":", NULL);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp5_ = _tmp4_;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_label_set_markup (_tmp1_, _tmp5_);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_tmp5_);
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		return;
#line 2152 "moonshot-identity-dialog.c"
	}
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp6_ = label;
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = fieldname;
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = string_to_string (_tmp7_);
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = g_strconcat ("<span foreground=\"red\">", _tmp8_, ":</span>", NULL);
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = _tmp9_;
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_label_set_markup (_tmp6_, _tmp10_);
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp10_);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = *preamble;
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp12_ = identity_dialog_update_preamble (_tmp11_);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (*preamble);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	*preamble = _tmp12_;
#line 370 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp13_ = *message;
#line 370 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = fieldname;
#line 370 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp15_ = identity_dialog_update_message (_tmp13_, _tmp14_);
#line 370 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (*message);
#line 370 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	*message = _tmp15_;
#line 2186 "moonshot-identity-dialog.c"
}


static gboolean identity_dialog_check_fields (IdentityDialog* self) {
	gboolean result = FALSE;
	gchar* preamble = NULL;
	gchar* _tmp0_ = NULL;
	gchar* message = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar* password_test = NULL;
	gchar* _tmp7_ = NULL;
	IdCard* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp21_ = NULL;
#line 373 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 375 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = g_strdup ("");
#line 375 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	preamble = _tmp0_;
#line 376 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = g_strdup ("");
#line 376 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	message = _tmp1_;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = identity_dialog_get_store_password (self);
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = _tmp3_;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp4_) {
#line 2220 "moonshot-identity-dialog.c"
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp5_ = identity_dialog_get_password (self);
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp6_ = _tmp5_;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp2_ = _tmp6_;
#line 2229 "moonshot-identity-dialog.c"
	} else {
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp2_ = "not required";
#line 2233 "moonshot-identity-dialog.c"
	}
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = g_strdup (_tmp2_);
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	password_test = _tmp7_;
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = self->priv->card;
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = id_card_is_no_identity (_tmp8_);
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (!_tmp9_) {
#line 2245 "moonshot-identity-dialog.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GtkLabel* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GtkLabel* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GtkLabel* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GtkLabel* _tmp20_ = NULL;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp10_ = identity_dialog_get_display_name (self);
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp11_ = _tmp10_;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp12_ = self->priv->displayname_label;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		identity_dialog_check_field (_tmp11_, _tmp12_, IDENTITY_DIALOG_displayname_labeltext, &preamble, &message);
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp13_ = identity_dialog_get_username (self);
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp14_ = _tmp13_;
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp15_ = self->priv->username_label;
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		identity_dialog_check_field (_tmp14_, _tmp15_, IDENTITY_DIALOG_username_labeltext, &preamble, &message);
#line 382 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp16_ = identity_dialog_get_issuer (self);
#line 382 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp17_ = _tmp16_;
#line 382 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp18_ = self->priv->realm_label;
#line 382 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		identity_dialog_check_field (_tmp17_, _tmp18_, IDENTITY_DIALOG_realm_labeltext, &preamble, &message);
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp19_ = password_test;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp20_ = self->priv->password_label;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		identity_dialog_check_field (_tmp19_, _tmp20_, IDENTITY_DIALOG_password_labeltext, &preamble, &message);
#line 2287 "moonshot-identity-dialog.c"
	}
#line 385 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp21_ = message;
#line 385 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (g_strcmp0 (_tmp21_, "") != 0) {
#line 2293 "moonshot-identity-dialog.c"
		GtkLabel* _tmp22_ = NULL;
		GtkLabel* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp22_ = self->priv->message_label;
#line 386 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp22_, TRUE);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp23_ = self->priv->message_label;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp24_ = preamble;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp25_ = string_to_string (_tmp24_);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp26_ = message;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp27_ = string_to_string (_tmp26_);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp28_ = g_strconcat ("<span foreground=\"red\">", _tmp25_, _tmp27_, "</span>", NULL);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp29_ = _tmp28_;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_label_set_markup (_tmp23_, _tmp29_);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (_tmp29_);
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		result = FALSE;
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (password_test);
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (message);
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (preamble);
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		return result;
#line 2334 "moonshot-identity-dialog.c"
	}
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = TRUE;
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (password_test);
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (message);
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (preamble);
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 2346 "moonshot-identity-dialog.c"
}


static void identity_dialog_on_response (IdentityDialog* self, GtkDialog* source, gint response_id) {
	gint _tmp0_ = 0;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (self != NULL);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (source != NULL);
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = response_id;
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	switch (_tmp0_) {
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		case GTK_RESPONSE_OK:
#line 2362 "moonshot-identity-dialog.c"
		{
			gboolean _tmp1_ = FALSE;
#line 397 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp1_ = identity_dialog_check_fields (self);
#line 397 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			self->complete = _tmp1_;
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			break;
#line 2371 "moonshot-identity-dialog.c"
		}
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		case GTK_RESPONSE_CANCEL:
#line 2375 "moonshot-identity-dialog.c"
		{
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			self->complete = TRUE;
#line 401 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			break;
#line 2381 "moonshot-identity-dialog.c"
		}
		default:
#line 395 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		break;
#line 2386 "moonshot-identity-dialog.c"
	}
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return _data5_;
#line 2396 "moonshot-identity-dialog.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 2405 "moonshot-identity-dialog.c"
		IdentityDialog* self;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		self = _data5_->self;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_data5_->services_table);
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_data5_->remove_button);
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (self);
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_slice_free (Block5Data, _data5_);
#line 2417 "moonshot-identity-dialog.c"
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return _data6_;
#line 2427 "moonshot-identity-dialog.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 2436 "moonshot-identity-dialog.c"
		IdentityDialog* self;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		self = _data6_->_data5_->self;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_data6_->label);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		block5_data_unref (_data6_->_data5_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_data6_->_data5_ = NULL;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_slice_free (Block6Data, _data6_);
#line 2448 "moonshot-identity-dialog.c"
	}
}


static gboolean ____lambda10_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	IdentityDialog* self;
	gboolean result = FALSE;
	GtkStateType state = 0;
	GtkLabel* _tmp0_ = NULL;
	GtkStateType _tmp1_ = 0;
	MoonshotLogger* _tmp2_ = NULL;
	GtkStateType _tmp3_ = 0;
	GEnumValue* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data5_ = _data6_->_data5_;
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self = _data5_->self;
#line 463 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = _data6_->label;
#line 463 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = gtk_widget_get_state ((GtkWidget*) _tmp0_);
#line 463 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	state = _tmp1_;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = identity_dialog_logger;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = state;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = g_enum_get_value (g_type_class_ref (GTK_TYPE_STATE_TYPE), _tmp3_);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp5_ = g_strconcat ("button_press_callback: Label state=", (_tmp4_ != NULL) ? _tmp4_->value_name : NULL, NULL);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp6_ = _tmp5_;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = g_strconcat (_tmp6_, " setting bg to ", NULL);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = _tmp7_;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = gdk_color_to_string (&identity_dialog_white);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = _tmp9_;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp12_ = _tmp11_;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	moonshot_logger_trace (_tmp2_, _tmp12_, NULL);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp12_);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp10_);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp8_);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp6_);
#line 466 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp13_ = self->priv->selected_item;
#line 466 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = _data6_->label;
#line 466 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp13_ == _tmp14_) {
#line 2521 "moonshot-identity-dialog.c"
		GtkLabel* _tmp15_ = NULL;
		GtkContainer* _tmp16_ = NULL;
		GtkContainer* _tmp17_ = NULL;
		GtkStateType _tmp18_ = 0;
		GdkColor _tmp19_ = {0};
		GtkButton* _tmp20_ = NULL;
#line 469 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp15_ = self->priv->selected_item;
#line 469 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp16_ = gtk_widget_get_parent ((GtkWidget*) _tmp15_);
#line 469 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp17_ = _tmp16_;
#line 469 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp18_ = state;
#line 469 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp19_ = identity_dialog_white;
#line 469 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_modify_bg ((GtkWidget*) _tmp17_, _tmp18_, &_tmp19_);
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (self->priv->selected_item);
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		self->priv->selected_item = NULL;
#line 471 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp20_ = _data5_->remove_button;
#line 471 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, FALSE);
#line 2548 "moonshot-identity-dialog.c"
	} else {
		GtkLabel* _tmp21_ = NULL;
		GtkLabel* _tmp27_ = NULL;
		GtkLabel* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		GtkContainer* _tmp30_ = NULL;
		GtkContainer* _tmp31_ = NULL;
		GtkStateType _tmp32_ = 0;
		GdkColor _tmp33_ = {0};
		GtkButton* _tmp34_ = NULL;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp21_ = self->priv->selected_item;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		if (_tmp21_ != NULL) {
#line 2563 "moonshot-identity-dialog.c"
			GtkLabel* _tmp22_ = NULL;
			GtkContainer* _tmp23_ = NULL;
			GtkContainer* _tmp24_ = NULL;
			GtkStateType _tmp25_ = 0;
			GdkColor _tmp26_ = {0};
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp22_ = self->priv->selected_item;
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp23_ = gtk_widget_get_parent ((GtkWidget*) _tmp22_);
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp24_ = _tmp23_;
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp25_ = state;
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp26_ = identity_dialog_white;
#line 478 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_widget_modify_bg ((GtkWidget*) _tmp24_, _tmp25_, &_tmp26_);
#line 479 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (self->priv->selected_item);
#line 479 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			self->priv->selected_item = NULL;
#line 2585 "moonshot-identity-dialog.c"
		}
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp27_ = _data6_->label;
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (self->priv->selected_item);
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		self->priv->selected_item = _tmp28_;
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp29_ = self->priv->selected_item;
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp30_ = gtk_widget_get_parent ((GtkWidget*) _tmp29_);
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp31_ = _tmp30_;
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp32_ = state;
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp33_ = identity_dialog_selected_color;
#line 484 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_modify_bg ((GtkWidget*) _tmp31_, _tmp32_, &_tmp33_);
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp34_ = _data5_->remove_button;
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp34_, TRUE);
#line 2611 "moonshot-identity-dialog.c"
	}
#line 487 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = FALSE;
#line 487 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 2617 "moonshot-identity-dialog.c"
}


static gboolean _____lambda10__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ____lambda10_ (self);
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 2626 "moonshot-identity-dialog.c"
}


static void __lambda11_ (Block5Data* _data5_, GtkButton* remove_button) {
	IdentityDialog* self;
	gboolean _result_ = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
#line 494 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self = _data5_->self;
#line 494 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (remove_button != NULL);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = _ ("You are about to remove the service\n'%s'.");
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = g_strconcat ("<span font-weight='heavy'>", _tmp0_, NULL);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = _tmp1_;
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = g_strconcat (_tmp2_, "</span>", NULL);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = _tmp3_;
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp5_ = self->priv->selected_item;
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp6_ = gtk_label_get_label (_tmp5_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = _tmp6_;
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = g_markup_printf_escaped (_tmp4_, _tmp7_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = _tmp8_;
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = _ ("\n\nAre you sure you want to do this?");
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp12_ = _tmp11_;
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp13_ = warning_dialog_confirm ((GtkWindow*) self, _tmp12_, "delete_service");
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = _tmp13_;
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp12_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp9_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp4_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp2_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_result_ = _tmp14_;
#line 505 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp15_ = _result_;
#line 505 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp15_) {
#line 2697 "moonshot-identity-dialog.c"
		IdCard* _tmp16_ = NULL;
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp16_ = self->priv->card;
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		if (_tmp16_ != NULL) {
#line 2703 "moonshot-identity-dialog.c"
			GeeArrayList* _tmp17_ = NULL;
			GtkLabel* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GtkTable* _tmp21_ = NULL;
			GtkLabel* _tmp22_ = NULL;
			GtkContainer* _tmp23_ = NULL;
			GtkContainer* _tmp24_ = NULL;
			GtkButton* _tmp25_ = NULL;
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp17_ = self->priv->services;
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp18_ = self->priv->selected_item;
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp19_ = gtk_label_get_label (_tmp18_);
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp20_ = _tmp19_;
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp17_, _tmp20_);
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp21_ = _data5_->services_table;
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp22_ = self->priv->selected_item;
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp23_ = gtk_widget_get_parent ((GtkWidget*) _tmp22_);
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp24_ = _tmp23_;
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_container_remove ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp24_);
#line 510 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (self->priv->selected_item);
#line 510 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			self->priv->selected_item = NULL;
#line 511 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp25_ = remove_button;
#line 511 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, FALSE);
#line 2741 "moonshot-identity-dialog.c"
		}
	}
}


static void ___lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 494 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	__lambda11_ (self, _sender);
#line 2750 "moonshot-identity-dialog.c"
}


static GtkVBox* identity_dialog_make_services_vbox (IdentityDialog* self) {
	GtkVBox* result = NULL;
	Block5Data* _data5_;
	MoonshotLogger* _tmp0_ = NULL;
	GtkAlignment* services_vbox_alignment = NULL;
	GtkAlignment* _tmp1_ = NULL;
	GtkScrolledWindow* services_vscroll = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkScrolledWindow* _tmp3_ = NULL;
	GtkScrolledWindow* _tmp4_ = NULL;
	GtkScrolledWindow* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GtkAlignment* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GtkTable* _tmp15_ = NULL;
	GtkTable* _tmp16_ = NULL;
	GtkTable* _tmp17_ = NULL;
	GtkTable* _tmp18_ = NULL;
	GtkHBox* table_button_hbox = NULL;
	GtkHBox* _tmp19_ = NULL;
	GtkHBox* _tmp20_ = NULL;
	GtkScrolledWindow* _tmp21_ = NULL;
	GtkVBox* fixed_height = NULL;
	GtkVBox* _tmp22_ = NULL;
	GtkVBox* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	GtkHBox* _tmp25_ = NULL;
	GtkVBox* _tmp26_ = NULL;
	GtkEventBox* table_bg = NULL;
	GtkEventBox* _tmp27_ = NULL;
	GtkEventBox* _tmp28_ = NULL;
	GtkEventBox* _tmp29_ = NULL;
	GtkTable* _tmp30_ = NULL;
	GtkAlignment* _tmp31_ = NULL;
	GtkEventBox* _tmp32_ = NULL;
	GtkLabel* services_vbox_title = NULL;
	const gchar* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkVBox* services_vbox = NULL;
	GtkVBox* _tmp36_ = NULL;
	GtkVBox* _tmp37_ = NULL;
	GtkLabel* _tmp38_ = NULL;
	GtkVBox* _tmp39_ = NULL;
	GtkHBox* _tmp40_ = NULL;
	gint i = 0;
	GtkButton* _tmp67_ = NULL;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data5_->_ref_count_ = 1;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data5_->self = g_object_ref (self);
#line 407 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = identity_dialog_logger;
#line 407 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	moonshot_logger_trace (_tmp0_, "make_services_vbox", NULL);
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, (gfloat) 0, (gfloat) 1, (gfloat) 0);
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp1_);
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	services_vbox_alignment = _tmp1_;
#line 410 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 410 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp2_);
#line 410 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	services_vscroll = _tmp2_;
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = services_vscroll;
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_scrolled_window_set_policy (_tmp3_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
#line 412 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = services_vscroll;
#line 412 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_scrolled_window_set_shadow_type (_tmp4_, GTK_SHADOW_IN);
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp5_ = services_vscroll;
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 0, 60);
#line 414 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp6_ = services_vscroll;
#line 414 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = services_vbox_alignment;
#line 414 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_scrolled_window_add_with_viewport (_tmp6_, (GtkWidget*) _tmp7_);
#line 417 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_REMOVE);
#line 417 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp8_);
#line 417 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data5_->remove_button = _tmp8_;
#line 421 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = _data5_->remove_button;
#line 421 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = self->priv->card;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = id_card_get_services (_tmp10_);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp12_ = _tmp11_;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = _tmp13_;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp15_ = (GtkTable*) gtk_table_new ((guint) _tmp14_, (guint) 1, FALSE);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp15_);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data5_->services_table = _tmp15_;
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp16_ = _data5_->services_table;
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_table_set_row_spacings (_tmp16_, (guint) 1);
#line 426 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp17_ = _data5_->services_table;
#line 426 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_table_set_col_spacings (_tmp17_, (guint) 0);
#line 427 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp18_ = _data5_->services_table;
#line 427 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	set_bg_color ((GtkWidget*) _tmp18_);
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp19_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp19_);
#line 429 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	table_button_hbox = _tmp19_;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp20_ = table_button_hbox;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp21_ = services_vscroll;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp20_, (GtkWidget*) _tmp21_, TRUE, TRUE, (guint) 4);
#line 433 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp22_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 433 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp22_);
#line 433 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	fixed_height = _tmp22_;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp23_ = fixed_height;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp24_ = _data5_->remove_button;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp23_, (GtkWidget*) _tmp24_, FALSE, FALSE, (guint) 0);
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp25_ = table_button_hbox;
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp26_ = fixed_height;
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp25_, (GtkWidget*) _tmp26_, FALSE, FALSE, (guint) 0);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp27_ = (GtkEventBox*) gtk_event_box_new ();
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp27_);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	table_bg = _tmp27_;
#line 440 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp28_ = table_bg;
#line 440 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	set_bg_color ((GtkWidget*) _tmp28_);
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp29_ = table_bg;
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp30_ = _data5_->services_table;
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp31_ = services_vbox_alignment;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp32_ = table_bg;
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp33_ = _ ("Services:");
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp34_);
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	services_vbox_title = _tmp34_;
#line 445 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp35_ = services_vbox_title;
#line 445 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp35_, (gfloat) 0, 0.5f);
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp36_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp36_);
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	services_vbox = _tmp36_;
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp37_ = services_vbox;
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp38_ = services_vbox_title;
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp37_, (GtkWidget*) _tmp38_, FALSE, FALSE, (guint) 0);
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp39_ = services_vbox;
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp40_ = table_button_hbox;
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_box_pack_start ((GtkBox*) _tmp39_, (GtkWidget*) _tmp40_, TRUE, TRUE, (guint) 0);
#line 451 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	i = 0;
#line 2971 "moonshot-identity-dialog.c"
	{
		GeeArrayList* _service_list = NULL;
		GeeArrayList* _tmp41_ = NULL;
		GeeArrayList* _tmp42_ = NULL;
		gint _service_size = 0;
		GeeArrayList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		gint _service_index = 0;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp41_ = self->priv->services;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp42_ = _g_object_ref0 (_tmp41_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_service_list = _tmp42_;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp43_ = _service_list;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp45_ = _tmp44_;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_service_size = _tmp45_;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_service_index = -1;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		while (TRUE) {
#line 2999 "moonshot-identity-dialog.c"
			Block6Data* _data6_;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			gchar* service = NULL;
			GeeArrayList* _tmp49_ = NULL;
			gint _tmp50_ = 0;
			gpointer _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			GtkLabel* _tmp53_ = NULL;
			GtkLabel* _tmp54_ = NULL;
			GtkLabel* _tmp55_ = NULL;
			GtkEventBox* event_box = NULL;
			GtkEventBox* _tmp56_ = NULL;
			GtkEventBox* _tmp57_ = NULL;
			GdkColor _tmp58_ = {0};
			GtkEventBox* _tmp59_ = NULL;
			GtkLabel* _tmp60_ = NULL;
			GtkEventBox* _tmp61_ = NULL;
			GtkTable* _tmp62_ = NULL;
			GtkEventBox* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_data6_ = g_slice_new0 (Block6Data);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_data6_->_ref_count_ = 1;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_data6_->_data5_ = block5_data_ref (_data5_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp46_ = _service_index;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_service_index = _tmp46_ + 1;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp47_ = _service_index;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp48_ = _service_size;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			if (!(_tmp47_ < _tmp48_)) {
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
				block6_data_unref (_data6_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
				_data6_ = NULL;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
				break;
#line 3046 "moonshot-identity-dialog.c"
			}
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp49_ = _service_list;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp50_ = _service_index;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _tmp50_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			service = (gchar*) _tmp51_;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp52_ = service;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp53_ = (GtkLabel*) gtk_label_new (_tmp52_);
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_object_ref_sink (_tmp53_);
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_data6_->label = _tmp53_;
#line 455 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp54_ = _data6_->label;
#line 455 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_misc_set_alignment ((GtkMisc*) _tmp54_, (gfloat) 0, (gfloat) 0);
#line 456 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp55_ = _data6_->label;
#line 456 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_object_set ((GtkMisc*) _tmp55_, "xpad", 3, NULL);
#line 458 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp56_ = (GtkEventBox*) gtk_event_box_new ();
#line 458 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_object_ref_sink (_tmp56_);
#line 458 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			event_box = _tmp56_;
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp57_ = event_box;
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp58_ = identity_dialog_white;
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_widget_modify_bg ((GtkWidget*) _tmp57_, GTK_STATE_NORMAL, &_tmp58_);
#line 460 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp59_ = event_box;
#line 460 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp60_ = _data6_->label;
#line 460 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp60_);
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp61_ = event_box;
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_signal_connect_data ((GtkWidget*) _tmp61_, "button-press-event", (GCallback) _____lambda10__gtk_widget_button_press_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp62_ = _data5_->services_table;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp63_ = event_box;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp64_ = i;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp65_ = i;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			gtk_table_attach_defaults (_tmp62_, (GtkWidget*) _tmp63_, (guint) 0, (guint) 1, (guint) _tmp64_, (guint) (_tmp65_ + 1));
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp66_ = i;
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			i = _tmp66_ + 1;
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (event_box);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (service);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			block6_data_unref (_data6_);
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_data6_ = NULL;
#line 3116 "moonshot-identity-dialog.c"
		}
#line 452 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_service_list);
#line 3120 "moonshot-identity-dialog.c"
	}
#line 494 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp67_ = _data5_->remove_button;
#line 494 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_signal_connect_data (_tmp67_, "clicked", (GCallback) ___lambda11__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = services_vbox;
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (services_vbox_title);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (table_bg);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (fixed_height);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (table_button_hbox);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (services_vscroll);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (services_vbox_alignment);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	block5_data_unref (_data5_);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_data5_ = NULL;
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 3146 "moonshot-identity-dialog.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1388 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1388 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1388 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 3159 "moonshot-identity-dialog.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3190 "moonshot-identity-dialog.c"
				goto __catch10_g_regex_error;
			}
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1390 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 3199 "moonshot-identity-dialog.c"
		}
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3215 "moonshot-identity-dialog.c"
				goto __catch10_g_regex_error;
			}
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 3226 "moonshot-identity-dialog.c"
		}
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1391 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 3240 "moonshot-identity-dialog.c"
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1393 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 3254 "moonshot-identity-dialog.c"
	}
	__finally10:
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1389 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 3265 "moonshot-identity-dialog.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 3299 "moonshot-identity-dialog.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 3308 "moonshot-identity-dialog.c"
	}
#line 1341 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1341 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 3314 "moonshot-identity-dialog.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1342 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1342 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1342 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 3323 "moonshot-identity-dialog.c"
	}
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 3329 "moonshot-identity-dialog.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 3338 "moonshot-identity-dialog.c"
	} else {
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 3342 "moonshot-identity-dialog.c"
	}
#line 1344 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 3350 "moonshot-identity-dialog.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 3359 "moonshot-identity-dialog.c"
	} else {
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 3363 "moonshot-identity-dialog.c"
	}
#line 1345 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1346 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1346 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1346 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1347 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 3385 "moonshot-identity-dialog.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 3429 "moonshot-identity-dialog.c"
	}
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 3435 "moonshot-identity-dialog.c"
}


static void identity_dialog_export_certificate (IdentityDialog* self, IdCard* id) {
	GtkFileChooserDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkFileChooserDialog* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* default_filename = NULL;
	IdCard* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GtkFileChooserDialog* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkFileChooserDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkFileChooserDialog* _tmp62_ = NULL;
	GError * _inner_error_ = NULL;
#line 520 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (self != NULL);
#line 520 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_if_fail (id != NULL);
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = _ ("Cancel");
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = _ ("Save");
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save File", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp0_, GTK_RESPONSE_CANCEL, _tmp1_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_ref_sink (_tmp2_);
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	dialog = _tmp2_;
#line 528 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp3_ = dialog;
#line 528 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp3_, TRUE);
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp4_ = export_directory;
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp4_ != NULL) {
#line 3482 "moonshot-identity-dialog.c"
		GtkFileChooserDialog* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 530 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp5_ = dialog;
#line 530 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp6_ = export_directory;
#line 530 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp5_, _tmp6_);
#line 3491 "moonshot-identity-dialog.c"
	}
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp7_ = id;
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp8_ = id_card_get_display_name (_tmp7_);
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp9_ = _tmp8_;
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp10_ = g_strconcat (_tmp9_, ".pem", NULL);
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp11_ = _tmp10_;
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp12_ = string_replace (_tmp11_, G_DIR_SEPARATOR_S, "_");
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp13_ = _tmp12_;
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (_tmp11_);
#line 533 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	default_filename = _tmp13_;
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp14_ = dialog;
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp15_ = default_filename;
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp14_, _tmp15_);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp16_ = dialog;
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp17_ = gtk_dialog_run ((GtkDialog*) _tmp16_);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	if (_tmp17_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 540 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		static const char CERT_HEADER[] = "-----BEGIN CERTIFICATE-----\n";
#line 541 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		static const char CERT_FOOTER[] = "\n-----END CERTIFICATE-----\n";
#line 3527 "moonshot-identity-dialog.c"
		gchar* cert = NULL;
		IdCard* _tmp18_ = NULL;
		TrustAnchor* _tmp19_ = NULL;
		TrustAnchor* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* newcert = NULL;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		const gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* filename = NULL;
		GtkFileChooserDialog* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp50_ = NULL;
		GFile* _tmp51_ = NULL;
		GFileOutputStream* stream = NULL;
		GFile* _tmp52_ = NULL;
		GFileOutputStream* _tmp53_ = NULL;
		GFileOutputStream* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		guint8* _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		guint8* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		GFile* _tmp58_ = NULL;
		GFile* _tmp59_ = NULL;
		GFile* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp18_ = id;
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp19_ = id_card_get_trust_anchor (_tmp18_);
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp20_ = _tmp19_;
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp21_ = trust_anchor_get_ca_cert (_tmp20_);
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp22_ = _tmp21_;
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp23_ = string_replace (_tmp22_, "\n", "");
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		cert = _tmp23_;
#line 547 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp24_ = g_strdup (CERT_HEADER);
#line 547 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		newcert = _tmp24_;
#line 548 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		while (TRUE) {
#line 3581 "moonshot-identity-dialog.c"
			const gchar* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gchar* _tmp39_ = NULL;
#line 548 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp25_ = cert;
#line 548 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp26_ = strlen (_tmp25_);
#line 548 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp27_ = _tmp26_;
#line 548 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			if (!(_tmp27_ > 63)) {
#line 548 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
				break;
#line 3607 "moonshot-identity-dialog.c"
			}
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp28_ = newcert;
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp29_ = cert;
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp30_ = string_slice (_tmp29_, (glong) 0, (glong) 64);
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp31_ = _tmp30_;
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp32_ = g_strconcat (_tmp28_, _tmp31_, NULL);
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (newcert);
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			newcert = _tmp32_;
#line 549 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (_tmp31_);
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp33_ = newcert;
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp34_ = g_strconcat (_tmp33_, "\n", NULL);
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (newcert);
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			newcert = _tmp34_;
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp35_ = cert;
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp36_ = cert;
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp37_ = strlen (_tmp36_);
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp38_ = _tmp37_;
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp39_ = string_slice (_tmp35_, (glong) 64, (glong) _tmp38_);
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (cert);
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			cert = _tmp39_;
#line 3647 "moonshot-identity-dialog.c"
		}
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp40_ = cert;
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp41_ = strlen (_tmp40_);
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp42_ = _tmp41_;
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		if (_tmp42_ > 0) {
#line 3657 "moonshot-identity-dialog.c"
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp43_ = newcert;
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp44_ = cert;
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (newcert);
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			newcert = _tmp45_;
#line 3671 "moonshot-identity-dialog.c"
		}
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp46_ = newcert;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp47_ = g_strconcat (_tmp46_, CERT_FOOTER, NULL);
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (newcert);
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		newcert = _tmp47_;
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp48_ = dialog;
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp49_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp48_);
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		filename = _tmp49_;
#line 559 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp50_ = filename;
#line 559 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp51_ = g_file_new_for_path (_tmp50_);
#line 559 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		file = _tmp51_;
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp52_ = file;
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp53_ = g_file_replace (_tmp52_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, &_inner_error_);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		stream = _tmp53_;
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (file);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (filename);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (newcert);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (cert);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (default_filename);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (dialog);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_clear_error (&_inner_error_);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			return;
#line 3719 "moonshot-identity-dialog.c"
		}
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp54_ = stream;
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp55_ = newcert;
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp56_ = string_get_data (_tmp55_, &_tmp56__length1);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp57_ = _tmp56_;
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp57__length1 = _tmp56__length1;
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_output_stream_write ((GOutputStream*) _tmp54_, _tmp57_, (gsize) _tmp57__length1, NULL, &_inner_error_);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (stream);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (file);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (filename);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (newcert);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (cert);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_free0 (default_filename);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			_g_object_unref0 (dialog);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			g_clear_error (&_inner_error_);
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
			return;
#line 3755 "moonshot-identity-dialog.c"
		}
#line 564 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp58_ = file;
#line 564 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp59_ = g_file_get_parent (_tmp58_);
#line 564 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp60_ = _tmp59_;
#line 564 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_tmp61_ = g_file_get_path (_tmp60_);
#line 564 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (export_directory);
#line 564 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		export_directory = _tmp61_;
#line 564 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (_tmp60_);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (stream);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_object_unref0 (file);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (filename);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (newcert);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		_g_free0 (cert);
#line 3781 "moonshot-identity-dialog.c"
	}
#line 566 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp62_ = dialog;
#line 566 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	gtk_object_destroy ((GtkObject*) _tmp62_);
#line 520 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_free0 (default_filename);
#line 520 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (dialog);
#line 3791 "moonshot-identity-dialog.c"
}


const gchar* identity_dialog_get_display_name (IdentityDialog* self) {
	const gchar* result;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = self->priv->displayname_entry;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = _tmp1_;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 3809 "moonshot-identity-dialog.c"
}


const gchar* identity_dialog_get_issuer (IdentityDialog* self) {
	const gchar* result;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = self->priv->realm_entry;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = _tmp1_;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 3827 "moonshot-identity-dialog.c"
}


const gchar* identity_dialog_get_username (IdentityDialog* self) {
	const gchar* result;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = self->priv->username_entry;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = _tmp1_;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 3845 "moonshot-identity-dialog.c"
}


const gchar* identity_dialog_get_password (IdentityDialog* self) {
	const gchar* result;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = self->priv->password_entry;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = _tmp1_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 3863 "moonshot-identity-dialog.c"
}


gboolean identity_dialog_get_store_password (IdentityDialog* self) {
	gboolean result;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp0_ = self->priv->remember_checkbutton;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = _tmp1_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	result = _tmp2_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	return result;
#line 3884 "moonshot-identity-dialog.c"
}


static void identity_dialog_class_init (IdentityDialogClass * klass) {
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_ = {0};
	MoonshotLogger* _tmp2_ = NULL;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_parent_class = g_type_class_peek_parent (klass);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_type_class_add_private (klass, sizeof (IdentityDialogPrivate));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_identity_dialog_get_property;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = identity_dialog_finalize;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), IDENTITY_DIALOG_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), IDENTITY_DIALOG_ISSUER, g_param_spec_string ("issuer", "issuer", "issuer", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), IDENTITY_DIALOG_USERNAME, g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), IDENTITY_DIALOG_PASSWORD, g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), IDENTITY_DIALOG_STORE_PASSWORD, g_param_spec_boolean ("store-password", "store-password", "store-password", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	make_color ((guint16) 65535, (guint16) 65535, (guint16) 65535, &_tmp0_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_white = _tmp0_;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	make_color ((guint16) (0xd9 << 8), (guint16) (0xf7 << 8), (guint16) 65535, &_tmp1_);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_selected_color = _tmp1_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_tmp2_ = get_logger ("IdentityDialog");
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	identity_dialog_logger = _tmp2_;
#line 3922 "moonshot-identity-dialog.c"
}


static void identity_dialog_instance_init (IdentityDialog * self) {
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv = IDENTITY_DIALOG_GET_PRIVATE (self);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->priv->selected_item = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self->clear_trust_anchor = FALSE;
#line 3933 "moonshot-identity-dialog.c"
}


static void identity_dialog_finalize (GObject* obj) {
	IdentityDialog * self;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDENTITY_DIALOG, IdentityDialog);
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->displayname_entry);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->displayname_label);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->realm_entry);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->realm_label);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->username_label);
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->password_label);
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->remember_checkbutton);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->message_label);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->card);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->services);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	_g_object_unref0 (self->priv->selected_item);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	G_OBJECT_CLASS (identity_dialog_parent_class)->finalize (obj);
#line 3969 "moonshot-identity-dialog.c"
}


GType identity_dialog_get_type (void) {
	static volatile gsize identity_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&identity_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdentityDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) identity_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdentityDialog), 0, (GInstanceInitFunc) identity_dialog_instance_init, NULL };
		GType identity_dialog_type_id;
		identity_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "IdentityDialog", &g_define_type_info, 0);
		g_once_init_leave (&identity_dialog_type_id__volatile, identity_dialog_type_id);
	}
	return identity_dialog_type_id__volatile;
}


static void _vala_identity_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IdentityDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IDENTITY_DIALOG, IdentityDialog);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
	switch (property_id) {
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		case IDENTITY_DIALOG_DISPLAY_NAME:
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_value_set_string (value, identity_dialog_get_display_name (self));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		break;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		case IDENTITY_DIALOG_ISSUER:
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_value_set_string (value, identity_dialog_get_issuer (self));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		break;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		case IDENTITY_DIALOG_USERNAME:
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_value_set_string (value, identity_dialog_get_username (self));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		break;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		case IDENTITY_DIALOG_PASSWORD:
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_value_set_string (value, identity_dialog_get_password (self));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		break;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		case IDENTITY_DIALOG_STORE_PASSWORD:
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		g_value_set_boolean (value, identity_dialog_get_store_password (self));
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		break;
#line 4020 "moonshot-identity-dialog.c"
		default:
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-dialog.vala"
		break;
#line 4026 "moonshot-identity-dialog.c"
	}
}



