// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using Internal.TypeSystem;

namespace Internal.IL.Stubs
{
    // Functionality related to deterministic ordering of types
    partial class EnumGetHashCodeThunk
    {
        protected internal override int ClassCode => 261739662;

        protected internal override int CompareToImpl(MethodDesc other, TypeSystemComparer comparer)
        {
            var otherMethod = (EnumGetHashCodeThunk)other;
            return comparer.Compare(_owningType, otherMethod._owningType);
        }
    }

    partial class EnumEqualsThunk
    {
        protected internal override int ClassCode => -1774524780;

        protected internal override int CompareToImpl(MethodDesc other, TypeSystemComparer comparer)
        {
            var otherMethod = (EnumEqualsThunk)other;
            return comparer.Compare(_owningType, otherMethod._owningType);
        }
    }
}
