; $Id: lnf.scm 2156 2008-01-25 13:25:12Z schimans $

; Tests for proceed

(set-goal (pf "T"))
(proceed "Truth-Axiom")

(set-goal (pf "F -> F"))
(proceed)

(add-predconst-name "A" "B" (make-arity))

(define mints (pf "((((A -> B) -> A) -> A) -> B) -> B"))
(set-goal mints)
(proceed)

; (set-goal (pf "(A -> A) -> A"))
; (lnf)
; (proceed)

(add-var-name "x" "y" "z" (py "alpha"))
(add-predconst-name "P" (make-arity))
(add-predconst-name "Qpredconst" (make-arity (py "alpha")))
(add-predconst-name "Rpredconst" (make-arity (py "alpha") (py "alpha")))

(add-token
 "Q"
 'predconst-name
 (string-and-arity-to-predconst-parse-function
  "Qpredconst" (make-arity (make-tvar -1 "alpha"))))

(add-token
 "R"
 'pred-infix
 (lambda (x y)
   ((string-and-arity-to-predconst-parse-function
     "Rpredconst" (make-arity (make-tvar -1 "alpha") (make-tvar -1 "alpha")))
    (- 1) x y)))

(add-predconst-display "Qpredconst" 'predconst-name "Q")
(add-predconst-display "Rpredconst" 'pred-infix "R")

(define all-imp (pf "(all x.Q1 x -> Q2 x) -> all x Q1 x -> all x Q2 x"))
(set-goal all-imp)
(proceed)
; (cdp (np (current-proof)))

(define all-and1 (pf "(all x.Q1 x & Q2 x) -> all x Q1 x & all x Q2 x"))
(set-goal all-and1)
(proceed)

(define all-and2 (pf " all x Q1 x & all x Q2 x -> all x.Q1 x & Q2 x"))
(set-goal all-and2)
(proceed)

(define all-exca  (pf "all x Q x -> (all x.Q x -> F) -> F"))
(set-goal all-exca)
(proceed)

(add-global-assumption "Symm" (pf "all x,y.x R y -> y R x"))
(add-global-assumption "Trans" (pf "all x,y,z.x R y -> y R z -> x R z"))

(set-goal (pf "all x,y.x R y -> x R x"))
; (proceed "Symm" "Trans") loops

(define qf1m (pf "(all x.((Q x -> F) -> F) -> Q x) 
               -> (all x Q x -> P) 
               -> (all x.(Q x -> P) -> F)
               -> F"))
(set-goal qf1m)
(proceed)

(define qf2 (pf "(P -> all y Q y) -> all y. P -> Q y"))
(set-goal qf2)
(proceed)

(define qf3 (pf "(((all x.Q x -> F) -> F) -> P) -> all x.Q x -> P"))
(set-goal qf3)
(proceed)

(define qf4m (pf "(all y.F -> Q y)
               -> (P -> (all y.Q y -> F) -> F)
               -> (all y.(P -> Q y) -> F) 
               -> F"))
(set-goal qf4m)
(proceed)
