/*
  mffm Time Code
  Time Code for multimedia systems

  Copyright (C) 2000, 2001 Matt R. Flax <flatmax@ieee.org>
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You have received a copy of the GNU Lesser General Public License
  along with this library.
*/
#ifndef XPMDIGITS_H_
#define XPMDIGITS_H_

#include <glib.h>

#define XXPM 30
#define YXPM 44
#define XPMCNT 16

#include "xpm/0.xpm"
#include "xpm/1.xpm"
#include "xpm/2.xpm"
#include "xpm/3.xpm"
#include "xpm/4.xpm"
#include "xpm/5.xpm"
#include "xpm/6.xpm"
#include "xpm/7.xpm"
#include "xpm/8.xpm"
#include "xpm/9.xpm"
#include "xpm/null.xpm"
#include "xpm/colon.xpm"
#include "xpm/start.xpm"
#include "xpm/stop.xpm"
#include "xpm/current.xpm"
#include "xpm/window.xpm"

//G_LOCK_DEFINE_STATIC (digitsGdk);
static GdkPixmap *digitsGdk[XPMCNT];
static GdkBitmap *digitsMasks[XPMCNT];

/** This class creates static GdkPixmaps digits
 */
class XPMDigits {
  //  gchar *baseDir;
public:
  //  XPMDigits(const char* baseDirectory, GtkInterface *gtkI){
    //baseDir=NULL;
    //baseDir=g_strdup(baseDirectory);
  //  XPMDigits(const char* baseDirectory, GtkInterface *gtkI){
  XPMDigits(GtkInterface *gtkI){
    init(gtkI);
  }

#define GDKPIXMAPCREATEWITHMASK(w, ref, m) gdk_pixmap_create_from_xpm_d(w->window,m,NULL,ref)
  void init(GtkInterface *gtkI){
    //G_LOCK(digitsGdk);
    //#define PIXMAP_CREATE(x) gdk_pixmap_create_from_xpm(gtkI->win->window,NULL,NULL,x);
    //#define PIXMAP_CREATE(x, i) gdk_pixmap_create_from_xpm_d(gtkI->win->window,&digitMasks[i],NULL,x);
    digitsGdk[0]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _0XPM, &digitsMasks[0]);
    digitsGdk[1]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _1XPM, &digitsMasks[1]);
    digitsGdk[2]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _2XPM, &digitsMasks[2]);
    digitsGdk[3]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _3XPM, &digitsMasks[3]);
    digitsGdk[4]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _4XPM, &digitsMasks[4]);
    digitsGdk[5]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _5XPM, &digitsMasks[5]);
    digitsGdk[6]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _6XPM, &digitsMasks[6]);
    digitsGdk[7]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _7XPM, &digitsMasks[7]);
    digitsGdk[8]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _8XPM, &digitsMasks[8]);
    digitsGdk[9]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _9XPM, &digitsMasks[9]);
    digitsGdk[10]=GDKPIXMAPCREATEWITHMASK(gtkI->win, nullXPM, &digitsMasks[10]);
    digitsGdk[11]=GDKPIXMAPCREATEWITHMASK(gtkI->win, colonXPM, &digitsMasks[11]);
    digitsGdk[12]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _startXPM, &digitsMasks[12]);
    digitsGdk[13]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _currentXPM, &digitsMasks[13]);
    digitsGdk[14]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _stopXPM, &digitsMasks[14]);
    digitsGdk[15]=GDKPIXMAPCREATEWITHMASK(gtkI->win, _windowXPM, &digitsMasks[15]);
    
    /*for (int i=0;i<XPMCNT;i++){
      char num[]={(char)(i+0x30), '\0'};
      gchar *path=g_strconcat(baseDir, num, ".xpm", '\0');
      digitsGdk[i]=PIXMAP_CREATE(path);
      g_free(path);
    }

    {gchar *path=g_strconcat(baseDir, "LScolon.xpm", '\0');
    digitsGdk[10]=PIXMAP_CREATE(path);
    g_free(path);}
    {gchar *path=g_strconcat(baseDir, "MScolon.xpm", '\0');
    digitsGdk[11]=PIXMAP_CREATE(path);
    g_free(path);}
    //  G_UNLOCK(digitsGdk);
    */
  }

  ~XPMDigits(void){
#ifdef DEBUG
    cout<<"XPMDigits::~XPMDigits"<<endl;
#endif
    for (int i=0;i<XPMCNT;i++){
      if (digitsGdk[i]) gdk_pixmap_unref(digitsGdk[i]);
      if (digitsMasks[i]) gdk_pixmap_unref(digitsMasks[i]);
    }
  }
};
#endif //XPMDIGITS_H_
