/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Rainbow.h
// Baudouin Raoult - ECMWF Oct 99

#ifndef Rainbow_H
#define Rainbow_H

#include <Xm/Xm.h>

class RainbowMaker {
public:
	virtual Pixel pixel(double x,double y) const = 0;
};

class Rainbow {
public:

// -- Exceptions
	// None

// -- Contructors

	Rainbow(Widget);

// -- Destructor

	~Rainbow(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void redraw();
	void fill(const RainbowMaker&);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Rainbow(const Rainbow&);
	Rainbow& operator=(const Rainbow&);

// -- Members

	Widget    widget_;
	GC        gc_;
	XImage*   image_;
	Dimension width_;
	Dimension height_;

// -- Methods
	// None

// -- Overridden methods

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Rainbow& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Rainbow**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Rainbow);
//#endif

#endif
