/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef LineFactory_H
#include "LineFactory.h"
#endif


#ifndef TextLine_H
#include "TextLine.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

static map<string,LineFactory*>* makers = 0;

LineFactory::LineFactory(const string& name)
{
	if(makers == 0)
		makers = new map<string,LineFactory*>;

	// Put in reverse order...
	(*makers)[name] = this;
}

LineFactory::~LineFactory()
{
	// Not called
}

RequestPanelLine* LineFactory::create(RequestPanel& e,const Parameter& p)
{
	const char* o = p.interface();
	if(o != 0)
	{
		map<string,LineFactory*>::iterator j = makers->find(o);
		if(j != makers->end())
			return (*j).second->make(e,p);
	}

	return  new TextLine(e,p);
}

