#
# This include file is used by more than one test suite
# (currently rpl and binlog_encryption).
# Please check all dependent tests after modifying it
#

source include/have_ssl_communication.inc;
source include/master-slave.inc;

# create a user for replication that requires ssl encryption
connection master;
create user replssl@localhost;
grant replication slave on *.* to replssl@localhost require ssl;
create table t1 (t int auto_increment, KEY(t));

sync_slave_with_master;

# Set slave to use SSL for connection to master
stop slave;
--replace_result $MYSQL_TEST_DIR MYSQL_TEST_DIR
eval change master to
  master_user='replssl',
  master_password='',
  master_ssl=1,
  master_ssl_ca ='$MYSQL_TEST_DIR/std_data/cacert.pem',
  master_ssl_cert='$MYSQL_TEST_DIR/std_data/client-cert.pem',
  master_ssl_key='$MYSQL_TEST_DIR/std_data/client-key.pem';
start slave;

# Switch to master and insert one record, then sync it to slave
connection master;
insert into t1 values(1);
sync_slave_with_master;

# The record should now be on slave
select * from t1;

# The slave is synced and waiting/reading from master
# SHOW SLAVE STATUS will show "Waiting for master to send event"
let $status_items= Master_SSL_Allowed, Master_SSL_CA_Path, Master_SSL_CA_File, Master_SSL_Cert, Master_SSL_Key;
source include/show_slave_status.inc;
source include/check_slave_is_running.inc;

# Stop the slave, as reported in bug#21871 it would hang
STOP SLAVE;

select * from t1;

# Do the same thing a number of times
disable_query_log;
disable_result_log;
# 2007-11-27 mats Bug #32756  	Starting and stopping the slave in a loop can lose rows
# After discussions with Engineering, I'm disabling this part of the test to avoid it causing
# red trees.
disable_parsing;
let $i= 100;
while ($i)
{
  start slave;
  connection master;
  insert into t1 values (NULL);
  select * from t1; # Some variance
  connection slave;
  select * from t1; # Some variance
  stop slave;
  dec $i;
}
enable_parsing;
START SLAVE;
enable_query_log;
enable_result_log;
connection master;
# INSERT one more record to make sure
# the sync has something to do
insert into t1 values (NULL);
let $master_count= `select count(*) from t1`;

sync_slave_with_master;
--source include/wait_for_slave_to_start.inc
source include/show_slave_status.inc;
source include/check_slave_is_running.inc;

let $slave_count= `select count(*) from t1`;

if ($slave_count != $master_count)
{
  echo master and slave differed in number of rows;
  echo master: $master_count;
  echo slave: $slave_count;

  connection master;
  echo === master ===;
  select count(*) t1;
  select * from t1;
  connection slave;
  echo === slave ===;
  select count(*) t1;
  select * from t1;
  query_vertical show slave status;
}

connection master;
drop user replssl@localhost;
drop table t1;
sync_slave_with_master;

--source include/stop_slave.inc
CHANGE MASTER TO
 master_user = 'root',
 master_ssl = 0,
 master_ssl_ca = '',
 master_ssl_cert = '',
 master_ssl_key = '';

--echo End of 5.0 tests
--let $rpl_only_running_threads= 1
--source include/rpl_end.inc
