#!/bin/sh
#
# makexvpics - create xv-compatible thumbnails
#
# needs:
# - netpbm (or pbmplus)
# - for JPEGs, djpeg
# - for PNGs, pngtopnm
# - for mrfs, mrftopbm
# - ppmtoxvmini (comes with makexvpics)
# - getopt (not a problem I hope :-))


# Uncomment this if you have my `pcx2ppm' installed, which copes with
# more types of PCX than netpbm's `pcxtoppm' does.
#USE_PCX2PPM=y


# usage: do_xvpic picture_file
#
# we already know it exists, is a regular file, is a supported picture
# file, and is readable.
make_xvpic() {
fnambit=`dirname $1`/.xvpics
mkdir $fnambit 2>/dev/null
xvpicname=${fnambit}/`basename $1`

# in order to make the xvpic, it has to either not exist, or be older
# than the picture file, or `-f' has to have been specified.
# note that we really do mean *exist*, not whether it's readable or not...

if [ ! -f "$xvpicname" -o "$1" -nt "$xvpicname" -o "$force" = "y" ]; then
  if [ "$verbose" = "y" ]; then
    echo "$1"
  fi
  trapdel="$xvpicname"
  eval "$command" <"$1" 2>/dev/null | pnmscale -xysize 80 60 2>/dev/null | \
    ppmquant -fs -map $tempfile.map 2>/dev/null >$tempfile.ppm
  # any errors above should have resulted in an empty or junk PPM,
  # which this will spot...
  ppmtoxvmini <$tempfile.ppm >"$xvpicname" 2>/dev/null || rm -f "$xvpicname"
  trapdel=""
fi
}


# usage: is_pic possible_picture_file
#
# tests filetype and permissions etc., and sets $command
is_pic() {
if [ -f "$1" -a -r "$1" ]; then
  case `echo $1 | tr [A-Z] [a-z]` in
    *.jpg|*.jpeg )
      command="djpeg -fast -scale 1/4"
      ;;
    *.gif )
      command=giftopnm
      ;;
    *.png )
      command=pngtopnm
      ;;
    *.pbm|*.pgm|*.ppm )
      command=cat
      ;;
    *.mrf )
      command=mrftopbm
      ;;
    *.bmp )
      command=bmptoppm
      ;;
    *.tga )
      command=tgatoppm
      ;;
    *.pcx )
      if [ "$USE_PCX2PPM" = "y" ]; then
        command=pcx2ppm
      else
        command=pcxtoppm
      fi
      ;;
    * )
      command=""
      return 1
      ;; 
  esac
  return 0
else	# if not normal file or not readable
  return 1
fi
}


# usage: do_files file1 [file2 ...]
#
# do files specified.
do_files() {
local olddir

for picture in $*; do
  if is_pic "$picture"; then
    make_xvpic "$picture"
  else
    # could be a directory...
    if [ "$recurse" = "y" -a -d "$picture" -a -r "$picture" ]; then
      olddir=`pwd`
      cd "$picture"
      do_files *
      cd "$olddir"
    fi
  fi
done
}


usage() {
cat <<'mouse'
usage: makexvpics [-fhRv] picture_file_or_dir [...]

	-f	force update of all picture files, new or not
	-h	give this usage help
	-R	recurse in subdirectories
	-v	be verbose - echo (`basename's of) files which are
		being updated
mouse
}



# starts here

tempfile=/tmp/mxvp$$
trapdel=""
trap 'rm -f $tempfile.* $trapdel' 0 1 3 15

ppmtoxvmini -genmap >$tempfile.map

# parse args

set -- `getopt fhRv $*`

for i; do
  case "$i" in
    -f )
      force=y
      shift
      ;;
    -h )
      usage
      exit 1
      ;;
    -R )
      recurse=y
      shift
      ;;
    -v )
      verbose=y
      shift
      ;;
    -- )
      shift
      break
      ;;
  esac
done


if [ "$1" = "" ]; then
  usage
  exit 1
fi


# index the files if needed

do_files $*

exit 0
