C (C) Copyright 1996-2016 ECMWF.
C 
C This software is licensed under the terms of the Apache Licence Version 2.0
C which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation nor
C does it submit to any jurisdiction.
C

	PROGRAM GRAF02
C
C	THIS PROGRAM DEMONSTRATES MAGICS GRAPH PLOTTING FACILITIES.
C	THERE ARE THREE FEATURES DEMONSTRATED:

C	(1) HIDDEN BARS
C	(2) CLUSTERED BARS
C	(3) OVERLAPPING BARS
C
C	OPEN MAGICS
C
	CALL POPEN
      CALL PARSE_COMMAND_LINE ('graf02')
C
	CALL PSETC ('PAGE_ID_LINE_USER_TEXT','TESTS/GRAF02')
	CALL PSETC ('SUBPAGE_MAP_PROJECTION', 'NONE')
C
C	PLOT HIDDEN BARS
C
	CALL GRAF02_ONE
	CALL PNEW ('PAGE')
C
C	PLOT CLUSTERED BARS   
C
	CALL GRAF02_TWO
	CALL PNEW ('PAGE')
C
C	PLOT OVERLAPPING BARS  
C
	CALL GRAF02_THREE
	CALL PCLOSE
	STOP
	END
	SUBROUTINE GRAF02_ONE
C
C   PLOT ONE SET OF BARS ON TOP OF ANOTHER
C
	DIMENSION X(6),YL(6),YU1(6),YU2(6)
	DATA X/1.,2.,3.,4.,5.,6./    
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,9.,1.,2.,9./
	DATA YU2/5.0,2.,3.,6.,5.,2./
C
C	SET UP AXIS    
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',7.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',1.0)     
	CALL PSETR ('AXIS_MAX_VALUE',10.0)    
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	FIRST SET OF BARS WITH HATCH STYLE SHADING
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETR ('GRAPH_BAR_WIDTH',1.20) 
	CALL PSETC ('GRAPH_SHADE','ON')    
	CALL PSETC ('GRAPH_SHADE_STYLE','HATCH')    
	CALL PSETC ('GRAPH_SHADE_COLOUR','RED')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YL, 6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU1,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','SYNOP')
	CALL PGRAPH
C
C	SECOND SET OF BARS WITH DOT SHADING
C
	CALL PSETC ('GRAPH_SHADE_STYLE','DOT')    
	CALL PSETC ('GRAPH_SHADE_COLOUR','BLUE')
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU2,6)
	CALL PSETC ('LEGEND_USER_TEXT','TEMP')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','Graph BAR Plotting with '//
     x             'HIDDEN BARS ')
	CALL PTEXT
	RETURN      
	END
	SUBROUTINE GRAF02_TWO
C
C	PLOT BARS IN CLUSTERS
C
	DIMENSION X(6),YL(6),YU1(6),YU2(6),YU3(6)
	DATA X/0.75,1.75,2.75,3.75,4.75,5.75/
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,9.,1.,2.,9./
	DATA YU2/5.0,2.,7.,6.,8.,7./
	DATA YU3/2.0,1.,2.,3.,9.,8./
C
C	SET UP AXIS             
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)     
	CALL PSETR ('AXIS_MAX_VALUE',7.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0) 
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')       
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',10.0)     
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	FIRST SET OF BARS - RED WITH HATCH SHADING
C
	CALL PSETC ('GRAPH_TYPE','BAR')    
	CALL PSETR ('GRAPH_BAR_WIDTH',0.88) 
	CALL PSETC ('GRAPH_SHADE','ON')    
	CALL PSETC ('GRAPH_SHADE_STYLE','HATCH')    
	CALL PSETI ('GRAPH_SHADE_HATCH_INDEX',5)
	CALL PSETC ('GRAPH_SHADE_COLOUR','RED')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YL, 6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU1,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','SYNOP')
	CALL PGRAPH
	DO 100 I=1,6
		X(I)=X(I)+0.25
100	CONTINUE
C
C	SECOND SET OF BARS - BLUE WITH HATCH SHADING
C
	CALL PSETC ('GRAPH_SHADE_COLOUR','BLUE')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU2,6)
	CALL PSETC ('LEGEND_USER_TEXT','TEMP')
	CALL PGRAPH
	DO 200 I=1,6
		X(I)=X(I)+0.25
200	CONTINUE
C
C	THIRD SET OF BARS - GREEN WITH HATCH SHADING
C
	CALL PSETC ('GRAPH_SHADE_COLOUR','GREEN')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU3,6)
	CALL PSETC ('LEGEND_USER_TEXT','PILOT')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','Graph BAR plotting in '//
     x             'CLUSTERS ')
	CALL PTEXT
	RETURN
C
	END
	SUBROUTINE GRAF02_THREE
C
C	PLOT OVERLAPPING BARS
C
	DIMENSION X(6),YL(6),YU1(6),YU2(6),YU3(6)
	DATA X/.9,1.9,2.9,3.9,4.9,5.9/
	DATA YL /6*0.0/
	DATA YU1/3.0,5.,9.,1.,2.,9./
	DATA YU2/5.0,2.,7.,6.,8.,7./
	DATA YU3/2.0,1.,2.,3.,9.,8./
C
C	SET UP AXIS SYSTEM
C
	CALL PSETC ('AXIS_ORIENTATION','HORIZONTAL')
	CALL PSETC ('AXIS_POSITION','BOTTOM')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',7.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
	CALL PSETC ('AXIS_ORIENTATION','VERTICAL')
	CALL PSETC ('AXIS_POSITION','LEFT')
	CALL PSETR ('AXIS_MIN_VALUE',0.0)
	CALL PSETR ('AXIS_MAX_VALUE',10.0)
	CALL PSETR ('AXIS_TICK_INTERVAL',1.0)
	CALL PAXIS
C
C	FIRST SET OF BARS - SOLID RED
C
	CALL PSETC ('GRAPH_TYPE','BAR')
	CALL PSETR ('GRAPH_BAR_WIDTH',1.20)
	CALL PSETC ('GRAPH_SHADE','ON')
	CALL PSETC ('GRAPH_SHADE_STYLE','AREA_FILL')
	CALL PSETC ('GRAPH_SHADE_COLOUR','RED')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_LOWER_VALUES',YL,6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU1,6)
	CALL PSETC ('LEGEND','ON')
	CALL PSETC ('LEGEND_USER_TEXT','SYNOP')
	CALL PGRAPH
C
C	SECOND SET OF BARS - SOLID BLUE
C
	DO 100 I=1,6
		X(I)=X(I)+0.2
100	CONTINUE
	CALL PSETC ('GRAPH_SHADE_COLOUR','BLUE')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU2,6)
	CALL PSETC ('LEGEND_USER_TEXT','TEMP')
	CALL PGRAPH
	CALL PSETC ('TEXT_LINE_1','Graph BAR plotting with '//
     x             'OVERLAPPING ')
	CALL PTEXT
	DO 200 I=1,6
		X(I)=X(I)+0.15
200	CONTINUE
	CALL PSETC ('GRAPH_SHADE_COLOUR','GREEN')
	CALL PSET1R ('GRAPH_BAR_X_VALUES',X,6)
	CALL PSET1R ('GRAPH_BAR_Y_UPPER_VALUES',YU3,6)
	CALL PSETC ('LEGEND_USER_TEXT','PILOT')
	CALL PGRAPH
	RETURN
C
	END


C --------------------------------------------------------------------
C     PARSE_COMMAND_LINE
C     Checks the command-line for any arguments.
C     Arguments can come in pairs. Currently supported arguments are:
C     PROJECTION <CYLINDRICAL | POLAR_STEREOGRAPHIC>
C     DEVICE <PS | SVG | PNG>
C     e.g. Run the program with:
C       <progname> PROJECTION CYLINDRICAL  DEVICE SVG
C --------------------------------------------------------------------

      SUBROUTINE PARSE_COMMAND_LINE (OUTROOTNAME)

      CHARACTER*32 ARG
      CHARACTER*64 ID_TEXT
      CHARACTER*32 PROJECTION
      CHARACTER*32 DEVICE
      CHARACTER*48 EXENAME
      CHARACTER*8  MINIMAL
      CHARACTER*8  SEPARATOR
      CHARACTER*64 OUTNAME
      CHARACTER*(*) OUTROOTNAME

      CHARACTER*16 FORMATS_PS_GIF
      DIMENSION    FORMATS_PS_GIF(2)
      DATA         FORMATS_PS_GIF /'PS', 'GIF_ANIMATION'/

      CHARACTER*16 FORMATS_PS_GIF_PDF
      DIMENSION    FORMATS_PS_GIF_PDF(3)
      DATA         FORMATS_PS_GIF_PDF /'PS', 'GIF_ANIMATION', 'PDF'/

      CHARACTER*16 FORMATS_PS_GIF_SVG
      DIMENSION    FORMATS_PS_GIF_SVG(3)
      DATA         FORMATS_PS_GIF_SVG /'PS', 'GIF_ANIMATION', 'SVG'/

      CHARACTER*16 FORMATS_PS_PNG_SVG
      DIMENSION    FORMATS_PS_PNG_SVG(3)
      DATA         FORMATS_PS_PNG_SVG /'PS', 'PNG', 'SVG'/

      CHARACTER*16 FORMATS_PS_GIF_PNG_SVG
      DIMENSION    FORMATS_PS_GIF_PNG_SVG(4)
      DATA         FORMATS_PS_GIF_PNG_SVG /'PS', 'GIF_ANIMATION', 
     +                                     'PNG', 'SVG'/

      CHARACTER*16 FORMATS_ALL
      DIMENSION    FORMATS_ALL(5)
      DATA         FORMATS_ALL /'PS', 'SVG', 'PDF',
     +                          'KML', 'PNG'/

      INTEGER NUM_ARGS
      INTEGER DEVICE_SET

      DEVICE_SET = 0

      ID_TEXT = ''

      NUM_ARGS = IARGC()

      I = 1
C
C  Start GoTo
C
20    IF (I.LE.NUM_ARGS) THEN
          CALL GETARG ( I, ARG )
C
C         Set the projection?
C
          IF (ARG.EQ.'PROJECTION') THEN
              I = I + 1 
              CALL GETARG ( I, PROJECTION ) 
              CALL PSETC ('SUBPAGE_MAP_PROJECTION', PROJECTION)
C
C        Set the device?
C
          ELSEIF (ARG.EQ.'DEVICE') THEN
              I = I + 1 
              CALL GETARG ( I, DEVICE ) 

C             Set the output filename

              IF     (DEVICE.EQ.'PS')  THEN
                OUTNAME = OUTROOTNAME //   '.ps'
                CALL PSETC ('DEVICE',       DEVICE)
                CALL PSETC ('PS_DEVICE',   'ps_a4')
                CALL PSETC ('PS_FILE_NAME', OUTNAME)
              ELSEIF (DEVICE.EQ.'PS_NEW') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'EPS') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'EPS')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'GIF') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF_ANIMATION')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
                CALL PSETI ('OUTPUT_GIF_DELAY',     150)
              ELSEIF (DEVICE.EQ.'GIF_MULTI') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'GIF')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PNG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'PNG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'JPEG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'JPEG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'SVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'SVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'CSVG') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'CSVG')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'KML') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'KML')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'BAD') THEN
                CALL PSETC ('OUTPUT_FORMAT',  'BAD')
                CALL PSETC ('OUTPUT_NAME', OUTROOTNAME)

              ELSEIF (DEVICE.EQ.'PS_GIF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF, 2)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PDF') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_PDF, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_GIF_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_PS_PNG_SVG, 3)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'PS_GIF_PNG_SVG') THEN
                CALL PSET1C ('OUTPUT_FORMATS',
     +                               FORMATS_PS_GIF_PNG_SVG, 4)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSEIF (DEVICE.EQ.'ALL') THEN
                CALL PSET1C ('OUTPUT_FORMATS', FORMATS_ALL, 5)
                CALL PSETC  ('OUTPUT_NAME', OUTROOTNAME)
              ELSE
                WRITE(*, '(A)') 'BAD DEVICE: ', DEVICE
              ENDIF
            
            DEVICE_SET = 1
C
C        Split the PostScript pages into separate files?
C
          ELSEIF (ARG.EQ.'PS_SPLIT') THEN
                CALL PSETC ('OUTPUT_PS_SPLIT',     'ON')
C
C        Turn on the numbering for the first page?
C
          ELSEIF (ARG.EQ.'FIRST_PAGE_NUMBER') THEN
                CALL PSETC ('OUTPUT_NAME_FIRST_PAGE_NUMBER', 'ON')
C
C         Set the minimal filename number width?
C
          ELSEIF (ARG.EQ.'MINIMAL') THEN
              I = I + 1 
              CALL GETARG (I, MINIMAL) 
              IF     (MINIMAL.EQ.'0')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 0)
              ELSEIF (MINIMAL.EQ.'1')  THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 1)
              ELSEIF (MINIMAL.EQ.'2') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 2)
              ELSEIF (MINIMAL.EQ.'3') THEN
                CALL PSETI ('OUTPUT_FILE_MINIMAL_WIDTH', 3)
              ENDIF
C
C         Set the file number separator?
C
          ELSEIF (ARG.EQ.'SEP') THEN
              I = I + 1 
              CALL GETARG ( I, SEPARATOR ) 
              CALL PSETC ('OUTPUT_FILE_SEPARATOR', SEPARATOR)
C
C        Run using linear contouring?
C
          ELSEIF (ARG.EQ.'LINEAR') THEN
                CALL PSETC ('CONTOUR_METHOD', 'LINEAR')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT_PLOT', 'ON')
                CALL PSETC ('PAGE_ID_LINE_USER_TEXT', 'LINEAR')
          ENDIF
          I = I + 1 
          GOTO 20
      ENDIF
C
C     If no device has been set, then use PostScript by default
C
      IF (DEVICE_SET.EQ.0) THEN
        OUTNAME = OUTROOTNAME // '.ps'
        CALL PSETC ('PS_DEVICE',    'ps_a4')
        CALL PSETC ('PS_FILE_NAME', OUTNAME)
      ENDIF
C
      END

