/*  Copyright (c) MediaArea.net SARL. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license that can
 *  be found in the License.html file in the root of the source tree.
 */

//---------------------------------------------------------------------------
// Pre-compilation
#include "MediaInfo/PreComp.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Setup.h"
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#if defined(MEDIAINFO_AAC_YES)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/Audio/File_Aac.h"
#include "MediaInfo/Audio/File_Aac_GeneralAudio.h"
#include "MediaInfo/MediaInfo_Config_MediaInfo.h"
using namespace std;
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Tables
//***************************************************************************

//---------------------------------------------------------------------------
// Scalefactor Huffman Codebook
const int8u huffman_sf[241][2]=
{
    {   1,   2 },
    {  60,   0 },
    {   1,   2 },
    {   2,   3 },
    {   3,   4 },
    {  59,   0 },
    {   3,   4 },
    {   4,   5 },
    {   5,   6 },
    {  61,   0 },
    {  58,   0 },
    {  62,   0 },
    {   3,   4 },
    {   4,   5 },
    {   5,   6 },
    {  57,   0 },
    {  63,   0 },
    {   4,   5 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {  56,   0 },
    {  64,   0 },
    {  55,   0 },
    {  65,   0 },
    {   4,   5 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {  66,   0 },
    {  54,   0 },
    {  67,   0 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  53,   0 },
    {  68,   0 },
    {  52,   0 },
    {  69,   0 },
    {  51,   0 },
    {   5,   6 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  70,   0 },
    {  50,   0 },
    {  49,   0 },
    {  71,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  72,   0 },
    {  48,   0 },
    {  73,   0 },
    {  47,   0 },
    {  74,   0 },
    {  46,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  76,   0 },
    {  75,   0 },
    {  77,   0 },
    {  78,   0 },
    {  45,   0 },
    {  43,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  44,   0 },
    {  79,   0 },
    {  42,   0 },
    {  41,   0 },
    {  80,   0 },
    {  40,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  81,   0 },
    {  39,   0 },
    {  82,   0 },
    {  38,   0 },
    {  83,   0 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  12,  13 },
    {  13,  14 },
    {  37,   0 },
    {  35,   0 },
    {  85,   0 },
    {  33,   0 },
    {  36,   0 },
    {  34,   0 },
    {  84,   0 },
    {  32,   0 },
    {   6,   7 },
    {   7,   8 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  87,   0 },
    {  89,   0 },
    {  30,   0 },
    {  31,   0 },
    {   8,   9 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  12,  13 },
    {  13,  14 },
    {  14,  15 },
    {  15,  16 },
    {  86,   0 },
    {  29,   0 },
    {  26,   0 },
    {  27,   0 },
    {  28,   0 },
    {  24,   0 },
    {  88,   0 },
    {   9,  10 },
    {  10,  11 },
    {  11,  12 },
    {  12,  13 },
    {  13,  14 },
    {  14,  15 },
    {  15,  16 },
    {  16,  17 },
    {  17,  18 },
    {  25,   0 },
    {  22,   0 },
    {  23,   0 },
    {  15,  16 },
    {  16,  17 },
    {  17,  18 },
    {  18,  19 },
    {  19,  20 },
    {  20,  21 },
    {  21,  22 },
    {  22,  23 },
    {  23,  24 },
    {  24,  25 },
    {  25,  26 },
    {  26,  27 },
    {  27,  28 },
    {  28,  29 },
    {  29,  30 },
    {  90,   0 },
    {  21,   0 },
    {  19,   0 },
    {   3,   0 },
    {   1,   0 },
    {   2,   0 },
    {   0,   0 },
    {  23,  24 },
    {  24,  25 },
    {  25,  26 },
    {  26,  27 },
    {  27,  28 },
    {  28,  29 },
    {  29,  30 },
    {  30,  31 },
    {  31,  32 },
    {  32,  33 },
    {  33,  34 },
    {  34,  35 },
    {  35,  36 },
    {  36,  37 },
    {  37,  38 },
    {  38,  39 },
    {  39,  40 },
    {  40,  41 },
    {  41,  42 },
    {  42,  43 },
    {  43,  44 },
    {  44,  45 },
    {  45,  46 },
    {  98,   0 },
    {  99,   0 },
    { 100,   0 },
    { 101,   0 },
    { 102,   0 },
    { 117,   0 },
    {  97,   0 },
    {  91,   0 },
    {  92,   0 },
    {  93,   0 },
    {  94,   0 },
    {  95,   0 },
    {  96,   0 },
    { 104,   0 },
    { 111,   0 },
    { 112,   0 },
    { 113,   0 },
    { 114,   0 },
    { 115,   0 },
    { 116,   0 },
    { 110,   0 },
    { 105,   0 },
    { 106,   0 },
    { 107,   0 },
    { 108,   0 },
    { 109,   0 },
    { 118,   0 },
    {   6,   0 },
    {   8,   0 },
    {   9,   0 },
    {  10,   0 },
    {   5,   0 },
    { 103,   0 },
    { 120,   0 },
    { 119,   0 },
    {   4,   0 },
    {   7,   0 },
    {  15,   0 },
    {  16,   0 },
    {  18,   0 },
    {  20,   0 },
    {  17,   0 },
    {  11,   0 },
    {  12,   0 },
    {  14,   0 },
    {  13,   0 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 1
const hcb_struct_1 huffman_01_1[32]=
{
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
    {  7, 0 },
    {  8, 0 },
    {  9, 2 },
    { 13, 2 },
    { 17, 2 },
    { 21, 2 },
    { 25, 2 },
    { 29, 2 },
    { 33, 4 },
    { 49, 6 }
};

const hcb_struct huffman_01[114]=
{
    {  1,  0,  0,  0,  0 },
    {  5,  1,  0,  0,  0 },
    {  5, -1,  0,  0,  0 },
    {  5,  0,  0,  0, -1 },
    {  5,  0,  1,  0,  0 },
    {  5,  0,  0,  0,  1 },
    {  5,  0,  0, -1,  0 },
    {  5,  0,  0,  1,  0 },
    {  5,  0, -1,  0,  0 },
    {  7,  1, -1,  0,  0 },
    {  7, -1,  1,  0,  0 },
    {  7,  0,  0, -1,  1 },
    {  7,  0,  1, -1,  0 },
    {  7,  0, -1,  1,  0 },
    {  7,  0,  0,  1, -1 },
    {  7,  1,  1,  0,  0 },
    {  7,  0,  0, -1, -1 },
    {  7, -1, -1,  0,  0 },
    {  7,  0, -1, -1,  0 },
    {  7,  1,  0, -1,  0 },
    {  7,  0,  1,  0, -1 },
    {  7, -1,  0,  1,  0 },
    {  7,  0,  0,  1,  1 },
    {  7,  1,  0,  1,  0 },
    {  7,  0, -1,  0,  1 },
    {  7,  0,  1,  1,  0 },
    {  7,  0,  1,  0,  1 },
    {  7, -1,  0, -1,  0 },
    {  7,  1,  0,  0,  1 },
    {  7, -1,  0,  0, -1 },
    {  7,  1,  0,  0, -1 },
    {  7, -1,  0,  0,  1 },
    {  7,  0, -1,  0, -1 },
    {  9,  1,  1, -1,  0 },
    {  9, -1,  1, -1,  0 },
    {  9,  1, -1,  1,  0 },
    {  9,  0,  1,  1, -1 },
    {  9,  0,  1, -1,  1 },
    {  9,  0, -1,  1,  1 },
    {  9,  0, -1,  1, -1 },
    {  9,  1, -1, -1,  0 },
    {  9,  1,  0, -1,  1 },
    {  9,  0,  1, -1, -1 },
    {  9, -1,  1,  1,  0 },
    {  9, -1,  0,  1, -1 },
    {  9, -1, -1,  1,  0 },
    {  9,  0, -1, -1,  1 },
    {  9,  1, -1,  0,  1 },
    {  9,  1, -1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1,  1,  0, -1 },
    {  9, -1, -1, -1,  0 },
    {  9, -1, -1, -1,  0 },
    {  9, -1, -1, -1,  0 },
    {  9, -1, -1, -1,  0 },
    {  9,  0, -1, -1, -1 },
    {  9,  0, -1, -1, -1 },
    {  9,  0, -1, -1, -1 },
    {  9,  0, -1, -1, -1 },
    {  9,  0,  1,  1,  1 },
    {  9,  0,  1,  1,  1 },
    {  9,  0,  1,  1,  1 },
    {  9,  0,  1,  1,  1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  0,  1, -1 },
    {  9,  1,  1,  0,  1 },
    {  9,  1,  1,  0,  1 },
    {  9,  1,  1,  0,  1 },
    {  9,  1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9, -1,  1,  0,  1 },
    {  9,  1,  1,  1,  0 },
    {  9,  1,  1,  1,  0 },
    {  9,  1,  1,  1,  0 },
    {  9,  1,  1,  1,  0 },
    { 10, -1, -1,  0,  1 },
    { 10, -1, -1,  0,  1 },
    { 10, -1,  0, -1, -1 },
    { 10, -1,  0, -1, -1 },
    { 10,  1,  1,  0, -1 },
    { 10,  1,  1,  0, -1 },
    { 10,  1,  0, -1, -1 },
    { 10,  1,  0, -1, -1 },
    { 10, -1,  0, -1,  1 },
    { 10, -1,  0, -1,  1 },
    { 10, -1, -1,  0, -1 },
    { 10, -1, -1,  0, -1 },
    { 10, -1,  0,  1,  1 },
    { 10, -1,  0,  1,  1 },
    { 10,  1,  0,  1,  1 },
    { 10,  1,  0,  1,  1 },
    { 11,  1, -1,  1, -1 },
    { 11, -1,  1, -1,  1 },
    { 11, -1,  1,  1, -1 },
    { 11,  1, -1, -1,  1 },
    { 11,  1,  1,  1,  1 },
    { 11, -1, -1,  1,  1 },
    { 11,  1,  1, -1, -1 },
    { 11, -1, -1,  1, -1 },
    { 11, -1, -1, -1, -1 },
    { 11,  1,  1, -1,  1 },
    { 11,  1, -1,  1,  1 },
    { 11, -1,  1,  1,  1 },
    { 11, -1,  1, -1, -1 },
    { 11, -1, -1, -1,  1 },
    { 11,  1, -1, -1, -1 },
    { 11,  1,  1,  1, -1 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 2
const hcb_struct_1 huffman_02_1[32] =
{
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
    {  7, 0 },
    {  8, 0 },
    {  9, 1 },
    { 11, 1 },
    { 13, 1 },
    { 15, 1 },
    { 17, 1 },
    { 19, 1 },
    { 21, 1 },
    { 23, 1 },
    { 25, 1 },
    { 27, 1 },
    { 29, 1 },
    { 31, 1 },
    { 33, 2 },
    { 37, 2 },
    { 41, 2 },
    { 45, 3 },
    { 53, 3 },
    { 61, 3 },
    { 69, 4 }
};

const hcb_struct huffman_02[86]=
{
    { 3,  0,  0,  0,  0 },
    { 4,  1,  0,  0,  0 },
    { 5, -1,  0,  0,  0 },
    { 5,  0,  0,  0,  1 },
    { 5,  0,  0, -1,  0 },
    { 5,  0,  0,  0, -1 },
    { 5,  0, -1,  0,  0 },
    { 5,  0,  0,  1,  0 },
    { 5,  0,  1,  0,  0 },
    { 6,  0, -1,  1,  0 },
    { 6, -1,  1,  0,  0 },
    { 6,  0,  1, -1,  0 },
    { 6,  0,  0,  1, -1 },
    { 6,  0,  1,  0, -1 },
    { 6,  0,  0, -1,  1 },
    { 6, -1,  0,  0, -1 },
    { 6,  1, -1,  0,  0 },
    { 6,  1,  0, -1,  0 },
    { 6, -1, -1,  0,  0 },
    { 6,  0,  0, -1, -1 },
    { 6,  1,  0,  1,  0 },
    { 6,  1,  0,  0,  1 },
    { 6,  0, -1,  0,  1 },
    { 6, -1,  0,  1,  0 },
    { 6,  0,  1,  0,  1 },
    { 6,  0, -1, -1,  0 },
    { 6, -1,  0,  0,  1 },
    { 6,  0, -1,  0, -1 },
    { 6, -1,  0, -1,  0 },
    { 6,  1,  1,  0,  0 },
    { 6,  0,  1,  1,  0 },
    { 6,  0,  0,  1,  1 },
    { 6,  1,  0,  0, -1 },
    { 7,  0,  1, -1,  1 },
    { 7,  1,  0, -1,  1 },
    { 7, -1,  1, -1,  0 },
    { 7,  0, -1,  1, -1 },
    { 7,  1, -1,  1,  0 },
    { 7,  1,  1,  0, -1 },
    { 7,  1,  0,  1,  1 },
    { 7, -1,  1,  1,  0 },
    { 7,  0, -1, -1,  1 },
    { 7,  1,  1,  1,  0 },
    { 7, -1,  0,  1, -1 },
    { 7, -1, -1, -1,  0 },
    { 7, -1,  0, -1,  1 },
    { 7, -1,  0, -1,  1 },
    { 7,  1, -1, -1,  0 },
    { 7,  1, -1, -1,  0 },
    { 7,  1,  1, -1,  0 },
    { 7,  1,  1, -1,  0 },
    { 8,  1, -1,  0,  1 },
    { 8, -1,  1,  0, -1 },
    { 8, -1, -1,  1,  0 },
    { 8, -1,  0,  1,  1 },
    { 8, -1, -1,  0,  1 },
    { 8, -1, -1,  0, -1 },
    { 8,  0, -1, -1, -1 },
    { 8,  1,  0,  1, -1 },
    { 8,  1,  0, -1, -1 },
    { 8,  0,  1, -1, -1 },
    { 8,  0,  1,  1,  1 },
    { 8, -1,  1,  0,  1 },
    { 8, -1,  0, -1, -1 },
    { 8,  0,  1,  1, -1 },
    { 8,  1, -1,  0, -1 },
    { 8,  0, -1,  1,  1 },
    { 8,  1,  1,  0,  1 },
    { 8,  1, -1,  1, -1 },
    { 8, -1,  1, -1,  1 },
    { 8, -1,  1, -1,  1 },
    { 9,  1, -1, -1,  1 },
    { 9, -1, -1, -1, -1 },
    { 9, -1,  1,  1, -1 },
    { 9, -1,  1,  1,  1 },
    { 9,  1,  1,  1,  1 },
    { 9, -1, -1,  1, -1 },
    { 9,  1, -1,  1,  1 },
    { 9, -1,  1, -1, -1 },
    { 9, -1, -1,  1,  1 },
    { 9,  1,  1, -1, -1 },
    { 9,  1, -1, -1, -1 },
    { 9, -1, -1, -1,  1 },
    { 9,  1,  1, -1,  1 },
    { 9,  1,  1,  1, -1 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 2
const hcb_struct huffman_03[161] =
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1,  1,  0 },
    { 1,  0,  0,  0,  1 },
    { 1,  0,  1,  0,  0 },
    { 1,  0,  0,  1,  0 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1,  1,  1 },
    { 1,  0,  0,  1,  1 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  0,  1,  1,  0 },
    { 1,  0,  1,  0,  1 },
    { 1,  1,  0,  1,  0 },
    { 1,  0,  1,  1,  1 },
    { 1,  1,  0,  0,  1 },
    { 1,  1,  1,  1,  0 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  1,  1,  1,  1 },
    { 1,  1,  0,  1,  1 },
    { 1,  1,  1,  0,  1 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 1,  2,  0,  0,  0 },
    { 1,  0,  0,  0,  2 },
    { 1,  0,  0,  1,  2 },
    { 1,  2,  1,  0,  0 },
    { 1,  1,  2,  1,  0 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 1,  0,  0,  2,  1 },
    { 1,  0,  1,  2,  1 },
    { 1,  1,  2,  0,  0 },
    { 1,  0,  1,  1,  2 },
    { 1,  2,  1,  1,  0 },
    { 1,  0,  0,  2,  0 },
    { 1,  0,  2,  1,  0 },
    { 1,  0,  1,  2,  0 },
    { 1,  0,  2,  0,  0 },
    { 1,  0,  1,  0,  2 },
    { 1,  2,  0,  1,  0 },
    { 1,  1,  2,  1,  1 },
    { 1,  0,  2,  1,  1 },
    { 1,  1,  1,  2,  0 },
    { 1,  1,  1,  2,  1 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 1,  1,  2,  0,  1 },
    { 1,  1,  0,  2,  0 },
    { 1,  1,  0,  2,  1 },
    { 1,  0,  2,  0,  1 },
    { 1,  2,  1,  1,  1 },
    { 1,  1,  1,  1,  2 },
    { 1,  2,  1,  0,  1 },
    { 1,  1,  0,  1,  2 },
    { 1,  0,  0,  2,  2 },
    { 1,  0,  1,  2,  2 },
    { 1,  2,  2,  1,  0 },
    { 1,  1,  2,  2,  0 },
    { 1,  1,  0,  0,  2 },
    { 1,  2,  0,  0,  1 },
    { 1,  0,  2,  2,  1 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 1,  2,  2,  0,  0 },
    { 1,  1,  2,  2,  1 },
    { 1,  1,  1,  0,  2 },
    { 1,  2,  0,  1,  1 },
    { 1,  1,  1,  2,  2 },
    { 1,  2,  2,  1,  1 },
    { 1,  0,  2,  2,  0 },
    { 1,  0,  2,  1,  2 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  1,  0,  2,  2 },
    { 1,  2,  2,  0,  1 },
    { 1,  2,  1,  2,  0 },
    { 1,  2,  2,  2,  0 },
    { 1,  0,  2,  2,  2 },
    { 1,  2,  2,  2,  1 },
    { 1,  2,  1,  2,  1 },
    { 1,  1,  2,  1,  2 },
    { 1,  1,  2,  2,  2 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 1,  0,  2,  0,  2 },
    { 1,  2,  0,  2,  0 },
    { 1,  1,  2,  0,  2 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 1,  2,  0,  2,  1 },
    { 1,  2,  1,  1,  2 },
    { 1,  2,  1,  0,  2 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 1,  2,  2,  2,  2 },
    { 1,  2,  2,  1,  2 },
    { 1,  2,  1,  2,  2 },
    { 1,  2,  0,  1,  2 },
    { 1,  2,  0,  0,  2 },
    { 0,  1,  2 },
    { 1,  2,  2,  0,  2 },
    { 1,  2,  0,  2,  2 },
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 4
const hcb_struct_1 huffman_04_1[32]=
{
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  2, 0 },
    {  3, 0 },
    {  3, 0 },
    {  4, 0 },
    {  4, 0 },
    {  5, 0 },
    {  5, 0 },
    {  6, 0 },
    {  6, 0 },
    {  7, 0 },
    {  7, 0 },
    {  8, 0 },
    {  8, 0 },
    {  9, 0 },
    {  9, 0 },
    { 10, 0 },
    { 11, 0 },
    { 12, 0 },
    { 13, 0 },
    { 14, 0 },
    { 15, 0 },
    { 16, 2 },
    { 20, 2 },
    { 24, 3 },
    { 32, 3 },
    { 40, 4 },
    { 56, 7 }
};

const hcb_struct huffman_04[185]=
{
    {  4,  1,  1,  1,  1 },
    {  4,  0,  1,  1,  1 },
    {  4,  1,  1,  0,  1 },
    {  4,  1,  1,  1,  0 },
    {  4,  1,  0,  1,  1 },
    {  4,  1,  0,  0,  0 },
    {  4,  1,  1,  0,  0 },
    {  4,  0,  0,  0,  0 },
    {  4,  0,  0,  1,  1 },
    {  4,  1,  0,  1,  0 },
    {  5,  1,  0,  0,  1 },
    {  5,  0,  1,  1,  0 },
    {  5,  0,  0,  0,  1 },
    {  5,  0,  1,  0,  1 },
    {  5,  0,  0,  1,  0 },
    {  5,  0,  1,  0,  0 },
    {  7,  2,  1,  1,  1 },
    {  7,  1,  1,  2,  1 },
    {  7,  1,  2,  1,  1 },
    {  7,  1,  1,  1,  2 },
    {  7,  2,  1,  1,  0 },
    {  7,  2,  1,  0,  1 },
    {  7,  1,  2,  1,  0 },
    {  7,  2,  0,  1,  1 },
    {  7,  0,  1,  2,  1 },
    {  7,  0,  1,  2,  1 },
    {  8,  0,  1,  1,  2 },
    {  8,  1,  1,  2,  0 },
    {  8,  0,  2,  1,  1 },
    {  8,  1,  0,  1,  2 },
    {  8,  1,  2,  0,  1 },
    {  8,  1,  1,  0,  2 },
    {  8,  1,  0,  2,  1 },
    {  8,  2,  1,  0,  0 },
    {  8,  2,  0,  1,  0 },
    {  8,  1,  2,  0,  0 },
    {  8,  2,  0,  0,  1 },
    {  8,  0,  1,  0,  2 },
    {  8,  0,  2,  1,  0 },
    {  8,  0,  0,  1,  2 },
    {  8,  0,  1,  2,  0 },
    {  8,  0,  1,  2,  0 },
    {  8,  0,  2,  0,  1 },
    {  8,  0,  2,  0,  1 },
    {  8,  1,  0,  0,  2 },
    {  8,  1,  0,  0,  2 },
    {  8,  0,  0,  2,  1 },
    {  8,  0,  0,  2,  1 },
    {  8,  1,  0,  2,  0 },
    {  8,  1,  0,  2,  0 },
    {  8,  2,  0,  0,  0 },
    {  8,  2,  0,  0,  0 },
    {  8,  0,  0,  0,  2 },
    {  8,  0,  0,  0,  2 },
    {  9,  0,  2,  0,  0 },
    {  9,  0,  0,  2,  0 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  1,  2,  2,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  2,  1,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  2,  1,  2,  1 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  1,  2,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  1,  2,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    {  9,  2,  1,  1,  2 },
    { 10,  1,  2,  2,  0 },
    { 10,  1,  2,  2,  0 },
    { 10,  1,  2,  2,  0 },
    { 10,  1,  2,  2,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  2,  1,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  2,  1,  2,  0 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  2,  2,  1 },
    { 10,  0,  1,  2,  2 },
    { 10,  0,  1,  2,  2 },
    { 10,  0,  1,  2,  2 },
    { 10,  0,  1,  2,  2 },
    { 10,  2,  2,  0,  1 },
    { 10,  2,  2,  0,  1 },
    { 10,  2,  2,  0,  1 },
    { 10,  2,  2,  0,  1 },
    { 10,  0,  2,  1,  2 },
    { 10,  0,  2,  1,  2 },
    { 10,  0,  2,  1,  2 },
    { 10,  0,  2,  1,  2 },
    { 10,  2,  0,  2,  1 },
    { 10,  2,  0,  2,  1 },
    { 10,  2,  0,  2,  1 },
    { 10,  2,  0,  2,  1 },
    { 10,  1,  0,  2,  2 },
    { 10,  1,  0,  2,  2 },
    { 10,  1,  0,  2,  2 },
    { 10,  1,  0,  2,  2 },
    { 10,  2,  2,  2,  1 },
    { 10,  2,  2,  2,  1 },
    { 10,  2,  2,  2,  1 },
    { 10,  2,  2,  2,  1 },
    { 10,  1,  2,  0,  2 },
    { 10,  1,  2,  0,  2 },
    { 10,  1,  2,  0,  2 },
    { 10,  1,  2,  0,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  0,  1,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  2,  1,  0,  2 },
    { 10,  1,  2,  2,  2 },
    { 10,  1,  2,  2,  2 },
    { 10,  1,  2,  2,  2 },
    { 10,  1,  2,  2,  2 },
    { 11,  2,  1,  2,  2 },
    { 11,  2,  1,  2,  2 },
    { 11,  2,  2,  1,  2 },
    { 11,  2,  2,  1,  2 },
    { 11,  0,  2,  2,  0 },
    { 11,  0,  2,  2,  0 },
    { 11,  2,  2,  0,  0 },
    { 11,  2,  2,  0,  0 },
    { 11,  0,  0,  2,  2 },
    { 11,  0,  0,  2,  2 },
    { 11,  2,  0,  2,  0 },
    { 11,  2,  0,  2,  0 },
    { 11,  0,  2,  0,  2 },
    { 11,  0,  2,  0,  2 },
    { 11,  2,  0,  0,  2 },
    { 11,  2,  0,  0,  2 },
    { 11,  2,  2,  2,  2 },
    { 11,  2,  2,  2,  2 },
    { 11,  0,  2,  2,  2 },
    { 11,  0,  2,  2,  2 },
    { 11,  2,  2,  2,  0 },
    { 11,  2,  2,  2,  0 },
    { 12,  2,  2,  0,  2 },
    { 12,  2,  0,  2,  2 },
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 5
const hcb_struct huffman_05[161]=
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1, -1,  0 },
    { 1,  1,  0 },
    { 1,  0,  1 },
    { 1,  0, -1 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 1,  1, -1 },
    { 1, -1,  1 },
    { 1, -1, -1 },
    { 1,  1,  1 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1, -2,  0 },
    { 1,  0,  2 },
    { 1,  2,  0 },
    { 1,  0, -2 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -2, -1 },
    { 1,  2,  1 },
    { 1, -1, -2 },
    { 1,  1,  2 },
    { 1, -2,  1 },
    { 1,  2, -1 },
    { 1, -1,  2 },
    { 1,  1, -2 },
    { 1, -3,  0 },
    { 1,  3,  0 },
    { 1,  0, -3 },
    { 1,  0,  3 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -3, -1 },
    { 1,  1,  3 },
    { 1,  3,  1 },
    { 1, -1, -3 },
    { 1, -3,  1 },
    { 1,  3, -1 },
    { 1,  1, -3 },
    { 1, -1,  3 },
    { 1, -2,  2 },
    { 1,  2,  2 },
    { 1, -2, -2 },
    { 1,  2, -2 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -3, -2 },
    { 1,  3, -2 },
    { 1, -2,  3 },
    { 1,  2, -3 },
    { 1,  3,  2 },
    { 1,  2,  3 },
    { 1, -3,  2 },
    { 1, -2, -3 },
    { 1,  0, -4 },
    { 1, -4,  0 },
    { 1,  4,  1 },
    { 1,  4,  0 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1, -4, -1 },
    { 1,  0,  4 },
    { 1,  4, -1 },
    { 1, -1, -4 },
    { 1,  1,  4 },
    { 1, -1,  4 },
    { 1, -4,  1 },
    { 1,  1, -4 },
    { 1,  3, -3 },
    { 1, -3, -3 },
    { 1, -3,  3 },
    { 1, -2,  4 },
    { 1, -4, -2 },
    { 1,  4,  2 },
    { 1,  2, -4 },
    { 1,  2,  4 },
    { 1,  3,  3 },
    { 1, -4,  2 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1, -2, -4 },
    { 1,  4, -2 },
    { 1,  3, -4 },
    { 1, -4, -3 },
    { 1, -4,  3 },
    { 1,  3,  4 },
    { 1, -3,  4 },
    { 1,  4,  3 },
    { 1,  4, -3 },
    { 1, -3, -4 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  4, -4 },
    { 1, -4,  4 },
    { 1,  4,  4 },
    { 1, -4, -4 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 6
const hcb_struct_1 huffman_06_1[32] = {
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  2, 0 },
    {  3, 0 },
    {  3, 0 },
    {  4, 0 },
    {  4, 0 },
    {  5, 0 },
    {  5, 0 },
    {  6, 0 },
    {  6, 0 },
    {  7, 0 },
    {  7, 0 },
    {  8, 0 },
    {  8, 0 },
    {  9, 1 },
    {  11, 1 },
    {  13, 1 },
    {  15, 1 },
    {  17, 1 },
    {  19, 1 },
    {  21, 1 },
    {  23, 1 },
    {  25, 2 },
    {  29, 2 },
    {  33, 2 },
    {  37, 3 },
    {  45, 4 },
    {  61, 6 }
};

const hcb_struct huffman_06[126]=
{
    {  4,  0,  0 },
    {  4,  1,  0 },
    {  4,  0, -1 },
    {  4,  0,  1 },
    {  4, -1,  0 },
    {  4,  1,  1 },
    {  4, -1,  1 },
    {  4,  1, -1 },
    {  4, -1, -1 },
    {  6,  2, -1 },
    {  6,  2,  1 },
    {  6, -2,  1 },
    {  6, -2, -1 },
    {  6, -2,  0 },
    {  6, -1,  2 },
    {  6,  2,  0 },
    {  6,  1, -2 },
    {  6,  1,  2 },
    {  6,  0, -2 },
    {  6, -1, -2 },
    {  6,  0,  2 },
    {  6,  2, -2 },
    {  6, -2,  2 },
    {  6, -2, -2 },
    {  6,  2,  2 },
    {  7, -3,  1 },
    {  7,  3,  1 },
    {  7,  3, -1 },
    {  7, -1,  3 },
    {  7, -3, -1 },
    {  7,  1,  3 },
    {  7,  1, -3 },
    {  7, -1, -3 },
    {  7,  3,  0 },
    {  7, -3,  0 },
    {  7,  0, -3 },
    {  7,  0,  3 },
    {  7,  3,  2 },
    {  7,  3,  2 },
    {  8, -3, -2 },
    {  8, -2,  3 },
    {  8,  2,  3 },
    {  8,  3, -2 },
    {  8,  2, -3 },
    {  8, -2, -3 },
    {  8, -3,  2 },
    {  8, -3,  2 },
    {  8,  3,  3 },
    {  8,  3,  3 },
    {  9,  3, -3 },
    {  9, -3, -3 },
    {  9, -3,  3 },
    {  9,  1, -4 },
    {  9, -1, -4 },
    {  9,  4,  1 },
    {  9, -4,  1 },
    {  9, -4, -1 },
    {  9,  1,  4 },
    {  9,  4, -1 },
    {  9, -1,  4 },
    {  9,  0, -4 },
    {  9, -4,  2 },
    {  9, -4,  2 },
    {  9, -4,  2 },
    {  9, -4,  2 },
    {  9, -4, -2 },
    {  9, -4, -2 },
    {  9, -4, -2 },
    {  9, -4, -2 },
    {  9,  2,  4 },
    {  9,  2,  4 },
    {  9,  2,  4 },
    {  9,  2,  4 },
    {  9, -2, -4 },
    {  9, -2, -4 },
    {  9, -2, -4 },
    {  9, -2, -4 },
    {  9, -4,  0 },
    {  9, -4,  0 },
    {  9, -4,  0 },
    {  9, -4,  0 },
    {  9,  4,  2 },
    {  9,  4,  2 },
    {  9,  4,  2 },
    {  9,  4,  2 },
    {  9,  4, -2 },
    {  9,  4, -2 },
    {  9,  4, -2 },
    {  9,  4, -2 },
    {  9, -2,  4 },
    {  9, -2,  4 },
    {  9, -2,  4 },
    {  9, -2,  4 },
    {  9,  4,  0 },
    {  9,  4,  0 },
    {  9,  4,  0 },
    {  9,  4,  0 },
    {  9,  2, -4 },
    {  9,  2, -4 },
    {  9,  2, -4 },
    {  9,  2, -4 },
    {  9,  0,  4 },
    {  9,  0,  4 },
    {  9,  0,  4 },
    {  9,  0,  4 },
    { 10, -3, -4 },
    { 10, -3, -4 },
    { 10, -3,  4 },
    { 10, -3,  4 },
    { 10,  3, -4 },
    { 10,  3, -4 },
    { 10,  4, -3 },
    { 10,  4, -3 },
    { 10,  3,  4 },
    { 10,  3,  4 },
    { 10,  4,  3 },
    { 10,  4,  3 },
    { 10, -4,  3 },
    { 10, -4,  3 },
    { 10, -4, -3 },
    { 10, -4, -3 },
    { 11,  4,  4 },
    { 11, -4,  4 },
    { 11, -4, -4 },
    { 11,  4, -4 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 7
const hcb_struct huffman_07[127] =
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  0 },
    { 1,  0,  1 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  1 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  2,  1 },
    { 1,  1,  2 },
    { 1,  2,  0 },
    { 1,  0,  2 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1,  3,  1 },
    { 1,  1,  3 },
    { 1,  2,  2 },
    { 1,  3,  0 },
    { 1,  0,  3 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 1,  2,  3 },
    { 1,  3,  2 },
    { 1,  1,  4 },
    { 1,  4,  1 },
    { 1,  1,  5 },
    { 1,  5,  1 },
    { 1,  3,  3 },
    { 1,  2,  4 },
    { 1,  0,  4 },
    { 1,  4,  0 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 1,  4,  2 },
    { 1,  2,  5 },
    { 1,  5,  2 },
    { 1,  0,  5 },
    { 1,  6,  1 },
    { 1,  5,  0 },
    { 1,  1,  6 },
    { 1,  4,  3 },
    { 1,  3,  5 },
    { 1,  3,  4 },
    { 1,  5,  3 },
    { 1,  2,  6 },
    { 1,  6,  2 },
    { 1,  1,  7 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 1,  3,  6 },
    { 1,  0,  6 },
    { 1,  6,  0 },
    { 1,  4,  4 },
    { 1,  7,  1 },
    { 1,  4,  5 },
    { 1,  7,  2 },
    { 1,  5,  4 },
    { 1,  6,  3 },
    { 1,  2,  7 },
    { 1,  7,  3 },
    { 1,  6,  4 },
    { 1,  5,  5 },
    { 1,  4,  6 },
    { 1,  3,  7 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 1,  7,  0 },
    { 1,  0,  7 },
    { 1,  6,  5 },
    { 1,  5,  6 },
    { 1,  7,  4 },
    { 1,  4,  7 },
    { 1,  5,  7 },
    { 1,  7,  5 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  7,  6 },
    { 1,  6,  6 },
    { 1,  6,  7 },
    { 1,  7,  7 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 8
const hcb_struct_1 huffman_08_1[32]=
{
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  0, 0 },
    {  1, 0 },
    {  1, 0 },
    {  2, 0 },
    {  2, 0 },
    {  3, 0 },
    {  3, 0 },
    {  4, 0 },
    {  4, 0 },
    {  5, 0 },
    {  5, 0 },
    {  6, 0 },
    {  7, 0 },
    {  8, 0 },
    {  9, 0 },
    { 10, 0 },
    { 11, 0 },
    { 12, 0 },
    { 13, 1 },
    { 15, 1 },
    { 17, 1 },
    { 19, 1 },
    { 21, 1 },
    { 23, 2 },
    { 27, 2 },
    { 31, 2 },
    { 35, 3 },
    { 43, 3 },
    { 51, 5 }
};

const hcb_struct huffman_08[83]=
{
    {  3,  1,  1 },
    {  4,  2,  1 },
    {  4,  1,  0 },
    {  4,  1,  2 },
    {  4,  0,  1 },
    {  4,  2,  2 },
    {  5,  0,  0 },
    {  5,  2,  0 },
    {  5,  0,  2 },
    {  5,  3,  1 },
    {  5,  1,  3 },
    {  5,  3,  2 },
    {  5,  2,  3 },
    {  6,  3,  3 },
    {  6,  4,  1 },
    {  6,  1,  4 },
    {  6,  4,  2 },
    {  6,  2,  4 },
    {  6,  3,  0 },
    {  6,  0,  3 },
    {  6,  4,  3 },
    {  6,  3,  4 },
    {  6,  5,  2 },
    {  7,  5,  1 },
    {  7,  2,  5 },
    {  7,  1,  5 },
    {  7,  5,  3 },
    {  7,  3,  5 },
    {  7,  4,  4 },
    {  7,  5,  4 },
    {  7,  0,  4 },
    {  7,  4,  5 },
    {  7,  4,  0 },
    {  7,  2,  6 },
    {  7,  6,  2 },
    {  7,  6,  1 },
    {  7,  6,  1 },
    {  7,  1,  6 },
    {  7,  1,  6 },
    {  8,  3,  6 },
    {  8,  6,  3 },
    {  8,  5,  5 },
    {  8,  5,  0 },
    {  8,  6,  4 },
    {  8,  0,  5 },
    {  8,  4,  6 },
    {  8,  7,  1 },
    {  8,  7,  2 },
    {  8,  2,  7 },
    {  8,  6,  5 },
    {  8,  7,  3 },
    {  8,  1,  7 },
    {  8,  1,  7 },
    {  8,  1,  7 },
    {  8,  1,  7 },
    {  8,  5,  6 },
    {  8,  5,  6 },
    {  8,  5,  6 },
    {  8,  5,  6 },
    {  8,  3,  7 },
    {  8,  3,  7 },
    {  8,  3,  7 },
    {  8,  3,  7 },
    {  9,  6,  6 },
    {  9,  6,  6 },
    {  9,  7,  4 },
    {  9,  7,  4 },
    {  9,  6,  0 },
    {  9,  6,  0 },
    {  9,  4,  7 },
    {  9,  4,  7 },
    {  9,  0,  6 },
    {  9,  0,  6 },
    {  9,  7,  5 },
    {  9,  7,  5 },
    {  9,  7,  6 },
    {  9,  7,  6 },
    {  9,  6,  7 },
    {  9,  6,  7 },
    { 10,  5,  7 },
    { 10,  7,  0 },
    { 10,  0,  7 },
    { 10,  7,  7 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 9
const hcb_struct huffman_09[337]=
{
    { 0,  1,  2 },
    { 1,  0,  0 },
    { 0,  1,  2 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  0 },
    { 1,  0,  1 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1,  1,  1 },
    { 0,  3,  4 },
    { 0,  4,  5 },
    { 0,  5,  6 },
    { 0,  6,  7 },
    { 0,  7,  8 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 1,  2,  1 },
    { 1,  1,  2 },
    { 1,  2,  0 },
    { 1,  0,  2 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1,  3,  1 },
    { 1,  2,  2 },
    { 1,  1,  3 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 0, 16, 17 },
    { 0, 17, 18 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 1,  3,  0 },
    { 1,  0,  3 },
    { 1,  2,  3 },
    { 1,  3,  2 },
    { 1,  1,  4 },
    { 1,  4,  1 },
    { 1,  2,  4 },
    { 1,  1,  5 },
    { 0, 18, 19 },
    { 0, 19, 20 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 0, 26, 27 },
    { 0, 27, 28 },
    { 0, 28, 29 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 1,  4,  2 },
    { 1,  3,  3 },
    { 1,  0,  4 },
    { 1,  4,  0 },
    { 1,  5,  1 },
    { 1,  2,  5 },
    { 1,  1,  6 },
    { 1,  3,  4 },
    { 1,  5,  2 },
    { 1,  6,  1 },
    { 1,  4,  3 },
    { 0, 25, 26 },
    { 0, 26, 27 },
    { 0, 27, 28 },
    { 0, 28, 29 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 0, 40, 41 },
    { 0, 41, 42 },
    { 0, 42, 43 },
    { 0, 43, 44 },
    { 0, 44, 45 },
    { 0, 45, 46 },
    { 0, 46, 47 },
    { 0, 47, 48 },
    { 0, 48, 49 },
    { 0, 49, 50 },
    { 1,  0,  5 },
    { 1,  2,  6 },
    { 1,  5,  0 },
    { 1,  1,  7 },
    { 1,  3,  5 },
    { 1,  1,  8 },
    { 1,  8,  1 },
    { 1,  4,  4 },
    { 1,  5,  3 },
    { 1,  6,  2 },
    { 1,  7,  1 },
    { 1,  0,  6 },
    { 1,  8,  2 },
    { 1,  2,  8 },
    { 1,  3,  6 },
    { 1,  2,  7 },
    { 1,  4,  5 },
    { 1,  9,  1 },
    { 1,  1,  9 },
    { 1,  7,  2 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 0, 40, 41 },
    { 0, 41, 42 },
    { 0, 42, 43 },
    { 0, 43, 44 },
    { 0, 44, 45 },
    { 0, 45, 46 },
    { 0, 46, 47 },
    { 0, 47, 48 },
    { 0, 48, 49 },
    { 0, 49, 50 },
    { 0, 50, 51 },
    { 0, 51, 52 },
    { 0, 52, 53 },
    { 0, 53, 54 },
    { 0, 54, 55 },
    { 0, 55, 56 },
    { 0, 56, 57 },
    { 0, 57, 58 },
    { 0, 58, 59 },
    { 0, 59, 60 },
    { 1,  6,  0 },
    { 1,  5,  4 },
    { 1,  6,  3 },
    { 1,  8,  3 },
    { 1,  0,  7 },
    { 1,  9,  2 },
    { 1,  3,  8 },
    { 1,  4,  6 },
    { 1,  3,  7 },
    { 1,  0,  8 },
    { 1, 10,  1 },
    { 1,  6,  4 },
    { 1,  2,  9 },
    { 1,  5,  5 },
    { 1,  8,  0 },
    { 1,  7,  0 },
    { 1,  7,  3 },
    { 1, 10,  2 },
    { 1,  9,  3 },
    { 1,  8,  4 },
    { 1,  1, 10 },
    { 1,  7,  4 },
    { 1,  6,  5 },
    { 1,  5,  6 },
    { 1,  4,  8 },
    { 1,  4,  7 },
    { 1,  3,  9 },
    { 1, 11,  1 },
    { 1,  5,  8 },
    { 1,  9,  0 },
    { 1,  8,  5 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 0, 40, 41 },
    { 0, 41, 42 },
    { 0, 42, 43 },
    { 0, 43, 44 },
    { 0, 44, 45 },
    { 0, 45, 46 },
    { 0, 46, 47 },
    { 0, 47, 48 },
    { 0, 48, 49 },
    { 0, 49, 50 },
    { 0, 50, 51 },
    { 0, 51, 52 },
    { 0, 52, 53 },
    { 0, 53, 54 },
    { 0, 54, 55 },
    { 0, 55, 56 },
    { 0, 56, 57 },
    { 0, 57, 58 },
    { 1, 10,  3 },
    { 1,  2, 10 },
    { 1,  0,  9 },
    { 1, 11,  2 },
    { 1,  9,  4 },
    { 1,  6,  6 },
    { 1, 12,  1 },
    { 1,  4,  9 },
    { 1,  8,  6 },
    { 1,  1, 11 },
    { 1,  9,  5 },
    { 1, 10,  4 },
    { 1,  5,  7 },
    { 1,  7,  5 },
    { 1,  2, 11 },
    { 1,  1, 12 },
    { 1, 12,  2 },
    { 1, 11,  3 },
    { 1,  3, 10 },
    { 1,  5,  9 },
    { 1,  6,  7 },
    { 1,  8,  7 },
    { 1, 11,  4 },
    { 1,  0, 10 },
    { 1,  7,  6 },
    { 1, 12,  3 },
    { 1, 10,  0 },
    { 1, 10,  5 },
    { 1,  4, 10 },
    { 1,  6,  8 },
    { 1,  2, 12 },
    { 1,  9,  6 },
    { 1,  9,  7 },
    { 1,  4, 11 },
    { 1, 11,  0 },
    { 1,  6,  9 },
    { 1,  3, 11 },
    { 1,  5, 10 },
    { 0, 20, 21 },
    { 0, 21, 22 },
    { 0, 22, 23 },
    { 0, 23, 24 },
    { 0, 24, 25 },
    { 0, 25, 26 },
    { 0, 26, 27 },
    { 0, 27, 28 },
    { 0, 28, 29 },
    { 0, 29, 30 },
    { 0, 30, 31 },
    { 0, 31, 32 },
    { 0, 32, 33 },
    { 0, 33, 34 },
    { 0, 34, 35 },
    { 0, 35, 36 },
    { 0, 36, 37 },
    { 0, 37, 38 },
    { 0, 38, 39 },
    { 0, 39, 40 },
    { 1,  8,  8 },
    { 1,  7,  8 },
    { 1, 12,  5 },
    { 1,  3, 12 },
    { 1, 11,  5 },
    { 1,  7,  7 },
    { 1, 12,  4 },
    { 1, 11,  6 },
    { 1, 10,  6 },
    { 1,  4, 12 },
    { 1,  7,  9 },
    { 1,  5, 11 },
    { 1,  0, 11 },
    { 1, 12,  6 },
    { 1,  6, 10 },
    { 1, 12,  0 },
    { 1, 10,  7 },
    { 1,  5, 12 },
    { 1,  7, 10 },
    { 1,  9,  8 },
    { 1,  0, 12 },
    { 1, 11,  7 },
    { 1,  8,  9 },
    { 1,  9,  9 },
    { 1, 10,  8 },
    { 1,  7, 11 },
    { 1, 12,  7 },
    { 1,  6, 11 },
    { 1,  8, 11 },
    { 1, 11,  8 },
    { 1,  7, 12 },
    { 1,  6, 12 },
    { 0,  8,  9 },
    { 0,  9, 10 },
    { 0, 10, 11 },
    { 0, 11, 12 },
    { 0, 12, 13 },
    { 0, 13, 14 },
    { 0, 14, 15 },
    { 0, 15, 16 },
    { 1,  8, 10 },
    { 1, 10,  9 },
    { 1,  8, 12 },
    { 1,  9, 10 },
    { 1,  9, 11 },
    { 1,  9, 12 },
    { 1, 10, 11 },
    { 1, 12,  9 },
    { 1, 10, 10 },
    { 1, 11,  9 },
    { 1, 12,  8 },
    { 1, 11, 10 },
    { 1, 12, 10 },
    { 1, 12, 11 },
    { 0,  2,  3 },
    { 0,  3,  4 },
    { 1, 10, 12 },
    { 1, 11, 11 },
    { 1, 11, 12 },
    { 1, 12, 12 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 10
const hcb_struct_1 huffman_10_1[64]=
{
    {   0, 0 },
    {   0, 0 },
    {   0, 0 },
    {   0, 0 },
    {   1, 0 },
    {   1, 0 },
    {   1, 0 },
    {   1, 0 },
    {   2, 0 },
    {   2, 0 },
    {   2, 0 },
    {   2, 0 },
    {   3, 0 },
    {   3, 0 },
    {   4, 0 },
    {   4, 0 },
    {   5, 0 },
    {   5, 0 },
    {   6, 0 },
    {   6, 0 },
    {   7, 0 },
    {   7, 0 },
    {   8, 0 },
    {   8, 0 },
    {   9, 0 },
    {   9, 0 },
    {  10, 0 },
    {  10, 0 },
    {  11, 0 },
    {  12, 0 },
    {  13, 0 },
    {  14, 0 },
    {  15, 0 },
    {  16, 0 },
    {  17, 0 },
    {  18, 0 },
    {  19, 0 },
    {  20, 0 },
    {  21, 0 },
    {  22, 0 },
    {  23, 0 },
    {  24, 0 },
    {  25, 1 },
    {  27, 1 },
    {  29, 1 },
    {  31, 1 },
    {  33, 1 },
    {  35, 1 },
    {  37, 1 },
    {  39, 1 },
    {  41, 2 },
    {  45, 2 },
    {  49, 2 },
    {  53, 2 },
    {  57, 2 },
    {  61, 2 },
    {  65, 3 },
    {  73, 3 },
    {  81, 3 },
    {  89, 3 },
    {  97, 4 },
    { 113, 4 },
    { 129, 4 },
    { 145, 6 }
};

const hcb_struct huffman_10[210]=
{
    {  4,  1,  1 },
    {  4,  1,  2 },
    {  4,  2,  1 },
    {  5,  2,  2 },
    {  5,  1,  0 },
    {  5,  0,  1 },
    {  5,  1,  3 },
    {  5,  3,  2 },
    {  5,  3,  1 },
    {  5,  2,  3 },
    {  5,  3,  3 },
    {  6,  2,  0 },
    {  6,  0,  2 },
    {  6,  2,  4 },
    {  6,  4,  2 },
    {  6,  1,  4 },
    {  6,  4,  1 },
    {  6,  0,  0 },
    {  6,  4,  3 },
    {  6,  3,  4 },
    {  6,  3,  0 },
    {  6,  0,  3 },
    {  6,  4,  4 },
    {  6,  2,  5 },
    {  6,  5,  2 },
    {  7,  1,  5 },
    {  7,  5,  1 },
    {  7,  5,  3 },
    {  7,  3,  5 },
    {  7,  5,  4 },
    {  7,  4,  5 },
    {  7,  6,  2 },
    {  7,  2,  6 },
    {  7,  6,  3 },
    {  7,  4,  0 },
    {  7,  6,  1 },
    {  7,  0,  4 },
    {  7,  1,  6 },
    {  7,  3,  6 },
    {  7,  5,  5 },
    {  7,  6,  4 },
    {  7,  4,  6 },
    {  7,  4,  6 },
    {  8,  6,  5 },
    {  8,  7,  2 },
    {  8,  3,  7 },
    {  8,  2,  7 },
    {  8,  5,  6 },
    {  8,  8,  2 },
    {  8,  7,  3 },
    {  8,  5,  0 },
    {  8,  7,  1 },
    {  8,  0,  5 },
    {  8,  8,  1 },
    {  8,  1,  7 },
    {  8,  8,  3 },
    {  8,  7,  4 },
    {  8,  4,  7 },
    {  8,  2,  8 },
    {  8,  6,  6 },
    {  8,  7,  5 },
    {  8,  1,  8 },
    {  8,  3,  8 },
    {  8,  8,  4 },
    {  8,  4,  8 },
    {  8,  5,  7 },
    {  8,  5,  7 },
    {  8,  8,  5 },
    {  8,  8,  5 },
    {  8,  5,  8 },
    {  8,  5,  8 },
    {  9,  7,  6 },
    {  9,  6,  7 },
    {  9,  9,  2 },
    {  9,  6,  0 },
    {  9,  6,  8 },
    {  9,  9,  3 },
    {  9,  3,  9 },
    {  9,  9,  1 },
    {  9,  2,  9 },
    {  9,  0,  6 },
    {  9,  8,  6 },
    {  9,  9,  4 },
    {  9,  4,  9 },
    {  9, 10,  2 },
    {  9,  1,  9 },
    {  9,  7,  7 },
    {  9,  8,  7 },
    {  9,  9,  5 },
    {  9,  7,  8 },
    {  9, 10,  3 },
    {  9,  5,  9 },
    {  9, 10,  4 },
    {  9,  2, 10 },
    {  9, 10,  1 },
    {  9,  3, 10 },
    {  9,  9,  6 },
    {  9,  6,  9 },
    {  9,  6,  9 },
    {  9,  8,  0 },
    {  9,  8,  0 },
    {  9,  4, 10 },
    {  9,  4, 10 },
    {  9,  7,  0 },
    {  9,  7,  0 },
    {  9, 11,  2 },
    {  9, 11,  2 },
    { 10,  7,  9 },
    { 10, 11,  3 },
    { 10, 10,  6 },
    { 10,  1, 10 },
    { 10, 11,  1 },
    { 10,  9,  7 },
    { 10,  0,  7 },
    { 10,  8,  8 },
    { 10, 10,  5 },
    { 10,  3, 11 },
    { 10,  5, 10 },
    { 10,  8,  9 },
    { 10, 11,  5 },
    { 10,  0,  8 },
    { 10, 11,  4 },
    { 10,  2, 11 },
    { 10,  7, 10 },
    { 10,  6, 10 },
    { 10, 10,  7 },
    { 10,  4, 11 },
    { 10,  1, 11 },
    { 10, 12,  2 },
    { 10,  9,  8 },
    { 10, 12,  3 },
    { 10, 11,  6 },
    { 10,  5, 11 },
    { 10, 12,  4 },
    { 10, 11,  7 },
    { 10, 12,  5 },
    { 10,  3, 12 },
    { 10,  6, 11 },
    { 10,  9,  0 },
    { 10, 10,  8 },
    { 10, 10,  0 },
    { 10, 12,  1 },
    { 10,  0,  9 },
    { 10,  4, 12 },
    { 10,  9,  9 },
    { 10, 12,  6 },
    { 10, 12,  6 },
    { 10, 12,  6 },
    { 10, 12,  6 },
    { 10,  2, 12 },
    { 10,  2, 12 },
    { 10,  2, 12 },
    { 10,  2, 12 },
    { 10,  8, 10 },
    { 10,  8, 10 },
    { 10,  8, 10 },
    { 10,  8, 10 },
    { 11,  9, 10 },
    { 11,  9, 10 },
    { 11,  1, 12 },
    { 11,  1, 12 },
    { 11, 11,  8 },
    { 11, 11,  8 },
    { 11, 12,  7 },
    { 11, 12,  7 },
    { 11,  7, 11 },
    { 11,  7, 11 },
    { 11,  5, 12 },
    { 11,  5, 12 },
    { 11,  6, 12 },
    { 11,  6, 12 },
    { 11, 10,  9 },
    { 11, 10,  9 },
    { 11,  8, 11 },
    { 11,  8, 11 },
    { 11, 12,  8 },
    { 11, 12,  8 },
    { 11,  0, 10 },
    { 11,  0, 10 },
    { 11,  7, 12 },
    { 11,  7, 12 },
    { 11, 11,  0 },
    { 11, 11,  0 },
    { 11, 10, 10 },
    { 11, 10, 10 },
    { 11, 11,  9 },
    { 11, 11,  9 },
    { 11, 11, 10 },
    { 11, 11, 10 },
    { 11,  0, 11 },
    { 11,  0, 11 },
    { 11, 11, 11 },
    { 11, 11, 11 },
    { 11,  9, 11 },
    { 11,  9, 11 },
    { 11, 10, 11 },
    { 11, 10, 11 },
    { 11, 12,  0 },
    { 11, 12,  0 },
    { 11,  8, 12 },
    { 11,  8, 12 },
    { 12, 12,  9 },
    { 12, 10, 12 },
    { 12,  9, 12 },
    { 12, 11, 12 },
    { 12, 12, 11 },
    { 12,  0, 12 },
    { 12, 12, 10 },
    { 12, 12, 12 }
};

//---------------------------------------------------------------------------
// Spectrum Huffman Codebook 11
const hcb_struct_1 huffman_11_1[32]=
{
    {   0, 0 },
    {   0, 0 },
    {   1, 0 },
    {   1, 0 },
    {   2, 0 },
    {   3, 0 },
    {   4, 0 },
    {   5, 0 },
    {   6, 0 },
    {   7, 0 },
    {   8,  1 },
    {  10, 1 },
    {  12, 1 },
    {  14, 2 },
    {  18, 2 },
    {  22, 2 },
    {  26, 2 },
    {  30, 3 },
    {  38, 3 },
    {  46, 3 },
    {  54, 3 },
    {  62, 3 },
    {  70, 3 },
    {  78, 3 },
    {  86, 4 },
    { 102, 4 },
    { 118, 4 },
    { 134, 4 },
    { 150, 5 },
    { 182, 5 },
    { 214, 5 },
    { 246, 7 }
};

const hcb_struct huffman_11[374]=
{
    { 4,  0,  0 },
    { 4,  1,  1 },
    { 5, 16, 16 },
    { 5,  1,  0 },
    { 5,  0,  1 },
    { 5,  2,  1 },
    { 5,  1,  2 },
    { 5,  2,  2 },
    { 6,  1,  3 },
    { 6,  3,  1 },
    { 6,  3,  2 },
    { 6,  2,  0 },
    { 6,  2,  3 },
    { 6,  0,  2 },
    { 6,  3,  3 },
    { 6,  3,  3 },
    { 7,  4,  1 },
    { 7,  1,  4 },
    { 7,  4,  2 },
    { 7,  2,  4 },
    { 7,  4,  3 },
    { 7,  3,  4 },
    { 7,  3,  0 },
    { 7,  0,  3 },
    { 7,  5,  1 },
    { 7,  5,  2 },
    { 7,  2,  5 },
    { 7,  4,  4 },
    { 7,  1,  5 },
    { 7,  5,  3 },
    { 7,  3,  5 },
    { 7,  3,  5 },
    { 7,  5,  4 },
    { 7,  5,  4 },
    { 8,  4,  5 },
    { 8,  6,  2 },
    { 8,  2,  6 },
    { 8,  6,  1 },
    { 8,  6,  3 },
    { 8,  3,  6 },
    { 8,  1,  6 },
    { 8,  4, 16 },
    { 8,  3, 16 },
    { 8, 16,  5 },
    { 8, 16,  3 },
    { 8, 16,  4 },
    { 8,  6,  4 },
    { 8, 16,  6 },
    { 8,  4,  0 },
    { 8,  4,  6 },
    { 8,  0,  4 },
    { 8,  2, 16 },
    { 8,  5,  5 },
    { 8,  5, 16 },
    { 8, 16,  7 },
    { 8, 16,  2 },
    { 8, 16,  8 },
    { 8,  2,  7 },
    { 8,  7,  2 },
    { 8,  3,  7 },
    { 8,  6,  5 },
    { 8,  5,  6 },
    { 8,  6, 16 },
    { 8, 16, 10 },
    { 8,  7,  3 },
    { 8,  7,  1 },
    { 8, 16,  9 },
    { 8,  7, 16 },
    { 8,  1, 16 },
    { 8,  1,  7 },
    { 8,  4,  7 },
    { 8, 16, 11 },
    { 8,  7,  4 },
    { 8, 16, 12 },
    { 8,  8, 16 },
    { 8, 16,  1 },
    { 8,  6,  6 },
    { 8,  9, 16 },
    { 8,  2,  8 },
    { 8,  5,  7 },
    { 8, 10, 16 },
    { 8, 16, 13 },
    { 8,  8,  3 },
    { 8,  8,  2 },
    { 8,  3,  8 },
    { 8,  5,  0 },
    { 8, 16, 14 },
    { 8, 16, 14 },
    { 8, 11, 16 },
    { 8, 11, 16 },
    { 8,  7,  5 },
    { 8,  7,  5 },
    { 8,  4,  8 },
    { 8,  4,  8 },
    { 8,  6,  7 },
    { 8,  6,  7 },
    { 8,  7,  6 },
    { 8,  7,  6 },
    { 8,  0,  5 },
    { 8,  0,  5 },
    { 9,  8,  4 },
    { 9, 16, 15 },
    { 9, 12, 16 },
    { 9,  1,  8 },
    { 9,  8,  1 },
    { 9, 14, 16 },
    { 9,  5,  8 },
    { 9, 13, 16 },
    { 9,  3,  9 },
    { 9,  8,  5 },
    { 9,  7,  7 },
    { 9,  2,  9 },
    { 9,  8,  6 },
    { 9,  9,  2 },
    { 9,  9,  3 },
    { 9, 15, 16 },
    { 9,  4,  9 },
    { 9,  6,  8 },
    { 9,  6,  0 },
    { 9,  9,  4 },
    { 9,  5,  9 },
    { 9,  8,  7 },
    { 9,  7,  8 },
    { 9,  1,  9 },
    { 9, 10,  3 },
    { 9,  0,  6 },
    { 9, 10,  2 },
    { 9,  9,  1 },
    { 9,  9,  5 },
    { 9,  4, 10 },
    { 9,  2, 10 },
    { 9,  9,  6 },
    { 9,  3, 10 },
    { 9,  6,  9 },
    { 9, 10,  4 },
    { 9,  8,  8 },
    { 9, 10,  5 },
    { 9,  9,  7 },
    { 9, 11,  3 },
    { 9,  1, 10 },
    { 9,  7,  0 },
    { 9, 10,  6 },
    { 9,  7,  9 },
    { 9,  3, 11 },
    { 9,  5, 10 },
    { 9, 10,  1 },
    { 9,  4, 11 },
    { 9, 11,  2 },
    { 9, 13,  2 },
    { 9,  6, 10 },
    { 9, 13,  3 },
    { 9, 13,  3 },
    { 9,  2, 11 },
    { 9,  2, 11 },
    { 9, 16,  0 },
    { 9, 16,  0 },
    { 9,  5, 11 },
    { 9,  5, 11 },
    { 9, 11,  5 },
    { 9, 11,  5 },
    { 10, 11,  4 },
    { 10,  9,  8 },
    { 10,  7, 10 },
    { 10,  8,  9 },
    { 10,  0, 16 },
    { 10,  4, 13 },
    { 10,  0,  7 },
    { 10,  3, 13 },
    { 10, 11,  6 },
    { 10, 13,  1 },
    { 10, 13,  4 },
    { 10, 12,  3 },
    { 10,  2, 13 },
    { 10, 13,  5 },
    { 10,  8, 10 },
    { 10,  6, 11 },
    { 10, 10,  8 },
    { 10, 10,  7 },
    { 10, 14,  2 },
    { 10, 12,  4 },
    { 10,  1, 11 },
    { 10,  4, 12 },
    { 10, 11,  1 },
    { 10,  3, 12 },
    { 10,  1, 13 },
    { 10, 12,  2 },
    { 10,  7, 11 },
    { 10,  3, 14 },
    { 10,  5, 12 },
    { 10,  5, 13 },
    { 10, 14,  4 },
    { 10,  4, 14 },
    { 10, 11,  7 },
    { 10, 14,  3 },
    { 10, 12,  5 },
    { 10, 13,  6 },
    { 10, 12,  6 },
    { 10,  8,  0 },
    { 10, 11,  8 },
    { 10,  2, 12 },
    { 10,  9,  9 },
    { 10, 14,  5 },
    { 10,  6, 13 },
    { 10, 10, 10 },
    { 10, 15,  2 },
    { 10,  8, 11 },
    { 10,  9, 10 },
    { 10, 14,  6 },
    { 10, 10,  9 },
    { 10,  5, 14 },
    { 10, 11,  9 },
    { 10, 14,  1 },
    { 10,  2, 14 },
    { 10,  6, 12 },
    { 10,  1, 12 },
    { 10, 13,  8 },
    { 10,  0,  8 },
    { 10, 13,  7 },
    { 10,  7, 12 },
    { 10, 12,  7 },
    { 10,  7, 13 },
    { 10, 15,  3 },
    { 10, 12,  1 },
    { 10,  6, 14 },
    { 10,  2, 15 },
    { 10, 15,  5 },
    { 10, 15,  4 },
    { 10,  1, 14 },
    { 10,  9, 11 },
    { 10,  4, 15 },
    { 10, 14,  7 },
    { 10,  8, 13 },
    { 10, 13,  9 },
    { 10,  8, 12 },
    { 10,  5, 15 },
    { 10,  3, 15 },
    { 10, 10, 11 },
    { 10, 11, 10 },
    { 10, 12,  8 },
    { 10, 15,  6 },
    { 10, 15,  7 },
    { 10,  8, 14 },
    { 10, 15,  1 },
    { 10,  7, 14 },
    { 10,  9,  0 },
    { 10,  0,  9 },
    { 10,  9, 13 },
    { 10,  9, 13 },
    { 10,  9, 13 },
    { 10,  9, 13 },
    { 10,  9, 12 },
    { 10,  9, 12 },
    { 10,  9, 12 },
    { 10,  9, 12 },
    { 10, 12,  9 },
    { 10, 12,  9 },
    { 10, 12,  9 },
    { 10, 12,  9 },
    { 10, 14,  8 },
    { 10, 14,  8 },
    { 10, 14,  8 },
    { 10, 14,  8 },
    { 10, 10, 13 },
    { 10, 10, 13 },
    { 10, 10, 13 },
    { 10, 10, 13 },
    { 10, 14,  9 },
    { 10, 14,  9 },
    { 10, 14,  9 },
    { 10, 14,  9 },
    { 10, 12, 10 },
    { 10, 12, 10 },
    { 10, 12, 10 },
    { 10, 12, 10 },
    { 10,  6, 15 },
    { 10,  6, 15 },
    { 10,  6, 15 },
    { 10,  6, 15 },
    { 10,  7, 15 },
    { 10,  7, 15 },
    { 10,  7, 15 },
    { 10,  7, 15 },
    { 11,  9, 14 },
    { 11,  9, 14 },
    { 11, 15,  8 },
    { 11, 15,  8 },
    { 11, 11, 11 },
    { 11, 11, 11 },
    { 11, 11, 14 },
    { 11, 11, 14 },
    { 11,  1, 15 },
    { 11,  1, 15 },
    { 11, 10, 12 },
    { 11, 10, 12 },
    { 11, 10, 14 },
    { 11, 10, 14 },
    { 11, 13, 11 },
    { 11, 13, 11 },
    { 11, 13, 10 },
    { 11, 13, 10 },
    { 11, 11, 13 },
    { 11, 11, 13 },
    { 11, 11, 12 },
    { 11, 11, 12 },
    { 11,  8, 15 },
    { 11,  8, 15 },
    { 11, 14, 11 },
    { 11, 14, 11 },
    { 11, 13, 12 },
    { 11, 13, 12 },
    { 11, 12, 13 },
    { 11, 12, 13 },
    { 11, 15,  9 },
    { 11, 15,  9 },
    { 11, 14, 10 },
    { 11, 14, 10 },
    { 11, 10,  0 },
    { 11, 10,  0 },
    { 11, 12, 11 },
    { 11, 12, 11 },
    { 11,  9, 15 },
    { 11,  9, 15 },
    { 11,  0, 10 },
    { 11,  0, 10 },
    { 11, 12, 12 },
    { 11, 12, 12 },
    { 11, 11,  0 },
    { 11, 11,  0 },
    { 11, 12, 14 },
    { 11, 12, 14 },
    { 11, 10, 15 },
    { 11, 10, 15 },
    { 11, 13, 13 },
    { 11, 13, 13 },
    { 11,  0, 13 },
    { 11,  0, 13 },
    { 11, 14, 12 },
    { 11, 14, 12 },
    { 11, 15, 10 },
    { 11, 15, 10 },
    { 11, 15, 11 },
    { 11, 15, 11 },
    { 11, 11, 15 },
    { 11, 11, 15 },
    { 11, 14, 13 },
    { 11, 14, 13 },
    { 11, 13,  0 },
    { 11, 13,  0 },
    { 11,  0, 11 },
    { 11,  0, 11 },
    { 11, 13, 14 },
    { 11, 13, 14 },
    { 11, 15, 12 },
    { 11, 15, 12 },
    { 11, 15, 13 },
    { 11, 15, 13 },
    { 11, 12, 15 },
    { 11, 12, 15 },
    { 11, 14,  0 },
    { 11, 14,  0 },
    { 11, 14, 14 },
    { 11, 14, 14 },
    { 11, 13, 15 },
    { 11, 13, 15 },
    { 11, 12,  0 },
    { 11, 12,  0 },
    { 11, 14, 15 },
    { 11, 14, 15 },
    { 12,  0, 14 },
    { 12,  0, 12 },
    { 12, 15, 14 },
    { 12, 15,  0 },
    { 12,  0, 15 },
    { 12, 15, 15 },
};

//---------------------------------------------------------------------------
const int8u hcb_2step_Bytes[]=
{
    0,            5,            5, 0,            5, 0,            5, 0,           5, 0,             6,            5
};

const hcb_struct_1* hcb_2step[]=
{
    0, huffman_01_1, huffman_02_1, 0, huffman_04_1, 0, huffman_06_1, 0, huffman_08_1, 0, huffman_10_1, huffman_11_1
};

//---------------------------------------------------------------------------
const int16u hcb_table_size[]=
{
    0,        114,         86,        161,        185,       161,         126,        127,        83,         337,        210,        374
};
const hcb_struct* hcb_table[]=
{
    0, huffman_01, huffman_02, huffman_03, huffman_04, huffman_05, huffman_06, huffman_07, huffman_08, huffman_09, huffman_10, huffman_11
};

//***************************************************************************
// PRED_SFB_MAX
//***************************************************************************

//---------------------------------------------------------------------------
const int8u Aac_PRED_SFB_MAX[16]=
{
    33, 33, 38, 40, 40, 40, 41, 41, 37, 37, 37, 34, 64, 64, 64, 64
};

//***************************************************************************
// swb offsets
//***************************************************************************

//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_short_window_96[] =
{
    {
        12,
        {
               0,    4,    8,   12,   16,   20,   24,   32,   40,   48,
              64,   92,  128
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_short_window_64[] =
{
    {
        12,
        {
                0,    4,    8,   12,   16,   20,   24,   32,   40,   48,
                64,   92,  128
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_short_window_48[] =
{
    {
        14,
        {
               0,    4,    8,   12,   16,   20,   28,   36,   44,   56,
              68,   80,   96,  112,  128
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_short_window_24[] =
{
    {
        15,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   36,   44,
              52,   64,   76,   92,  108,  128
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_short_window_16[] =
{
    {
        15,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   32,   40,
              48,   60,   72,   88,  108,  128
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_short_window_8[] =
{
    {
        15,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   36,   44,
              52,   60,   72,   88,  108,  128
        }
    }
};

//---------------------------------------------------------------------------
const  Aac_swb_offset* Aac_swb_offset_short_window[13] =
{
    Aac_swb_short_window_96,       //96000
    Aac_swb_short_window_96,       //88200
    Aac_swb_short_window_64,       //64000
    Aac_swb_short_window_48,       //48000
    Aac_swb_short_window_48,       //44100
    Aac_swb_short_window_48,       //32000
    Aac_swb_short_window_24,       //24000
    Aac_swb_short_window_24,       //22050
    Aac_swb_short_window_16,       //16000
    Aac_swb_short_window_16,       //12000
    Aac_swb_short_window_16,       //11025
    Aac_swb_short_window_8,        //8000
    Aac_swb_short_window_8         //7350
};

//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_96[]=
{
    {
        41,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
              40,   44,   48,   52,   56,   64,   72,   80,   88,   96,
             108,  120,  132,  144,  156,  172,  188,  212,  240,  276,
             320,  384,  448,  512,  576,  640,  704,  768,  832,  896,
             960,  1024
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_64[]=
{
    {
        47,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
              40,   44,   48,   52,   56,   64,   72,   80,   88,  100,
             112,  124,  140,  156,  172,  192,  216,  240,  268,  304,
             344,  384,  424,  464,  504,  544,  584,  624,  664,  704,
             744,  784,  824,  864,  904,  944,  984, 1024
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_48[]=
{
    {
        49,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
              40,   48,   56,   64,   72,   80,   88,   96,  108,  120,
             132,  144,  160,  176,  196,  216,  240,  264,  292,  320,
             352,  384,  416,  448,  480,  512,  544,  576,  608,  640,
             672,  704,  736,  768,  800,  832,  864,  896,  928, 1024
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_32[]=
{
    {
        51,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
              40,   48,   56,   64,   72,   80,   88,   96,  108,  120,
             132,  144,  160,  176,  196,  216,  240,  264,  292,  320,
             352,  384,  416,  448,  480,  512,  544,  576,  608,  640,
             672,  704,  736,  768,  800,  832,  864,  896,  928,  960,
             992, 1024
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_24[]=
{
    {
        47,
        {
               0,    4,    8,   12,   16,   20,   24,   28,   32,   36,
              40,   44,   52,   60,   68,   76,   84,   92,  100,  108,
             116,  124,  136,  148,  160,  172,  188,  204,  220,  240,
             260,  284,  308,  336,  364,  396,  432,  468,  508,  552,
             600,  652,  704,  768,  832,  896,  960, 1024
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_16[]=
{
    {
        43,
        {
               0,    8,   16,   24,   32,   40,   48,   56,   64,   72,
              80,   88,  100,  112,  124,  136,  148,  160,  172,  184,
             196,  212,  228,  244,  260,  280,  300,  320,  344,  368,
             396,  424,  456,  492,  532,  572,  616,  664,  716,  772,
             832,  896,  960, 1024
        }
    }
};
//---------------------------------------------------------------------------
const Aac_swb_offset Aac_swb_long_window_8[]=
{
    {
        40,
        {
               0,   12,   24,   36,   48,   60,   72,   84,   96,  108,
             120,  132,  144,  156,  172,  188,  204,  220,  236,  252,
             268,  288,  308,  328,  348,  372,  396,  420,  448,  476,
             508,  544,  580,  620,  664,  712,  764,  820,  880,  944,
            1024
        }
    }
};

//---------------------------------------------------------------------------
const Aac_swb_offset* Aac_swb_offset_long_window[13]=
{
    Aac_swb_long_window_96,        //96000
    Aac_swb_long_window_96,        //88200
    Aac_swb_long_window_64,        //64000
    Aac_swb_long_window_48,        //48000
    Aac_swb_long_window_48,        //44100
    Aac_swb_long_window_32,        //32000
    Aac_swb_long_window_24,        //24000
    Aac_swb_long_window_24,        //22050
    Aac_swb_long_window_16,        //16000
    Aac_swb_long_window_16,        //12000
    Aac_swb_long_window_16,        //11025
    Aac_swb_long_window_8,         //8000
    Aac_swb_long_window_8          //7350
};

//***************************************************************************
// Infos
//***************************************************************************

//---------------------------------------------------------------------------
extern const int32u Aac_sampling_frequency[];
extern const char* Aac_audioObjectType(int8u audioObjectType);
extern const char* Aac_Format_Profile(int8u ID);
extern int8u Aac_Channels_Get(int8u ChannelLayout);

//---------------------------------------------------------------------------
static const char* Aac_id_syn_ele[8]=
{
    "SCE - single_channel_element",
    "CPE - channel_pair_element",
    "CCE - coupling_channel_element",
    "LFE - lfe_channel_element",
    "DSE - data_stream_element",
    "PCE - program_config_element",
    "FIL - fill_element",
    "END - End"
};

//---------------------------------------------------------------------------
static const char* Aac_window_sequence[4]=
{
    "ONLY_LONG_SEQUENCE",
    "LONG_START_SEQUENCE",
    "EIGHT_SHORT_SEQUENCE",
    "LONG_STOP_SEQUENCE"
};

//***************************************************************************
// Elements - Decoder configuration
//***************************************************************************

//---------------------------------------------------------------------------
void File_Aac::GASpecificConfig ()
{
    //Parsing
    Element_Begin1("GASpecificConfig");
    bool frameLengthFlag, dependsOnCoreCoder, extensionFlag;
    Get_SB (   frameLengthFlag,                                 "frameLengthFlag");
    frame_length=frameLengthFlag==0?1024:960; Param_Info2(frame_length, " bytes");
    Get_SB (   dependsOnCoreCoder,                              "dependsOnCoreCoder");
    if (dependsOnCoreCoder)
        Skip_S2(14,                                             "coreCoderDelay");
    Get_SB (   extensionFlag,                                   "extensionFlag");
    if (channelConfiguration==0)
        program_config_element();
    if (audioObjectType==06 || audioObjectType==20)
        Skip_S1(3,                                              "layerNr");
    if (extensionFlag)
    {
        bool extensionFlag3;
        if (audioObjectType==22)
        {
            Skip_S1( 5,                                         "numOfSubFrame");
            Skip_S2(11,                                         "layer_length");
        }
        if (audioObjectType==17
         || audioObjectType==19
         || audioObjectType==20
         || audioObjectType==23)
        {
            Skip_SB(                                            "aacSectionDataResilienceFlag");
            Skip_SB(                                            "aacScalefactorDataResilienceFlag");
            Skip_SB(                                            "aacSpectralDataResilienceFlag");
        }
        Get_SB (   extensionFlag3,                              "extensionFlag3");
        if (extensionFlag3)
        {
            Skip_BS(Data_BS_Remain(),                           "Not implemented");
        }
    }
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::program_config_element()
{
    Element_Begin1("program_config_element");
    Ztring comment_field_data;
    int8u Channels=0, Channels_Front=0, Channels_Side=0, Channels_Back=0, Channels_LFE=0;
    int8u num_front_channel_elements, num_side_channel_elements, num_back_channel_elements, num_lfe_channel_elements, num_assoc_data_elements, num_valid_cc_elements, comment_field_bytes;
    int8u audioObjectType_Temp, sampling_frequency_index_Temp;
    Skip_S1(4,                                                  "element_instance_tag");
    Get_S1 (2, audioObjectType_Temp,                            "object_type"); audioObjectType_Temp++; Param_Info1(Aac_audioObjectType(audioObjectType_Temp));
    Get_S1 (4, sampling_frequency_index_Temp,                   "sampling_frequency_index"); Param_Info1(Aac_sampling_frequency[sampling_frequency_index_Temp]);
    Get_S1 (4, num_front_channel_elements,                      "num_front_channel_elements");
    Get_S1 (4, num_side_channel_elements,                       "num_side_channel_elements");
    Get_S1 (4, num_back_channel_elements,                       "num_back_channel_elements");
    Get_S1 (2, num_lfe_channel_elements,                        "num_lfe_channel_elements");
    Get_S1 (3, num_assoc_data_elements,                         "num_assoc_data_elements");
    Get_S1 (4, num_valid_cc_elements,                           "num_valid_cc_elements");
    TEST_SB_SKIP(                                               "mono_mixdown_present");
        Skip_S1(4,                                              "mono_mixdown_element_number");
    TEST_SB_END();
    TEST_SB_SKIP(                                               "stereo_mixdown_present");
        Skip_S1(4,                                              "stereo_mixdown_element_number");
    TEST_SB_END();
    TEST_SB_SKIP(                                               "matrix_mixdown_idx_present");
        Skip_S1(2,                                              "matrix_mixdown_idx");
        Skip_SB(                                                "pseudo_surround_enable");
    TEST_SB_END();
    bool front1_element_is_cpe=false;
    if (!num_side_channel_elements && num_back_channel_elements && num_back_channel_elements<3) // Hack: e.g. in case of 5.1, 7.1
    {
        num_side_channel_elements=1;
        num_back_channel_elements--;
    }
    for (int8u Pos=0; Pos<num_front_channel_elements; Pos++)
    {
        Element_Begin1("front_element");
        bool front_element_is_cpe;
        Get_SB (   front_element_is_cpe,                        "front_element_is_cpe");
        Skip_S1(4,                                              "front_element_tag_select");
        if (front_element_is_cpe)
        {
            Channels_Front+=2;
            Channels+=2;
            if (Pos==0)
                front1_element_is_cpe=true;
        }
        else
        {
            Channels_Front++;
            Channels++;
        }
        Element_End0();
    }
    for (int8u Pos=0; Pos<num_side_channel_elements; Pos++)
    {
        Element_Begin1("side_element");
        bool side_element_is_cpe;
        Get_SB (   side_element_is_cpe,                         "side_element_is_cpe");
        Skip_S1(4,                                              "side_element_tag_select");
        if (side_element_is_cpe)
        {
            Channels_Side+=2;
            Channels+=2;
        }
        else
        {
            Channels_Side++;
            Channels++;
        }
        Element_End0();
    }
    for (int8u Pos=0; Pos<num_back_channel_elements; Pos++)
    {
        Element_Begin1("back_element");
        bool back_element_is_cpe;
        Get_SB (   back_element_is_cpe,                         "back_element_is_cpe");
        Skip_S1(4,                                              "back_element_tag_select");
        if (back_element_is_cpe)
        {
            Channels_Back+=2;
            Channels+=2;
        }
        else
        {
            Channels_Back++;
            Channels++;
        }
        Element_End0();
    }
    for (int8u Pos=0; Pos<num_lfe_channel_elements; Pos++)
    {
        Element_Begin1("lfe_element");
        Skip_S1(4,                                              "lfe_element_tag_select");
        Channels_LFE++;
        Channels++;
        Element_End0();
    }
    for (int8u Pos=0; Pos<num_assoc_data_elements; Pos++)
    {
        Element_Begin1("assoc_data_element");
        Skip_S1(4,                                              "assoc_data_element_tag_select");
        Element_End0();
    }
    for (int8u Pos=0; Pos<num_valid_cc_elements; Pos++)
    {
        Element_Begin1("valid_cc_element");
        Skip_SB(                                                "cc_element_is_ind_sw");
        Skip_S1(4,                                              "valid_cc_element_tag_select");
        Element_End0();
    }
    BS_End(); //Byte align
    Get_B1 (comment_field_bytes,                                "comment_field_bytes");
    if (comment_field_bytes)
        Get_UTF8(comment_field_bytes, comment_field_data,       "comment_field_data");
    BS_Begin(); //The stream needs continuity in the bitstream
    Element_End0();

    //Filling
    Ztring Channels_Positions, Channels_Positions2, ChannelLayout;
    switch (Channels_Front)
    {
        case  0 : break;
        case  1 : Channels_Positions+=__T("Front: C"); ChannelLayout+=__T("C "); break;
        case  2 : Channels_Positions+=__T("Front: L R"); ChannelLayout+=__T("L R "); break;
        case  3 : Channels_Positions+=__T("Front: L C R"); ChannelLayout+=num_front_channel_elements==2?(front1_element_is_cpe?__T("L R C "):__T("C L R ")):__T("? ? ? "); break;
        case  5 : Channels_Positions+=__T("Front: L Lc C Rc R"); ChannelLayout+=num_front_channel_elements==3?(front1_element_is_cpe?__T("Lc Rc C L R "):__T("C Lc Rc L R ")):__T("? ? ? ? ? "); break;
        default : Channels_Positions+=__T("Front:"); Channels_Positions+=Ztring::ToZtring(Channels_Side); for (size_t i=0; i<Channels_Front; i++) ChannelLayout+=__T("? "); //Which config?
    }
    switch (Channels_Side)
    {
        case  0 : break;
        case  1 : Channels_Positions+=__T(", Side: C"); ChannelLayout+=__T("Cs "); break;
        case  2 : Channels_Positions+=__T(", Side: L R"); ChannelLayout+=__T("Ls Rs "); break;
        case  3 : Channels_Positions+=__T(", Side: L C R"); ChannelLayout+=__T("? ? ? "); break;
        default : Channels_Positions+=__T(", Side: "); Channels_Positions+=Ztring::ToZtring(Channels_Side); for (size_t i=0; i< Channels_Side; i++) ChannelLayout+=__T("? "); //Which config?
    }
    switch (Channels_Back)
    {
        case  0 : break;
        case  1 : Channels_Positions+=__T(", Back: C"); ChannelLayout+=__T("Cs "); break;
        case  2 : Channels_Positions+=__T(", Back: L R"); ChannelLayout+=__T("Lrs Rrs "); break;
        case  3 : Channels_Positions+=__T(", Back: L C R"); ChannelLayout+=__T("Lrs Rrs Cs "); break;
        default : Channels_Positions+=__T(", Back: "); Channels_Positions+=Ztring::ToZtring(Channels_Back); for (size_t i=0; i< Channels_Back; i++) ChannelLayout+=__T("? "); //Which config?
    }
    switch (Channels_LFE)
    {
        case  0 : break;
        case  1 : Channels_Positions+=__T(", LFE"); ChannelLayout+=__T("LFE "); break;
        case  2 : Channels_Positions+=__T(", LFE LFE2"); ChannelLayout+=__T("LFE LFE2"); break;
        default : Channels_Positions+=__T(", LFE: "); Channels_Positions+=Ztring::ToZtring(Channels_LFE); ChannelLayout+=__T("LFE "); for (size_t i=1; i<Channels_LFE; i++) ChannelLayout+=__T("? "); //Which config?
    }
    Channels_Positions2=Ztring::ToZtring(Channels_Front)+__T('/')
                       +Ztring::ToZtring(Channels_Side)+__T('/')
                       +Ztring::ToZtring(Channels_Back)
                       +(Channels_LFE?__T(".1"):__T(""));
    if (!ChannelLayout.empty())
        ChannelLayout.resize(ChannelLayout.size()-1);

    FILLING_BEGIN();
        //Integrity test
        if (Aac_sampling_frequency[sampling_frequency_index_Temp]==0 || Channels>24) // TODO: full_2023548870.mp4 is buggy
        {
            Trusted_IsNot("sampling frequency / channels");
            Skip_BS(Data_BS_Remain(),                               "(Unknown frequency)");
            return;
        }

        if (audioObjectType==(int8u)-1)
            audioObjectType=audioObjectType_Temp;
        if (sampling_frequency_index==(int8u)-1)
            sampling_frequency_index=sampling_frequency_index_Temp;

        Infos_General["Comment"]=comment_field_data;

        Infos["CodecID"].From_Number(audioObjectType);
        Infos["Format"].From_UTF8("AAC");
        Infos["Format_Profile"].From_UTF8(Aac_Format_Profile(audioObjectType));
        Infos["Codec"].From_UTF8(Aac_audioObjectType(audioObjectType));
        Infos["SamplingRate"].From_Number(Aac_sampling_frequency[sampling_frequency_index]);
        Infos["Channel(s)"].From_Number(Channels);
        Infos["ChannelPositions"]=Channels_Positions;
        Infos["ChannelPositions/String2"]=Channels_Positions2;
        Infos["ChannelLayout"]=ChannelLayout;

        if (!Infos["Format_Settings_SBR"].empty())
        {
            const Ztring SamplingRate=Infos["SamplingRate"];
            Infos["Format_Profile"]=__T("HE-AAC");
            Infos["SamplingRate"].From_Number((extension_sampling_frequency_index==(int8u)-1)?(Frequency_b*2):extension_sampling_frequency, 10);
            if (MediaInfoLib::Config.LegacyStreamDisplay_Get())
            {
                Infos["Format_Profile"]+=__T(" / LC");
                Infos["SamplingRate"]+=__T(" / ")+SamplingRate;
            }
            Infos["Format_Settings"]=__T("NBC"); // "Not Backward Compatible"
            Infos["Format_Settings_SBR"]=__T("Yes (NBC)"); // "Not Backward Compatible"
            Infos["Codec"]=Ztring().From_UTF8(Aac_audioObjectType(audioObjectType))+__T("-SBR");
        }

        if (!Infos["Format_Settings_PS"].empty())
            FillInfosHEAACv2(__T("NBC"));
    FILLING_END();
}

//***************************************************************************
// Elements - GA bitstream
//***************************************************************************

//---------------------------------------------------------------------------
void File_Aac::payload(size_t BitsNotIncluded)
{
    //Parsing
    switch (audioObjectType)
    {
        case   2: raw_data_block(); break;
        #if MEDIAINFO_TRACE || MEDIAINFO_CONFORMANCE
        case  42: UsacFrame(BitsNotIncluded); break;
        #endif //MEDIAINFO_TRACE || MEDIAINFO_CONFORMANCE
        default:
            Skip_BS(Data_BS_Remain()-(BitsNotIncluded!=-1?BitsNotIncluded:0), "payload");
            Frame_Count_Valid=Frame_Count;
    }
}

//---------------------------------------------------------------------------
void File_Aac::raw_data_block()
{
    if ((ParseCompletely<1 && Status[IsFilled])
     ||  ParseCompletely<0)
    {
        Skip_BS(Data_BS_Remain(),                               "raw_data_block");
        return;
    }

    if (sampling_frequency_index>=13)
    {
        Trusted_IsNot("(Problem)");
        Skip_BS(Data_BS_Remain(),                               "(Problem)");
        return;
    }

    Element_Begin1("raw_data_block");
    raw_data_block_Pos=0;
    ChannelPos_Temp=0;
    int8u id_syn_ele=0, id_syn_ele_Previous;
    bool HasEnd=false;
    do
    {
        Element_Begin0();
        id_syn_ele_Previous=id_syn_ele;
        Get_S1 (3, id_syn_ele,                                  "id_syn_ele"); Param_Info1(Aac_id_syn_ele[id_syn_ele]); Element_Name(Aac_id_syn_ele[id_syn_ele]);

        #if MEDIAINFO_TRACE
            bool Trace_Activated_Save=Trace_Activated;
            if (id_syn_ele!=0x05)
                Trace_Activated=false; //It is too big, disabling trace for now for full AAC parsing
        #endif //MEDIAINFO_TRACE

        switch (id_syn_ele)
        {
            case 0x00 : single_channel_element();           break; //ID_SCE
            case 0x01 : channel_pair_element();             break; //ID_CPE
            case 0x02 : coupling_channel_element();         break; //ID_CCE
            case 0x03 : lfe_channel_element();              break; //ID_LFE
            case 0x04 : data_stream_element();              break; //ID_DSE
            case 0x05 : program_config_element();           break; //ID_PCE
            case 0x06 : fill_element(id_syn_ele_Previous);  break; //ID_FIL
            case 0x07 :                                     break; //ID_END
            default   :                                          ; //Can not happen
        }
        if (id_syn_ele<4) // All "content" element
            raw_data_block_Pos++;

        #if MEDIAINFO_TRACE
            Trace_Activated=Trace_Activated_Save;
        #endif //MEDIAINFO_TRACE

        Element_End0();

        if (id_syn_ele==0x07)
        {
            HasEnd=true;
            break;
        }
    }
    while(Element_IsOK() && Data_BS_Remain());
    if (Element_IsOK() && id_syn_ele!=0x07)
        Trusted_IsNot("Not ending by END element");
    if (Element_IsOK() && Data_BS_Remain()%8)
        Skip_S1(Data_BS_Remain()%8,                             "byte_alignment");
    if ((!HasEnd || (ChannelCount_Temp && ChannelPos_Temp!=ChannelCount_Temp)) && Retrieve_Const(Stream_Audio, 0, "Errors").empty())
    {
        if (!HasEnd)
            Fill(Stream_Audio, 0, "Errors", "Missing ID_END");
        if (ChannelCount_Temp && ChannelPos_Temp!=ChannelCount_Temp)
            Fill(Stream_Audio, 0, "Errors", "Incoherent count of channels");
    }
    if (IsSub && Mode==Mode_payload && (!Trusted_Get() || !HasEnd))
        RanOutOfData("AAC");
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::single_channel_element()
{
    //Parsing
    Skip_S1 (4,                                                 "element_instance_tag");
    individual_channel_stream(false, false);
}

//---------------------------------------------------------------------------
void File_Aac::channel_pair_element()
{
    //Parsing
    Skip_S1(4,                                                  "element_instance_tag");
    Get_SB (common_window,                                      "common_window");
    if (common_window)
    {
        int8u ms_mask_present;
        ics_info();
        Get_S1(2, ms_mask_present,                              "ms_mask_present");
        if (ms_mask_present==1)
        {
            Element_Begin1("ms_mask");
            for (int8u g=0; g<num_window_groups; g++)
            {
                Element_Begin1("window");
                for (int8u sfb=0; sfb<max_sfb; sfb++)
                    Skip_SB(                                    "ms_used[g][sfb]");
                Element_End0();
            }
            Element_End0();
        }
    }
    individual_channel_stream(common_window, false);
    if (!Element_IsOK())
    {
        Skip_BS(Data_BS_Remain(),                               "(Problem)");
        return;
    }
    individual_channel_stream(common_window, false);
}

//---------------------------------------------------------------------------
void File_Aac::ics_info()
{
    //Parsing
    Element_Begin1("ics_info");
    Skip_SB(                                                    "ics_reserved_bit");
    Get_S1 (2, window_sequence,                                 "window_sequence"); Param_Info1(Aac_window_sequence[window_sequence]);
    Skip_SB(                                                    "window_shape");
    if (window_sequence==2) //EIGHT_SHORT_SEQUENCE
    {
        Get_S1 (4, max_sfb,                                     "max_sfb");
        Get_S1 (7, scale_factor_grouping,                       "scale_factor_grouping");
    }
    else
    {
        bool predictor_data_present;
        Get_S1 (6, max_sfb,                                     "max_sfb");
        Get_SB (   predictor_data_present,                      "predictor_data_present");
        if (predictor_data_present)
        {
            if (audioObjectType==1) //AAC Main
            {
                bool predictor_reset;
                Get_SB (predictor_reset,                        "predictor_reset");
                if (predictor_reset)
                    Skip_S1(5,                                  "predictor_reset_group_number");
                int8u PRED_SFB_MAX=max_sfb;
                if (PRED_SFB_MAX>Aac_PRED_SFB_MAX[sampling_frequency_index])
                    PRED_SFB_MAX=Aac_PRED_SFB_MAX[sampling_frequency_index];
                for (int8u sfb=0; sfb<PRED_SFB_MAX; sfb++)
                    Skip_SB(                                    "prediction_used[sfb]");
            }
            else
            {
                bool ltp_data_present;
                Get_SB (ltp_data_present,                       "ltp_data_present");
                if (ltp_data_present)
                    ltp_data();
                if (common_window)
                {
                    Get_SB (ltp_data_present,                   "ltp_data_present");
                    if (ltp_data_present)
                        ltp_data();
                }
            }
        }
    }
    Element_End0();

    //Calculation of windows
    switch (window_sequence)
    {
        case 0 :    //ONLY_LONG_SEQUENCE
        case 1 :    //LONG_START_SEQUENCE
        case 3 :    //LONG_STOP_SEQUENCE
                    num_windows=1;
                    num_window_groups=1;
                    window_group_length[0]=1;
                    num_swb=Aac_swb_offset_long_window[sampling_frequency_index]->num_swb;
                    for (int8u i=0; i<num_swb+1; i++)
                    {
                        if (Aac_swb_offset_long_window[sampling_frequency_index]->swb_offset[i]<frame_length)
                            swb_offset[i]=Aac_swb_offset_long_window[sampling_frequency_index]->swb_offset[i];
                        else
                            swb_offset[i]=frame_length;
                        sect_sfb_offset[0][i]=swb_offset[i];
                    }
                    break;
        case 2 :    //EIGHT_SHORT_SEQUENCE
                    num_windows=8;
                    num_window_groups=1;
                    window_group_length[0]=1;
                    num_swb=Aac_swb_offset_short_window[sampling_frequency_index]->num_swb;
                    for (int8u i=0; i<num_swb + 1; i++)
                        swb_offset[i] = Aac_swb_offset_short_window[sampling_frequency_index]->swb_offset[i];
                    swb_offset[num_swb] = frame_length/8;
                    for (int8u i=0; i<num_windows-1; i++)
                    {
                        if (!(scale_factor_grouping&(1<<(6-i))))
                        {
                            num_window_groups++;
                            window_group_length[num_window_groups-1]=1;
                        }
                        else
                            window_group_length[num_window_groups-1]++;
                    }
                    for (int g = 0; g < num_window_groups; g++)
                    {
                        int8u sect_sfb = 0;
                        int16u offset = 0;
                        for (int8u i=0; i<num_swb; i++)
                        {
                            int16u width = Aac_swb_offset_short_window[sampling_frequency_index]->swb_offset[i+1] - Aac_swb_offset_short_window[sampling_frequency_index]->swb_offset[i];
                            width *= window_group_length[g];
                            sect_sfb_offset[g][sect_sfb++] = offset;
                            offset += width;
                        }
                        sect_sfb_offset[g][sect_sfb] = offset;
                    }
                    break;
        default:    ;
    }
}

//---------------------------------------------------------------------------
void File_Aac::pulse_data()
{
    //Parsing
    int8u number_pulse;
    Get_S1(2,number_pulse,                                      "number_pulse");
    Skip_S1(6,                                                  "pulse_start_sfb");
    for (int i = 0; i < number_pulse+1; i++)
    {
        Skip_S1(5,                                              "pulse_offset[i]");
        Skip_S1(4,                                              "pulse_amp[i]");
    }
}

//---------------------------------------------------------------------------
void File_Aac::coupling_channel_element()
{
    //Parsing
    int8u num_coupled_elements;
    bool ind_sw_cce_flag;
    Skip_S1(4,                                                  "element_instance_tag");
    Get_SB (   ind_sw_cce_flag,                                 "ind_sw_cce_flag");
    Get_S1 (3, num_coupled_elements,                            "num_coupled_elements");
    size_t num_gain_element_lists=0;
    for (int8u c=0; c<num_coupled_elements+1; c++)
    {
        num_gain_element_lists++;
        bool cc_target_is_cpe;
        Get_SB (   cc_target_is_cpe,                            "cc_target_is_cpe[c]");
        Skip_S1(4,                                              "cc_target_tag_select[c]");
        if (cc_target_is_cpe)
        {
            bool cc_l, cc_r;
            Get_SB (cc_l,                                       "cc_l[c]");
            Get_SB (cc_r,                                       "cc_r[c]");
            if (cc_l && cc_r)
                num_gain_element_lists++;
        }
    }
    Skip_SB(                                                    "cc_domain");
    Skip_SB(                                                    "gain_element_sign");
    Skip_S1(2,                                                  "gain_element_scale");
    individual_channel_stream(false, false);
    if (!Element_IsOK())
    {
        Skip_BS(Data_BS_Remain(),                               "(Problem)");
        return;
    }
    bool cge;
    for (size_t c=1; c<num_gain_element_lists; c++)
    {
        if (ind_sw_cce_flag)
            cge = true;
        else
            Get_SB (cge,                                        "common_gain_element_present[c]");
        if (cge)
            hcod_sf(                                            "hcod_sf[common_gain_element[c]]");
        else
        {
            for (int g = 0; g < num_window_groups; g++)
            {
                for (int sfb=0; sfb<max_sfb; sfb++)
                {
                    if (sfb_cb[g][sfb]) //Not ZERO_HCB
                        hcod_sf(                                "hcod_sf[dpcm_gain_element[c][g][sfb]]");
                }
            }
        }
    }
}

//---------------------------------------------------------------------------
void File_Aac::lfe_channel_element()
{
    Skip_S1(4,                                                  "element_instance_tag");
    individual_channel_stream(false, false);
}

//---------------------------------------------------------------------------
void File_Aac::data_stream_element()
{
    bool data_byte_align_flag;
    int16u cnt;
    int8u  count;
    Skip_S1(4,                                                  "element_instance_tag");
    Get_SB (   data_byte_align_flag,                            "data_byte_align_flag");
    Get_S1 (8, count,                                           "count");
    cnt=count;
    if (cnt==255)
    {
        Get_S1(8, count,                                        "esc_count");
        cnt+=count;
    }
    if (data_byte_align_flag)
    {
        if (Data_BS_Remain()%8)
            Skip_S1(Data_BS_Remain()%8,                         "byte_alignment");
    }
    Element_Begin1("data_stream_byte[element_instance_tag]");
    for (int16u i=0; i<cnt; i++)
        Skip_S1(8,                                                "[i]");
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::fill_element(int8u id_syn_ele)
{
    //Parsing
    int8u  count;
    Get_S1 (4, count,                                           "count");
    size_t cnt=count;
    if (count==15)
    {
        int8u esc_count;
        Get_S1 (8, esc_count,                                   "esc_count");
        cnt+=esc_count-1;
    }
    if (cnt)
    {
        if (Data_BS_Remain()>=8*cnt)
        {
            size_t End=Data_BS_Remain()-8*cnt;
            extension_payload(End, id_syn_ele);
        }
        else
            Skip_BS(Data_BS_Remain(),                           "(Error)");
    }
}

//---------------------------------------------------------------------------
void File_Aac::gain_control_data()
{
    if (Retrieve_Const(Stream_Audio, 0, "GainControl_Present").empty())
    {
        Fill(Stream_Audio, 0, "GainControl_Present", "Yes");
        Fill_SetOptions(Stream_Audio, 0, "GainControl_Present", "N NTY");
    }

    int8u max_band, adjust_num, aloc_bits, aloc_bits0;
    int8u wd_max=0;
    switch(window_sequence)
    {
        case 0 :    //ONLY_LONG_SEQUENCE
                    wd_max = 1;
                    aloc_bits0 = 5;
                    aloc_bits = 5;
                    break;
        case 1 :    //LONG_START_SEQUENCE
                    wd_max = 2;
                    aloc_bits0 = 4;
                    aloc_bits = 2;
                    break;
        case 2 :    //EIGHT_SHORT_SEQUENCE
                    wd_max = 8;
                    aloc_bits0 = 2;
                    aloc_bits = 2;
                    break;
        case 3 :    //LONG_STOP_SEQUENCE
                    wd_max = 2;
                    aloc_bits0 = 4;
                    aloc_bits = 5;
                    break;
        default:    return; //Never happens but makes compiler happy
    }
    Get_S1 (2, max_band,                                        "max_band");
    for (int8u bd=1; bd<=max_band; bd++)
    {
        for (int8u wd=0; wd<wd_max; wd++)
        {
            Get_S1(3, adjust_num,                               "adjust_num[bd][wd]");
            for (int8u ad=0; ad<adjust_num; ad++)
            {
                Skip_S1(4,                                      "alevcode[bd][wd][ad]");
                Skip_S1(wd==0?aloc_bits0:aloc_bits,             "aloccode[bd][wd][ad]");
            }
        }
    }
}

//***************************************************************************
// Elements - Subsidiary
//***************************************************************************

//---------------------------------------------------------------------------
void File_Aac::individual_channel_stream (bool common_window, bool scale_flag)
{
    Element_Begin1("individual_channel_stream");
    Skip_S1(8,                                                  "global_gain");
    if (!common_window && !scale_flag)
        ics_info();
    if (!Element_IsOK())
    {
        Skip_BS(Data_BS_Remain(),                               "(Problem)");
        Element_End0();
        return;
    }
   section_data();
    if (!Element_IsOK())
    {
        Skip_BS(Data_BS_Remain(), "?");
        Element_End0();
        return;
    }
    scale_factor_data();
    if (!Element_IsOK())
    {
        Skip_BS(Data_BS_Remain(),                               "(Problem)");
        Element_End0();
        return;
    }
    if (!scale_flag)
    {
        bool pulse_data_present;
        Get_SB (pulse_data_present,                             "pulse_data_present");
        if (pulse_data_present)
            pulse_data ();
        bool tns_data_present;
        Get_SB(tns_data_present,                                "tns_data_present");
        if (tns_data_present)
            tns_data ();
        bool gain_control_data_present;
        Get_SB(gain_control_data_present,                       "gain_control_data_present");
        if (gain_control_data_present)
            gain_control_data ();
    }
    if (!aacSpectralDataResilienceFlag)
        spectral_data ();
    else
    {
        Skip_BS(Data_BS_Remain(),                               "Not implemented");
        //~ length_of_reordered_spectral_data;
        //~ length_of_longest_codeword;
        //~ reordered_spectral_data ();
    }
    Element_End0();
    ChannelPos_Temp++;
}

//---------------------------------------------------------------------------
void File_Aac::section_data()
{
    Element_Begin1("section_data");
    int8u sect_esc_val;
    if (window_sequence==2) //EIGHT_SHORT_SEQUENCE
        sect_esc_val=(1<<3)-1;
    else
        sect_esc_val=(1<<5)-1;
    for (int8u g=0; g<num_window_groups; g++)
    {
        if (num_window_groups>1)
            Element_Begin1("windows");
        int8u k=0;
        int8u i=0;
        while (k<max_sfb)
        {
            if (aacSectionDataResilienceFlag)
                Get_S1(5, sect_cb[g][i],                        "sect_cb[g][i]");
            else
                Get_S1(4, sect_cb[g][i],                        "sect_cb[g][i]");
            int8u sect_len=0;
            int8u sect_len_incr;
            if (!aacSectionDataResilienceFlag || sect_cb[g][i]<11 || (sect_cb[g][i]>11 && sect_cb[g][i]<16))
            {
                for (;;)
                {
                    if (Data_BS_Remain()==0)
                    {
                        Trusted_IsNot("Size is wrong");
                        if (num_window_groups>1)
                            Element_End0();
                        Element_End0();
                        return; //Error
                    }
                    Get_S1 ((window_sequence==2?3:5), sect_len_incr, "sect_len_incr"); // (window_sequence == EIGHT_SHORT_SEQUENCE) => 3
                    if (sect_len_incr!=sect_esc_val)
                        break;
                    sect_len+=sect_esc_val;
                }
            }
            else
                sect_len_incr=1;
            sect_len+=sect_len_incr;
            sect_start[g][i]=k;
            sect_end[g][i]=k+sect_len;
            for (int16u sfb=k; sfb<k+sect_len; sfb++)
                sfb_cb[g][sfb]=sect_cb[g][i];
            k+= sect_len;
            i++;
            if (i>64)
            {
                Trusted_IsNot("Increment is wrong");
                if (num_window_groups>1)
                    Element_End0();
                Element_End0();
                return; //Error
            }
        }
        num_sec[g]=i;
        if (num_window_groups>1)
            Element_End0();
    }
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::scale_factor_data()
{
    Element_Begin1("scale_factor_data");
    if (!aacScalefactorDataResilienceFlag)
    {
        bool noise_pcm_flag=true;
        for (int g=0; g<num_window_groups; g++)
        {
            for (int8u sfb=0; sfb<max_sfb; sfb++)
            {
                if (sfb_cb[g][sfb]) //Not ZERO_HCB
                {
                    if (is_intensity( g, sfb))
                        hcod_sf(                                "hcod_sf[dpcm_is_position[g][sfb]]");
                    else
                    {
                        if (is_noise(g, sfb))
                        {
                            if (noise_pcm_flag)
                            {
                                noise_pcm_flag = 0;
                                Skip_S2(9,                      "dpcm_noise_nrg[g][sfb]");
                            }
                            else
                                hcod_sf(                        "hcod_sf[dpcm_noise_nrg[g][sfb]]");
                        }
                        else
                            hcod_sf(                            "hcod_sf[dpcm_sf[g][sfb]]");
                    }
                }
            }
        }
    }
    else
    {
        //scale_factor_data - part not implemented
        Skip_BS(Data_BS_Remain(),                               "Not implemented");
        //~ intensity_used = 0;
        //~ noise_used = 0;
        //~ sf_concealment;
        //~ rev_global_gain;
        //~ length_of_rvlc_sf;
        //~ for ( g = 0; g < num_window_groups; g++ ) {
            //~ for ( sfb=0; sfb < max_sfb; sfb++ ) {
                //~ if ( sfb_cb[g][sfb] ) { //Not ZERO_HCB
                    //~ if ( is_intensity ( g, sfb) ) {
                        //~ intensity_used = 1;
                        //~ rvlc_cod_sf[dpcm_is_position[g][sfb]];
                    //~ } else {
                        //~ if ( is_noise(g,sfb) ) {
                            //~ if ( ! noise_used ) {
                                //~ noise_used = 1;
                                //~ dpcm_noise_nrg[g][sfb];
                            //~ } else {
                                //~ rvlc_cod_sf[dpcm_noise_nrg[g][sfb]];
                            //~ }
                        //~ } else {
                            //~ rvlc_cod_sf[dpcm_sf[g][sfb]];
                        //~ }
                    //~ }
                //~ }
            //~ }
        //~ }
        //~ if ( intensity_used ) {
            //~ rvlc_cod_sf[dpcm_is_last_position];
        //~ }
        //~ noise_used = 0;
        //~ sf_escapes_present;
        //~ if ( sf_escapes_present ) {
            //~ length_of_rvlc_escapes;
            //~ for ( g = 0; g < num_window_groups; g++ ) {
                //~ for ( sfb = 0; sfb < max_sfb; sfb++ ) {
                    //~ if ( sfb_cb[g][sfb]) {  //Not ZERO_HCB
                        //~ if ( is_intensity ( g, sfb ) &&    dpcm_is_position[g][sfb] == ESC_FLAG ) {
                            //~ rvlc_esc_sf[dpcm_is_position[g][sfb]];
                        //~ } else {
                            //~ if ( is_noise ( g, sfb ) {
                                //~ if ( ! noise_used ) {
                                    //~ noise_used = 1;
                                //~ } else {
                                    //~ if (dpcm_noise_nrg[g][sfb] == ESC_FLAG ) {
                                        //~ rvlc_esc_sf[dpcm_noise_nrg[g][sfb]];
                                    //~ }
                                //~ }
                            //~ } else {
                                //~ if (dpcm_sf[g][sfb] == ESC_FLAG ) {
                                    //~ rvlc_esc_sf[dpcm_sf[g][sfb]];
                                //~ }
                            //~ }
                        //~ }
                    //~ }
                //~ }
            //~ }
            //~ if ( intensity_used && dpcm_is_last_position == ESC_FLAG ) {
                //~ rvlc_esc_sf[dpcm_is_last_position];
            //~ }
        //~ }
        //~ if ( noise_used ) {
            //~ dpcm_noise_last_position;
        //~ }
    }
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::tns_data()
{
    int8u n_filt_bits=2;
    int8u length_bits=6;
    int8u order_bits=5;

    if (window_sequence==2) //EIGHT_SHORT_SEQUENCE
    {
        n_filt_bits=1;
        length_bits=4;
        order_bits=3;
    }

    for (int8u w=0; w<num_windows; w++)
    {
        int8u start_coef_bits, n_filt;
        Get_S1(n_filt_bits, n_filt,                             "n_filt[w]");
        if (n_filt)
        {
            bool coef_res;
            Get_SB (coef_res,                                   "coef_res[w]");
            start_coef_bits=coef_res?4:3;

            for (int8u filt=0; filt<n_filt; filt++)
            {
                int8u order;
                Skip_S1(length_bits,                            "length[w][filt]");
                Get_S1 (order_bits, order,                      "order[w][filt]");
                if (order)
                {
                    bool coef_compress;
                    Skip_SB(                                    "direction[w][filt]");
                    Get_SB (coef_compress,                      "coef_compress[w][filt]");
                    int8u coef_bits=start_coef_bits-(coef_compress?1:0);
                    for (int8u i=0; i<order; i++)
                        Skip_S1(coef_bits,                      "coef[w][filt][i]");
                }
            }
        }
    }
}

//---------------------------------------------------------------------------
void File_Aac::ltp_data()
{
    Element_Begin1("ltp_data");
    //int sfb;
    //bool ltp_lag_update;
    //if (AudioObjectType == ER_AAC_LD ) {
        //~ Get_SB(ltp_lag_update,"ltp_lag_update");
        //~ if ( ltp_lag_update ) {
            //~ Get_S2(10,ltp_lag,"ltp_lag");
        //~ } else {
            //~ //ltp_lag = ltp_prev_lag;
        //~ }
        //~ Skip_S1(3,"ltp_coef");
        //~ for (sfb = 0; sfb <(max_sfb<MAX_LTP_LONG_SFB?max_sfb:MAX_LTP_LONG_SFB);& sfb++ ) {
            //~ Skip_SB("ltp_long_used[sfb]");
        //~ }
    //} else {
        Get_S2(11,ltp_lag,                                        "ltp_lag");
        Skip_S1(3,                                                "ltp_coef");
        if(window_sequence!=2) //EIGHT_SHORT_SEQUENCE
        {
            for (int8u sfb=0; sfb<(max_sfb<40?max_sfb:40); sfb++ ) //MAX_LTP_LONG_SFB=40
                Skip_SB("ltp_long_used[sfb]");
        }
    //}
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::spectral_data()
{
    Element_Begin1("spectral_data");
    for (int g = 0; g < num_window_groups; g++)
    {
        if (num_window_groups>1)
            Element_Begin1("windows");
        for (int8u i=0; i<num_sec[g]; i++)
        {
            switch (sect_cb[g][i])
            {
                case  0 :   //ZERO_HCB
                case 13 :   //NOISE_HCB
                case 14 :   //INTENSITY_HCB2
                case 15 :   //INTENSITY_HCB
                            break;
                default :
                            if (sect_end[g][i]>=num_swb+1)
                            {
                                Trusted_IsNot("(Problem)");
                                Skip_BS(Data_BS_Remain(),       "(Problem)");
                                if (num_window_groups>1)
                                    Element_End0();
                                Element_End0();
                                return;
                            }
                            for (int16u k=sect_sfb_offset[g][sect_start[g][i]]; k<sect_sfb_offset[g][sect_end[g][i]]; k+=(sect_cb[g][i]<5?4:2))
                            {
                                hcod(sect_cb[g][i],             "sect_cb");
                                if (!Element_IsOK())
                                {
                                    Skip_BS(Data_BS_Remain(),   "(Problem)");
                                    if (num_window_groups>1)
                                        Element_End0();
                                    Element_End0();
                                    return;
                                }
                            }
            }
        }
        if (num_window_groups>1)
            Element_End0();
    }
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::extension_payload(size_t End, int8u id_aac)
{
    Element_Begin1("extension_payload");
    int8u extension_type;
    Get_S1 (4, extension_type,                                  "extension_type");
    switch(extension_type)
    {
        case 11 :   dynamic_range_info(); break;                //EXT_DYNAMIC_RANGE
        case 12 :   sac_extension_data(End); break;             //EXT_SAC_DATA
        case 13 :   sbr_extension_data(End, id_aac, 0); break;  //EXT_SBR_DATA
        case 14 :   sbr_extension_data(End, id_aac, 1); break;  //EXT_SBR_DATA_CRC
        case  1 :   //EXT_FILL_DATA
                    Skip_S1(4,                                  "fill_nibble"); Param_Info1("must be 0000");
                    if (Data_BS_Remain()>End)
                    {
                        Element_Begin1("fill_byte");
                        while (Data_BS_Remain()>End)
                            Skip_S1(8,                          "fill_byte[i]"); Param_Info1("must be 10100101");
                        Element_End0();
                    }
                    break;
        case  2 :   //EXT_DATA_ELEMENT
                    int8u data_element_version;
                    Get_S1 (4,data_element_version,             "data_element_version");
                    switch(data_element_version)
                    {
                        case 0 :    //ANC_DATA
                                    {
                                    int16u dataElementLength=0;
                                    int8u dataElementLengthPart;
                                    do
                                    {
                                        Get_S1 (8, dataElementLengthPart, "dataElementLengthPart");
                                        dataElementLength+=dataElementLengthPart;
                                    }
                                    while (dataElementLengthPart==255);
                                    Skip_BS(8*dataElementLength, "data_element_byte[i]");
                                    }
                                    break;
                        default:    ;
                    }
                    break;
        case 0 : //EXT_FILL
        default:
            Skip_BS(Data_BS_Remain()-End,                       "other_bits");
    }

    Element_End0();
    if (End<Data_BS_Remain())
        Skip_BS(Data_BS_Remain()-End,                           "padding");
    if (Data_BS_Remain()!=End)
    {
        Skip_BS(Data_BS_Remain(),                               "Wrong size");
        Trusted_IsNot("Wrong size");
    }
}

//---------------------------------------------------------------------------
void File_Aac::dynamic_range_info()
{
    Element_Begin1("dynamic_range_info");
    int8u  drc_num_bands=1;
    bool   present;
    Get_SB (present,                                            "pce_tag_present");
    if (present)
    {
        Skip_S1(4,                                              "pce_ instance_tag");
        Skip_S1(4,                                              "drc_tag_reserved_bits");
    }
    Skip_SB(                                                    "excluded_chns_present");
    Get_SB (present,                                            "drc_bands_present");
    if (present)
    {
        int8u drc_band_incr;
        Get_S1 (4, drc_band_incr,                               "drc_band_incr");
        Skip_S1(4,                                              "drc_interpolation_scheme");
        drc_num_bands+=drc_band_incr;
        for (int8u i=0; i<drc_num_bands; i++)
        {
            Skip_S1(8,                                          "drc_band_top[i]");
        }
    }
    Get_SB (present,                                            "prog_ref_level_present");
    if (present)
    {
        Skip_S1(7,                                              "prog_ref_level");
        Skip_S1(1,                                              "prog_ref_level_reserved_bits");
    }
    for (int8u i=0; i<drc_num_bands; i++)
    {
        Skip_S1(1,                                              "dyn_rng_sgn[i]");
        Skip_S1(7,                                              "dyn_rng_ctl[i]");
    }
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::sac_extension_data(size_t End)
{
    Element_Begin1("sac_extension_data");
    Skip_S1(2,                                                  "ancType");
    Skip_SB(                                                    "ancStart");
    Skip_SB(                                                    "ancStop");
    Element_Begin1("ancDataSegmentByte");
    while (Data_BS_Remain()>End)
        Skip_S1(8,                                              "ancDataSegmentByte[i]");
    Element_End0();
    Element_End0();
}

//***************************************************************************
// Elements - Perceptual noise substitution (PNS)
//***************************************************************************

//---------------------------------------------------------------------------
int File_Aac::is_intensity(size_t group, size_t sfb)
{
    switch (sfb_cb[group][sfb])
    {
        case 15 :   return 1;
        case 14 :   return -1;
        default :   return 0;
    }
}

//---------------------------------------------------------------------------
bool File_Aac::is_noise(size_t group, size_t sfb)
{
    return (sfb_cb[group][sfb]==13);
}
//---------------------------------------------------------------------------
void File_Aac::hcod_sf(const char* Name)
{
    Element_Begin1(Name);
    int16u Pos=0;

    while (huffman_sf[Pos][1])
    {
        bool h;
        Get_SB (h,                                              "huffman");
        Pos+=huffman_sf[Pos][h];

        if (Pos>240)
        {
            Skip_BS(Data_BS_Remain(),                           "Error");
            Element_End0();
            return;
        }
    }
    Element_Info1(huffman_sf[Pos][0]-60);
    Element_End0();

    return;
}

//---------------------------------------------------------------------------
void File_Aac::hcod_2step(int8u CodeBook, int8s* Values, int8u Values_Count)
{
    int8u CodeWord;
    int8u ToRead=hcb_2step_Bytes[CodeBook];
    if ((size_t)ToRead>Data_BS_Remain())
        ToRead=(int8u)Data_BS_Remain(); //Read a maximum of remaining bytes
    Peek_S1(ToRead, CodeWord);
    int16u Offset=hcb_2step[CodeBook][CodeWord].Offset;
    int8u  Extra=hcb_2step[CodeBook][CodeWord].Extra;

    if (Extra)
    {
        Skip_BS(hcb_2step_Bytes[CodeBook],                            "extra");
        int8u Offset_inc;
        Peek_S1(Extra, Offset_inc);
        Offset+=Offset_inc;
        if(hcb_table[CodeBook][Offset][0]-hcb_2step_Bytes[CodeBook])
            Skip_BS(hcb_table[CodeBook][Offset][0]-hcb_2step_Bytes[CodeBook],"extra");
    }
    else
    {
        Skip_BS(hcb_table[CodeBook][Offset][0],                 "bits");
    }

    if (Offset>=hcb_table_size[CodeBook])
    {
        Skip_BS(Data_BS_Remain(),                               "Error");
        return;
    }

    for (int8u Pos=0; Pos<Values_Count; Pos++)
        Values[Pos]=hcb_table[CodeBook][Offset][Pos+1];
}

//---------------------------------------------------------------------------
void File_Aac::hcod_binary(int8u CodeBook, int8s* Values, int8u Values_Count)
{
    int16u Offset=0;
    while (!hcb_table[CodeBook][Offset][0])
    {
        bool b;
        Get_SB(b,                                               "huffman binary");
        Offset+=hcb_table[CodeBook][Offset][1+(b?1:0)];
    }

    if (Offset>=hcb_table_size[CodeBook])
    {
        Skip_BS(Data_BS_Remain(),                               "Error");
        return;
    }

    for (int8u Pos=0; Pos<Values_Count; Pos++)
        Values[Pos]=hcb_table[CodeBook][Offset][Pos+1];
}



//***************************************************************************
// Elements - Enhanced Low Delay Codec
//***************************************************************************


//---------------------------------------------------------------------------
void File_Aac::ELDSpecificConfig ()
{
    Element_Begin1("ELDSpecificConfig");
    Skip_SB("frameLengthFlag");
    Skip_SB("aacSectionDataResilienceFlag");
    Skip_SB("aacScalefactorDataResilienceFlag");
    Skip_SB("aacSpectralDataResilienceFlag");

    bool ldSbrPresentFlag;
    Get_SB(ldSbrPresentFlag,"ldSbrPresentFlag");
    if (ldSbrPresentFlag)
    {
        Skip_SB("ldSbrSamplingRate");
        Skip_SB("ldSbrCrcFlag");
        ld_sbr_header();
    }

    int8u eldExtType;
    for (;;)
    {
        Get_S1(4,eldExtType,"eldExtType");
        if (eldExtType == 0/*ELDEXT_TERM*/)
            break;

        int8u eldExtLen,eldExtLenAdd=0;
        int16u eldExtLenAddAdd;
        Get_S1(4,eldExtLen,"eldExtLen");
        int32u len = eldExtLen;
        if (eldExtLen == 15)
        {
            Get_S1(8,eldExtLenAdd,"eldExtLenAdd");
            len += eldExtLenAdd;
        }
        if (eldExtLenAdd==255)
        {
            Get_S2(16,eldExtLenAddAdd,"eldExtLenAddAdd");
            len += eldExtLenAdd;
        }
        //~ switch (eldExtType) {
            /* add future eld extension configs here */
                //~ default:
                for(int32u cnt=0; cnt<len; cnt++)
                    Skip_S1(8,"other_byte");
                //~ break;
        //~ }

    }
    Element_End0();
}

//---------------------------------------------------------------------------
void File_Aac::ld_sbr_header()
{
    int8u numSbrHeader;
    switch (channelConfiguration)
    {
        case 1:
        case 2:
            numSbrHeader = 1;
            break;
        case 3:
            numSbrHeader = 2;
            break;
        case 4:
        case 5:
        case 6:
            numSbrHeader = 3;
            break;
        case 7:
            numSbrHeader = 4;
            break;
        default:
            numSbrHeader = 0;
            break;
    }

    for (int el=0; el<numSbrHeader; el++) {
        sbr=new sbr_handler;
        sbr_header();
        delete sbr;
    }
}

//***************************************************************************
// Helpers
//***************************************************************************

//---------------------------------------------------------------------------
void File_Aac::hcod(int8u sect_cb, const char* Name)
{
    int8s Values[4];

    Element_Begin1(Name);
    switch (sect_cb)
    {
        case  1 :
        case  2 :
        case  4 :   //4-values, 2-step method
                    hcod_2step(sect_cb, Values, 4);
                    break;
        case  3 :   //4-values, binary search method
                    hcod_binary(sect_cb, Values, 4);
                    break;
        case  5 :
        case  7 :
        case  9 :   //2-values, binary search method
                    hcod_binary(sect_cb, Values, 2);
                    break;
        case  6 :
        case  8 :
        case 10 :
        case 11 :   //2-values, 2-step method
                    hcod_2step(sect_cb, Values, 2);
                    break;
        default:    Trusted_IsNot("(Problem)");
                    Element_End0();
                    return;
    }

    switch (sect_cb)
    {
        case  1 :
        case  2 :
        case  5 :
        case  6 :
                    break;
        default :   //With sign
                    for(int i=0; i<((sect_cb<5)?4:2); i++)
                        if(Values[i])
                            Skip_SB(                            "sign");
    }

    switch (sect_cb)
    {
        case 11 : //With hcod_esc
            for (int i=0; i<2; i++)
                if (Values[i]==16 || Values[i] == -16)
                {
                    Element_Begin1("hcod_esc");
                    bool Escape;
                    int BitCount=3;
                    do
                    {
                        BitCount++;
                        Get_SB(Escape,                          "bit count");
                    }
                    while (Escape);


                    Skip_BS(BitCount,                           "value");
                    Element_End0();

                }
            break;
        default: ;
    }

    Element_End0();
}


//---------------------------------------------------------------------------
void File_Aac::FillInfosHEAACv2(const Ztring& Format_Settings)
{
    Infos["Format_Profile"] = __T("HE-AACv2");
    const Ztring Channels = Infos["Channel(s)"];
    const Ztring ChannelPositions = Infos["ChannelPositions"];
    Infos["Channel(s)"] = __T("2");
    Infos["ChannelPositions"] = __T("Front: L R");
    Infos["ChannelLayout"] = __T("L R");
    if (MediaInfoLib::Config.LegacyStreamDisplay_Get())
    {
        const Ztring SamplingRate_Previous = Infos["SamplingRate"];
        Infos["Format_Profile"] += __T(" / HE-AAC / LC");
        Infos["Channel(s)"] += __T(" / ") + Channels + __T(" / ") + Channels;
        Infos["ChannelPositions"] += __T(" / ") + ChannelPositions + __T(" / ") + ChannelPositions;
        const int32u SamplingRate = (extension_sampling_frequency_index == (int8u)-1) ? (((int32u)Frequency_b) * 2) : extension_sampling_frequency;
        if (SamplingRate)
            Infos["SamplingRate"] = Ztring().From_Number(SamplingRate, 10) + __T(" / ") + SamplingRate_Previous;
    }
    if (Infos["Format_Settings"] != Format_Settings)
    {
        if (!Infos["Format_Settings"].empty())
            Infos["Format_Settings"].insert(0, __T(" / "));
        Infos["Format_Settings"].insert(0, Format_Settings);
    }
    Infos["Format_Settings_PS"] = __T("Yes (") + Format_Settings + __T(")");
    Infos["Codec"] = Ztring().From_UTF8(Aac_audioObjectType(audioObjectType)) + __T("-SBR-PS");
}

//***************************************************************************
// C++
//***************************************************************************

} //NameSpace

#endif //MEDIAINFO_AAC_YES
