/* isocodes.c generated by valac 0.18.1, the Vala compiler
 * generated from isocodes.vala, do not modify */

/* Copyright © 2012-2013 Tobias Quathamer
 *
 * This file is part of libisocodes.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <locale.h>
#include <glib/gstdio.h>
#include <gee.h>
#include <libxml/xpath.h>


#define LIBISOCODES_TYPE_ISO_CODES (libisocodes_iso_codes_get_type ())
#define LIBISOCODES_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes))
#define LIBISOCODES_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))
#define LIBISOCODES_IS_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_IS_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_ISO_CODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))

typedef struct _libisocodesISO_Codes libisocodesISO_Codes;
typedef struct _libisocodesISO_CodesClass libisocodesISO_CodesClass;
typedef struct _libisocodesISO_CodesPrivate libisocodesISO_CodesPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _libisocodesISO_Codes {
	GObject parent_instance;
	libisocodesISO_CodesPrivate * priv;
};

struct _libisocodesISO_CodesClass {
	GObjectClass parent_class;
	gchar** (*_get_xpaths) (libisocodesISO_Codes* self, const gchar* code, int* result_length1);
	gchar** (*_get_fields) (libisocodesISO_Codes* self, int* result_length1);
};

struct _libisocodesISO_CodesPrivate {
	gchar* _iso_codes_xml_version;
	gchar* _filepath;
	gchar* _standard;
	gchar* _locale;
	xmlDoc* _xml;
};

typedef enum  {
	LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_EXIST,
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_PARSE_FILE,
	LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_CONTAIN_ISO_DATA,
	LIBISOCODES_ISO_CODES_ERROR_CODE_NOT_DEFINED
} libisocodesISOCodesError;
#define LIBISOCODES_ISO_CODES_ERROR libisocodes_iso_codes_error_quark ()

static gpointer libisocodes_iso_codes_parent_class = NULL;

GType libisocodes_iso_codes_get_type (void) G_GNUC_CONST;
#define LIBISOCODES_ISO_CODES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesPrivate))
enum  {
	LIBISOCODES_ISO_CODES_DUMMY_PROPERTY,
	LIBISOCODES_ISO_CODES_STANDARD
};
GQuark libisocodes_iso_codes_error_quark (void);
gchar* libisocodes_iso_codes_get_iso_codes_xml_version (libisocodesISO_Codes* self, GError** error);
void _libisocodes_iso_codes_open_file (libisocodesISO_Codes* self, const gchar* name, GError** error);
gchar* libisocodes_iso_codes_get_filepath (libisocodesISO_Codes* self);
void libisocodes_iso_codes_set_filepath (libisocodesISO_Codes* self, const gchar* path);
gchar* libisocodes_iso_codes_get_locale (libisocodesISO_Codes* self);
void libisocodes_iso_codes_set_locale (libisocodesISO_Codes* self, const gchar* locale);
void _libisocodes_iso_codes_setup_i18n (libisocodesISO_Codes* self);
const gchar* libisocodes_iso_codes_get_standard (libisocodesISO_Codes* self);
GeeArrayList* _libisocodes_iso_codes_find_all (libisocodesISO_Codes* self, GError** error);
gchar** _libisocodes_iso_codes_get_fields (libisocodesISO_Codes* self, int* result_length1);
void _libisocodes_iso_codes_translate (libisocodesISO_Codes* self, GeeHashMap* item, const gchar* locale);
GeeHashMap* _libisocodes_iso_codes_find_code (libisocodesISO_Codes* self, const gchar* code, GError** error);
gchar** _libisocodes_iso_codes_get_xpaths (libisocodesISO_Codes* self, const gchar* code, int* result_length1);
gboolean _libisocodes_iso_codes_is_number (libisocodesISO_Codes* self, const gchar* text);
static gchar** libisocodes_iso_codes_real__get_xpaths (libisocodesISO_Codes* self, const gchar* code, int* result_length1);
static gchar** libisocodes_iso_codes_real__get_fields (libisocodesISO_Codes* self, int* result_length1);
libisocodesISO_Codes* libisocodes_iso_codes_construct (GType object_type);
void libisocodes_iso_codes_set_standard (libisocodesISO_Codes* self, const gchar* value);
static void libisocodes_iso_codes_finalize (GObject* obj);
static void _vala_libisocodes_iso_codes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_libisocodes_iso_codes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
         * Get method for major version of the iso-codes XML files.
         * 
         * There is no set method because it does not make sense and
         * is therefore not necessary.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
gchar* libisocodes_iso_codes_get_iso_codes_xml_version (libisocodesISO_Codes* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_iso_codes_xml_version;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		_libisocodes_iso_codes_open_file (self, "", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp1_ = self->priv->_iso_codes_xml_version;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


/**
         * Get method for filepath of the XML file.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
gchar* libisocodes_iso_codes_get_filepath (libisocodesISO_Codes* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filepath;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * Set method for filepath of the XML file.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
void libisocodes_iso_codes_set_filepath (libisocodesISO_Codes* self, const gchar* path) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_filepath);
	self->priv->_filepath = _tmp1_;
	_tmp2_ = self->priv->_xml;
	if (_tmp2_ != NULL) {
		xmlDoc* _tmp3_;
		_tmp3_ = self->priv->_xml;
		xmlFreeDoc (_tmp3_);
		self->priv->_xml = NULL;
	}
}


/**
         * Get method for output locale.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
gchar* libisocodes_iso_codes_get_locale (libisocodesISO_Codes* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locale;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * Set method for output locale.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
void libisocodes_iso_codes_set_locale (libisocodesISO_Codes* self, const gchar* locale) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (locale != NULL);
	_tmp0_ = locale;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_locale);
	self->priv->_locale = _tmp1_;
}


/**
         * Set up the i18n framework.
         * 
         * This method needs to be called by every subclass.
         */
void _libisocodes_iso_codes_setup_i18n (libisocodesISO_Codes* self) {
	g_return_if_fail (self != NULL);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	setlocale (LC_ALL, "");
}


/**
         * Open and parse the file.
         * 
         * This method checks that the file exists and tries to parse
         * it.
         * 
         * @param string Filename to open, defaults to filepath.
         */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void _libisocodes_iso_codes_open_file (libisocodesISO_Codes* self, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	xmlDoc* _tmp15_ = NULL;
	xmlDoc* _tmp16_;
	xmlDoc* _tmp24_;
	xmlNode* _tmp25_ = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* root_name;
	const gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* expected_name;
	gchar* _tmp43_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		_tmp1_ = name;
		libisocodes_iso_codes_set_filepath (self, _tmp1_);
	}
	_tmp2_ = libisocodes_iso_codes_get_filepath (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	_tmp5_ = _tmp4_ == FALSE;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp6_ = _ ("The file \"%s\" could not be opened.");
		_tmp7_ = libisocodes_iso_codes_get_filepath (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_EXIST, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_inner_error_ = _tmp12_;
		if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = libisocodes_iso_codes_get_filepath (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = xmlParseFile (_tmp14_);
	self->priv->_xml = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = self->priv->_xml;
	if (_tmp16_ == NULL) {
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		_tmp17_ = _ ("The file \"%s\" could not be parsed correctly.");
		_tmp18_ = libisocodes_iso_codes_get_filepath (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf (_tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_CANNOT_PARSE_FILE, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp24_ = self->priv->_xml;
	_tmp25_ = xmlDocGetRootElement (_tmp24_);
	_tmp26_ = _tmp25_->name;
	_tmp27_ = g_strdup (_tmp26_);
	root_name = _tmp27_;
	_tmp28_ = self->priv->_standard;
	_tmp29_ = string_replace (_tmp28_, "-", "_");
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat ("iso_", _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strconcat (_tmp32_, "_entries", NULL);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	expected_name = _tmp34_;
	if (g_strcmp0 (root_name, expected_name) != 0) {
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		GError* _tmp41_;
		GError* _tmp42_;
		_tmp35_ = _ ("The file \"%s\" does not contain valid ISO %s data.");
		_tmp36_ = libisocodes_iso_codes_get_filepath (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = self->priv->_standard;
		_tmp39_ = g_strdup_printf (_tmp35_, _tmp37_, _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_CONTAIN_ISO_DATA, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		_g_free0 (_tmp37_);
		_inner_error_ = _tmp42_;
		if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (expected_name);
			_g_free0 (root_name);
			return;
		} else {
			_g_free0 (expected_name);
			_g_free0 (root_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp43_ = g_strdup ("3");
	_g_free0 (self->priv->_iso_codes_xml_version);
	self->priv->_iso_codes_xml_version = _tmp43_;
	_g_free0 (expected_name);
	_g_free0 (root_name);
}


/**
         * Return an array of all items in the ISO standard.
         * 
         * @return array All ISO 3166 items.
         */
GeeArrayList* _libisocodes_iso_codes_find_all (libisocodesISO_Codes* self, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _result_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* xpath;
	xmlDoc* _tmp8_;
	xmlDoc* _tmp9_;
	xmlXPathContext* _tmp10_;
	xmlXPathContext* context;
	xmlXPathContext* _tmp11_;
	xmlXPathContext* _tmp12_;
	const gchar* _tmp13_;
	xmlXPathObject* _tmp14_ = NULL;
	xmlXPathObject* obj;
	xmlXPathObject* _tmp15_;
	xmlNodeSet* _tmp16_;
	xmlNodeSet* nodeset;
	gint _tmp17_ = 0;
	gchar** _tmp18_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_standard;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("//iso_", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "_entry", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	xpath = _tmp7_;
	_tmp8_ = self->priv->_xml;
	if (_tmp8_ == NULL) {
		_libisocodes_iso_codes_open_file (self, "", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (xpath);
				_g_object_unref0 (_result_);
				return NULL;
			} else {
				_g_free0 (xpath);
				_g_object_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp9_ = self->priv->_xml;
	_tmp10_ = xmlXPathNewContext (_tmp9_);
	context = _tmp10_;
	_tmp11_ = context;
	_vala_assert (_tmp11_ != NULL, "context != null");
	_tmp12_ = context;
	_tmp13_ = xpath;
	_tmp14_ = xmlXPathEval (_tmp13_, _tmp12_);
	obj = _tmp14_;
	_tmp15_ = obj;
	_tmp16_ = _tmp15_->nodesetval;
	nodeset = _tmp16_;
	_tmp18_ = _libisocodes_iso_codes_get_fields (self, &_tmp17_);
	fields = _tmp18_;
	fields_length1 = _tmp17_;
	_fields_size_ = fields_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp19_;
			_tmp19_ = TRUE;
			while (TRUE) {
				gboolean _tmp20_;
				gint _tmp22_;
				xmlNodeSet* _tmp23_;
				gint _tmp24_ = 0;
				xmlNodeSet* _tmp25_;
				gint _tmp26_;
				xmlNode* _tmp27_ = NULL;
				xmlNode* node;
				GeeHashMap* _tmp28_;
				GeeHashMap* item;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp44_;
				gboolean _tmp56_ = FALSE;
				const gchar* _tmp57_;
				gboolean _tmp59_;
				GeeArrayList* _tmp62_;
				GeeHashMap* _tmp63_;
				_tmp20_ = _tmp19_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = nodeset;
				_tmp24_ = xmlXPathNodeSetGetLength (_tmp23_);
				if (!(_tmp22_ < _tmp24_)) {
					break;
				}
				_tmp25_ = nodeset;
				_tmp26_ = i;
				_tmp27_ = xmlXPathNodeSetItem (_tmp25_, _tmp26_);
				node = _tmp27_;
				_tmp28_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
				item = _tmp28_;
				_tmp29_ = fields;
				_tmp29__length1 = fields_length1;
				{
					gchar** field_collection = NULL;
					gint field_collection_length1 = 0;
					gint _field_collection_size_ = 0;
					gint field_it = 0;
					field_collection = _tmp29_;
					field_collection_length1 = _tmp29__length1;
					for (field_it = 0; field_it < _tmp29__length1; field_it = field_it + 1) {
						gchar* _tmp30_;
						gchar* field = NULL;
						_tmp30_ = g_strdup (field_collection[field_it]);
						field = _tmp30_;
						{
							GeeHashMap* _tmp31_;
							const gchar* _tmp32_;
							xmlNode* _tmp33_;
							const gchar* _tmp34_;
							gchar* _tmp35_ = NULL;
							gchar* _tmp36_;
							GeeHashMap* _tmp37_;
							const gchar* _tmp38_;
							gpointer _tmp39_ = NULL;
							gchar* _tmp40_;
							gboolean _tmp41_;
							_tmp31_ = item;
							_tmp32_ = field;
							_tmp33_ = node;
							_tmp34_ = field;
							_tmp35_ = xmlGetProp (_tmp33_, _tmp34_);
							_tmp36_ = _tmp35_;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp32_, _tmp36_);
							_g_free0 (_tmp36_);
							_tmp37_ = item;
							_tmp38_ = field;
							_tmp39_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp37_, _tmp38_);
							_tmp40_ = (gchar*) _tmp39_;
							_tmp41_ = _tmp40_ == NULL;
							_g_free0 (_tmp40_);
							if (_tmp41_) {
								GeeHashMap* _tmp42_;
								const gchar* _tmp43_;
								_tmp42_ = item;
								_tmp43_ = field;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, _tmp43_, "");
							}
							_g_free0 (field);
						}
					}
				}
				_tmp44_ = self->priv->_standard;
				if (g_strcmp0 (_tmp44_, "3166-2") == 0) {
					GeeHashMap* _tmp45_;
					xmlNode* _tmp46_;
					xmlNode* _tmp47_;
					xmlNode* _tmp48_;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_;
					GeeHashMap* _tmp51_;
					xmlNode* _tmp52_;
					xmlNode* _tmp53_;
					gchar* _tmp54_ = NULL;
					gchar* _tmp55_;
					_tmp45_ = item;
					_tmp46_ = node;
					_tmp47_ = _tmp46_->parent;
					_tmp48_ = _tmp47_->parent;
					_tmp49_ = xmlGetProp (_tmp48_, "code");
					_tmp50_ = _tmp49_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp45_, "country", _tmp50_);
					_g_free0 (_tmp50_);
					_tmp51_ = item;
					_tmp52_ = node;
					_tmp53_ = _tmp52_->parent;
					_tmp54_ = xmlGetProp (_tmp53_, "type");
					_tmp55_ = _tmp54_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp51_, "type", _tmp55_);
					_g_free0 (_tmp55_);
				}
				_tmp57_ = self->priv->_locale;
				if (_tmp57_ != NULL) {
					const gchar* _tmp58_;
					_tmp58_ = self->priv->_locale;
					_tmp56_ = g_strcmp0 (_tmp58_, "") != 0;
				} else {
					_tmp56_ = FALSE;
				}
				_tmp59_ = _tmp56_;
				if (_tmp59_) {
					GeeHashMap* _tmp60_;
					const gchar* _tmp61_;
					_tmp60_ = item;
					_tmp61_ = self->priv->_locale;
					_libisocodes_iso_codes_translate (self, _tmp60_, _tmp61_);
				}
				_tmp62_ = _result_;
				_tmp63_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp63_);
				_g_object_unref0 (item);
			}
		}
	}
	result = _result_;
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_xmlXPathFreeContext0 (context);
	_g_free0 (xpath);
	return result;
}


/**
         * Find the given code or codes with the given XPath.
         * 
         * @param string Code to search for.
         */
GeeHashMap* _libisocodes_iso_codes_find_code (libisocodesISO_Codes* self, const gchar* code, GError** error) {
	GeeHashMap* result = NULL;
	gboolean did_not_find_code;
	GeeHashMap* _tmp0_;
	GeeHashMap* _result_;
	xmlDoc* _tmp1_;
	xmlDoc* _tmp2_;
	xmlXPathContext* _tmp3_;
	xmlXPathContext* context;
	xmlXPathContext* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	gchar** _tmp7_ = NULL;
	gchar** xpaths;
	gint xpaths_length1;
	gint _xpaths_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp48_;
	gboolean _tmp56_ = FALSE;
	const gchar* _tmp57_;
	gboolean _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	did_not_find_code = TRUE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_xml;
	if (_tmp1_ == NULL) {
		_libisocodes_iso_codes_open_file (self, "", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (_result_);
				return NULL;
			} else {
				_g_object_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp2_ = self->priv->_xml;
	_tmp3_ = xmlXPathNewContext (_tmp2_);
	context = _tmp3_;
	_tmp4_ = context;
	_vala_assert (_tmp4_ != NULL, "context != null");
	_tmp5_ = code;
	_tmp7_ = _libisocodes_iso_codes_get_xpaths (self, _tmp5_, &_tmp6_);
	xpaths = _tmp7_;
	xpaths_length1 = _tmp6_;
	_xpaths_size_ = xpaths_length1;
	_tmp8_ = xpaths;
	_tmp8__length1 = xpaths_length1;
	{
		gchar** xpath_collection = NULL;
		gint xpath_collection_length1 = 0;
		gint _xpath_collection_size_ = 0;
		gint xpath_it = 0;
		xpath_collection = _tmp8_;
		xpath_collection_length1 = _tmp8__length1;
		for (xpath_it = 0; xpath_it < _tmp8__length1; xpath_it = xpath_it + 1) {
			gchar* _tmp9_;
			gchar* xpath = NULL;
			_tmp9_ = g_strdup (xpath_collection[xpath_it]);
			xpath = _tmp9_;
			{
				xmlXPathContext* _tmp10_;
				const gchar* _tmp11_;
				xmlXPathObject* _tmp12_ = NULL;
				xmlXPathObject* obj;
				xmlXPathObject* _tmp13_;
				xmlNodeSet* _tmp14_;
				xmlNodeSet* nodeset;
				xmlNodeSet* _tmp15_;
				gint _tmp16_ = 0;
				_tmp10_ = context;
				_tmp11_ = xpath;
				_tmp12_ = xmlXPathEval (_tmp11_, _tmp10_);
				obj = _tmp12_;
				_tmp13_ = obj;
				_tmp14_ = _tmp13_->nodesetval;
				nodeset = _tmp14_;
				_tmp15_ = nodeset;
				_tmp16_ = xmlXPathNodeSetGetLength (_tmp15_);
				if (_tmp16_ == 1) {
					gint _tmp17_ = 0;
					gchar** _tmp18_ = NULL;
					gchar** fields;
					gint fields_length1;
					gint _fields_size_;
					xmlNodeSet* _tmp19_;
					xmlNode* _tmp20_ = NULL;
					xmlNode* node;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp36_;
					_tmp18_ = _libisocodes_iso_codes_get_fields (self, &_tmp17_);
					fields = _tmp18_;
					fields_length1 = _tmp17_;
					_fields_size_ = fields_length1;
					_tmp19_ = nodeset;
					_tmp20_ = xmlXPathNodeSetItem (_tmp19_, 0);
					node = _tmp20_;
					_tmp21_ = fields;
					_tmp21__length1 = fields_length1;
					{
						gchar** field_collection = NULL;
						gint field_collection_length1 = 0;
						gint _field_collection_size_ = 0;
						gint field_it = 0;
						field_collection = _tmp21_;
						field_collection_length1 = _tmp21__length1;
						for (field_it = 0; field_it < _tmp21__length1; field_it = field_it + 1) {
							gchar* _tmp22_;
							gchar* field = NULL;
							_tmp22_ = g_strdup (field_collection[field_it]);
							field = _tmp22_;
							{
								GeeHashMap* _tmp23_;
								const gchar* _tmp24_;
								xmlNode* _tmp25_;
								const gchar* _tmp26_;
								gchar* _tmp27_ = NULL;
								gchar* _tmp28_;
								GeeHashMap* _tmp29_;
								const gchar* _tmp30_;
								gpointer _tmp31_ = NULL;
								gchar* _tmp32_;
								gboolean _tmp33_;
								_tmp23_ = _result_;
								_tmp24_ = field;
								_tmp25_ = node;
								_tmp26_ = field;
								_tmp27_ = xmlGetProp (_tmp25_, _tmp26_);
								_tmp28_ = _tmp27_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, _tmp28_);
								_g_free0 (_tmp28_);
								_tmp29_ = _result_;
								_tmp30_ = field;
								_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
								_tmp32_ = (gchar*) _tmp31_;
								_tmp33_ = _tmp32_ == NULL;
								_g_free0 (_tmp32_);
								if (_tmp33_) {
									GeeHashMap* _tmp34_;
									const gchar* _tmp35_;
									_tmp34_ = _result_;
									_tmp35_ = field;
									gee_abstract_map_set ((GeeAbstractMap*) _tmp34_, _tmp35_, "");
								}
								_g_free0 (field);
							}
						}
					}
					_tmp36_ = self->priv->_standard;
					if (g_strcmp0 (_tmp36_, "3166-2") == 0) {
						GeeHashMap* _tmp37_;
						xmlNode* _tmp38_;
						xmlNode* _tmp39_;
						xmlNode* _tmp40_;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_;
						GeeHashMap* _tmp43_;
						xmlNode* _tmp44_;
						xmlNode* _tmp45_;
						gchar* _tmp46_ = NULL;
						gchar* _tmp47_;
						_tmp37_ = _result_;
						_tmp38_ = node;
						_tmp39_ = _tmp38_->parent;
						_tmp40_ = _tmp39_->parent;
						_tmp41_ = xmlGetProp (_tmp40_, "code");
						_tmp42_ = _tmp41_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, "country", _tmp42_);
						_g_free0 (_tmp42_);
						_tmp43_ = _result_;
						_tmp44_ = node;
						_tmp45_ = _tmp44_->parent;
						_tmp46_ = xmlGetProp (_tmp45_, "type");
						_tmp47_ = _tmp46_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp43_, "type", _tmp47_);
						_g_free0 (_tmp47_);
					}
					did_not_find_code = FALSE;
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xpath);
					break;
				}
				_g_free0 (xpath);
			}
		}
	}
	_tmp48_ = did_not_find_code;
	if (_tmp48_) {
		const gchar* _tmp49_ = NULL;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_;
		GError* _tmp54_;
		GError* _tmp55_;
		_tmp49_ = _ ("The code \"%s\" is not defined in ISO %s.");
		_tmp50_ = code;
		_tmp51_ = self->priv->_standard;
		_tmp52_ = g_strdup_printf (_tmp49_, _tmp50_, _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_CODE_NOT_DEFINED, _tmp53_);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp53_);
		_inner_error_ = _tmp55_;
		if (_inner_error_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error_);
			xpaths = (_vala_array_free (xpaths, xpaths_length1, (GDestroyNotify) g_free), NULL);
			_xmlXPathFreeContext0 (context);
			_g_object_unref0 (_result_);
			return NULL;
		} else {
			xpaths = (_vala_array_free (xpaths, xpaths_length1, (GDestroyNotify) g_free), NULL);
			_xmlXPathFreeContext0 (context);
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp57_ = self->priv->_locale;
	if (_tmp57_ != NULL) {
		const gchar* _tmp58_;
		_tmp58_ = self->priv->_locale;
		_tmp56_ = g_strcmp0 (_tmp58_, "") != 0;
	} else {
		_tmp56_ = FALSE;
	}
	_tmp59_ = _tmp56_;
	if (_tmp59_) {
		GeeHashMap* _tmp60_;
		const gchar* _tmp61_;
		_tmp60_ = _result_;
		_tmp61_ = self->priv->_locale;
		_libisocodes_iso_codes_translate (self, _tmp60_, _tmp61_);
	}
	result = _result_;
	xpaths = (_vala_array_free (xpaths, xpaths_length1, (GDestroyNotify) g_free), NULL);
	_xmlXPathFreeContext0 (context);
	return result;
}


/**
         * Translate an item to the wanted locale.
         * 
         * @param HashMap<string, string> Entry to be translated
         * @param string Locale to use for translation
         */
void _libisocodes_iso_codes_translate (libisocodesISO_Codes* self, GeeHashMap* item, const gchar* locale) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** fields_to_translate;
	gint fields_to_translate_length1;
	gint _fields_to_translate_size_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* loc_backup;
	const gchar* _tmp7_ = NULL;
	const gchar* env;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* env_backup;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* domain;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (locale != NULL);
	_tmp0_ = g_strdup ("name");
	_tmp1_ = g_strdup ("official_name");
	_tmp2_ = g_strdup ("common_name");
	_tmp3_ = g_strdup ("currency_name");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	fields_to_translate = _tmp4_;
	fields_to_translate_length1 = 4;
	_fields_to_translate_size_ = fields_to_translate_length1;
	_tmp5_ = setlocale (LC_ALL, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	loc_backup = _tmp6_;
	_tmp7_ = g_getenv ("LANGUAGE");
	env = _tmp7_;
	_tmp8_ = env;
	_tmp9_ = g_strdup (_tmp8_);
	env_backup = _tmp9_;
	_tmp10_ = locale;
	g_setenv ("LANGUAGE", _tmp10_, TRUE);
	setlocale (LC_ALL, "");
	_tmp11_ = self->priv->_standard;
	_tmp12_ = string_replace (_tmp11_, "-", "_");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat ("iso_", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	domain = _tmp15_;
	_tmp16_ = fields_to_translate;
	_tmp16__length1 = fields_to_translate_length1;
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp16_;
		field_collection_length1 = _tmp16__length1;
		for (field_it = 0; field_it < _tmp16__length1; field_it = field_it + 1) {
			gchar* _tmp17_;
			gchar* field = NULL;
			_tmp17_ = g_strdup (field_collection[field_it]);
			field = _tmp17_;
			{
				gboolean _tmp18_ = FALSE;
				GeeHashMap* _tmp19_;
				const gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp26_;
				_tmp19_ = item;
				_tmp20_ = field;
				_tmp21_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp19_, _tmp20_);
				if (_tmp21_) {
					GeeHashMap* _tmp22_;
					const gchar* _tmp23_;
					gpointer _tmp24_ = NULL;
					gchar* _tmp25_;
					_tmp22_ = item;
					_tmp23_ = field;
					_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
					_tmp25_ = (gchar*) _tmp24_;
					_tmp18_ = g_strcmp0 (_tmp25_, "") != 0;
					_g_free0 (_tmp25_);
				} else {
					_tmp18_ = FALSE;
				}
				_tmp26_ = _tmp18_;
				if (_tmp26_) {
					GeeHashMap* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					GeeHashMap* _tmp30_;
					const gchar* _tmp31_;
					gpointer _tmp32_ = NULL;
					gchar* _tmp33_;
					const gchar* _tmp34_ = NULL;
					_tmp27_ = item;
					_tmp28_ = field;
					_tmp29_ = domain;
					_tmp30_ = item;
					_tmp31_ = field;
					_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, _tmp31_);
					_tmp33_ = (gchar*) _tmp32_;
					_tmp34_ = g_dgettext (_tmp29_, _tmp33_);
					gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp34_);
					_g_free0 (_tmp33_);
				}
				_g_free0 (field);
			}
		}
	}
	_tmp35_ = env_backup;
	g_setenv ("LANGUAGE", _tmp35_, TRUE);
	_tmp36_ = loc_backup;
	setlocale (LC_ALL, _tmp36_);
	_g_free0 (domain);
	_g_free0 (env_backup);
	_g_free0 (loc_backup);
	fields_to_translate = (_vala_array_free (fields_to_translate, fields_to_translate_length1, (GDestroyNotify) g_free), NULL);
}


/**
         * Determine whether a given string represents a number.
         */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean _libisocodes_iso_codes_is_number (libisocodesISO_Codes* self, const gchar* text) {
	gboolean result = FALSE;
	gboolean contains_only_digits;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint length;
	gint index;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	contains_only_digits = TRUE;
	_tmp0_ = text;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	length = _tmp2_;
	index = 0;
	while (TRUE) {
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gchar _tmp7_ = '\0';
		gboolean _tmp8_ = FALSE;
		gint _tmp9_;
		_tmp3_ = index;
		_tmp4_ = length;
		if (!(_tmp3_ < _tmp4_)) {
			break;
		}
		_tmp5_ = text;
		_tmp6_ = index;
		_tmp7_ = string_get (_tmp5_, (glong) _tmp6_);
		_tmp8_ = g_ascii_isdigit (_tmp7_);
		if (!_tmp8_) {
			contains_only_digits = FALSE;
			break;
		}
		_tmp9_ = index;
		index = _tmp9_ + 1;
	}
	result = contains_only_digits;
	return result;
}


/**
         * Return all XPaths which should be tested with the given code.
         * 
         * @param string Code to search for, e.g. 'DE', 'DEU', '788'.
         * @return string[] Array of XPaths which are applicable to the code.
         */
static gchar** libisocodes_iso_codes_real__get_xpaths (libisocodesISO_Codes* self, const gchar* code, int* result_length1) {
	g_critical ("Type `%s' does not implement abstract method `_libisocodes_iso_codes_get_xpaths'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar** _libisocodes_iso_codes_get_xpaths (libisocodesISO_Codes* self, const gchar* code, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return LIBISOCODES_ISO_CODES_GET_CLASS (self)->_get_xpaths (self, code, result_length1);
}


/**
         * Return all fields of the current ISO standard.
         * 
         * This is needed for constructing the HashMap.
         * 
         * @return string[] Array with the names of all fields in the current standard.
         */
static gchar** libisocodes_iso_codes_real__get_fields (libisocodesISO_Codes* self, int* result_length1) {
	g_critical ("Type `%s' does not implement abstract method `_libisocodes_iso_codes_get_fields'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar** _libisocodes_iso_codes_get_fields (libisocodesISO_Codes* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return LIBISOCODES_ISO_CODES_GET_CLASS (self)->_get_fields (self, result_length1);
}


libisocodesISO_Codes* libisocodes_iso_codes_construct (GType object_type) {
	libisocodesISO_Codes * self = NULL;
	self = (libisocodesISO_Codes*) g_object_new (object_type, NULL);
	return self;
}


const gchar* libisocodes_iso_codes_get_standard (libisocodesISO_Codes* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_standard;
	result = _tmp0_;
	return result;
}


void libisocodes_iso_codes_set_standard (libisocodesISO_Codes* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_standard);
	self->priv->_standard = _tmp1_;
	g_object_notify ((GObject *) self, "standard");
}


static void libisocodes_iso_codes_class_init (libisocodesISO_CodesClass * klass) {
	libisocodes_iso_codes_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (libisocodesISO_CodesPrivate));
	LIBISOCODES_ISO_CODES_CLASS (klass)->_get_xpaths = libisocodes_iso_codes_real__get_xpaths;
	LIBISOCODES_ISO_CODES_CLASS (klass)->_get_fields = libisocodes_iso_codes_real__get_fields;
	G_OBJECT_CLASS (klass)->get_property = _vala_libisocodes_iso_codes_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_libisocodes_iso_codes_set_property;
	G_OBJECT_CLASS (klass)->finalize = libisocodes_iso_codes_finalize;
	/**
	         * The ISO standard currently in use.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBISOCODES_ISO_CODES_STANDARD, g_param_spec_string ("standard", "standard", "standard", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void libisocodes_iso_codes_instance_init (libisocodesISO_Codes * self) {
	gchar* _tmp0_;
	self->priv = LIBISOCODES_ISO_CODES_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_iso_codes_xml_version = _tmp0_;
	self->priv->_xml = NULL;
}


static void libisocodes_iso_codes_finalize (GObject* obj) {
	libisocodesISO_Codes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes);
	_g_free0 (self->priv->_iso_codes_xml_version);
	_g_free0 (self->priv->_filepath);
	_g_free0 (self->priv->_standard);
	_g_free0 (self->priv->_locale);
	G_OBJECT_CLASS (libisocodes_iso_codes_parent_class)->finalize (obj);
}


GType libisocodes_iso_codes_get_type (void) {
	static volatile gsize libisocodes_iso_codes_type_id__volatile = 0;
	if (g_once_init_enter (&libisocodes_iso_codes_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (libisocodesISO_CodesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) libisocodes_iso_codes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (libisocodesISO_Codes), 0, (GInstanceInitFunc) libisocodes_iso_codes_instance_init, NULL };
		GType libisocodes_iso_codes_type_id;
		libisocodes_iso_codes_type_id = g_type_register_static (G_TYPE_OBJECT, "libisocodesISO_Codes", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&libisocodes_iso_codes_type_id__volatile, libisocodes_iso_codes_type_id);
	}
	return libisocodes_iso_codes_type_id__volatile;
}


static void _vala_libisocodes_iso_codes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	libisocodesISO_Codes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes);
	switch (property_id) {
		case LIBISOCODES_ISO_CODES_STANDARD:
		g_value_set_string (value, libisocodes_iso_codes_get_standard (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_libisocodes_iso_codes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	libisocodesISO_Codes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes);
	switch (property_id) {
		case LIBISOCODES_ISO_CODES_STANDARD:
		libisocodes_iso_codes_set_standard (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



