/*
 *  @(#)IPathHistory.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1;


/**
 * Records the states and transition history during a path traversal.
 * The instance can be cloned for the cases of errors and warnings needing to
 * store the path history when they occured.  The instance should also support
 * a toString() method for easy debugging and logging.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:24 $
 * @since      June 12, 2002
 */
public interface IPathHistory
{
    /**
     * When the current state changes, add the new state here.  This should
     * be called for the start state, and once at the end of every successful
     * transition.
     */
    public void addState( IState s );
    
    
    /**
     * When a transition is about to occur, it should be added here.
     */
    public void addTransition( ITransition t );
    
    
    /**
     * After a validation call, the error results should be added here.
     */
    public void addValidate( IValidate val, IState owningState,
            IErrors errors );
    
    
    /**
     * After a validation call, the error results should be added here.
     */
    public void addValidate( IValidate val, ITransition owningTransition,
            IErrors errors );
    
    
    /**
     * Returns the total number of errors (halts, failures, and errors)
     * registered during validation and transitions.
     */
    public int getErrorCount();
    
    
    /**
     * Returns a copy of this instance.  The copied instance must not change
     * when the parent copy changes.
     */
    public IPathHistory copy();
}

